/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageUtil {
    private static final Logger log = LoggerFactory.getLogger(PageUtil.class);

    public static <T> void doPaginate(Paginator paginator, Function<Paginator, PaginateResult<T>> doPaginate) throws InterruptedException {
        int pageNum = Optional.ofNullable(paginator).map(Paginator::getPageNum).orElse(1);
        int pageSize = Optional.ofNullable(paginator).map(Paginator::getPageSize).orElse(20);
        paginator = Optional.ofNullable(paginator).orElse(new Paginator());
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException("interrupted");
            }
            paginator.setPageNum(pageNum);
            paginator.setPageSize(pageSize);
            log.debug("paginator: {}", (Object)paginator);
            PaginateResult<T> page = doPaginate.apply(paginator);
            log.debug("paginate result: {}", page);
            if (CollectionUtils.isEmpty(page.getData()) || CollectionUtils.size(page.getData()) < pageSize) break;
            ++pageNum;
        }
        log.debug("paginator complete");
    }

    public static class Paginator {
        int pageNum = 1;
        int pageSize = 20;

        public int getPageNum() {
            return this.pageNum;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public Paginator setPageNum(int pageNum) {
            this.pageNum = pageNum;
            return this;
        }

        public Paginator setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Paginator)) {
                return false;
            }
            Paginator other = (Paginator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPageNum() != other.getPageNum()) {
                return false;
            }
            return this.getPageSize() == other.getPageSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Paginator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPageNum();
            result = result * 59 + this.getPageSize();
            return result;
        }

        public String toString() {
            return "PageUtil.Paginator(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ")";
        }
    }

    public static class PaginateResult<T>
    extends Paginator {
        List<T> data;
        int totalCount;

        public List<T> getData() {
            return this.data;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public PaginateResult<T> setData(List<T> data) {
            this.data = data;
            return this;
        }

        public PaginateResult<T> setTotalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public String toString() {
            return "PageUtil.PaginateResult(super=" + super.toString() + ", totalCount=" + this.getTotalCount() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaginateResult)) {
                return false;
            }
            PaginateResult other = (PaginateResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.getTotalCount() != other.getTotalCount()) {
                return false;
            }
            List<T> this$data = this.getData();
            List<T> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PaginateResult;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.getTotalCount();
            List<T> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }
    }
}

