/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.utils;

import com.aliyun.credentials.Client;
import com.aliyun.dataworks_public20240518.models.CreateNodeRequest;
import com.aliyun.dataworks_public20240518.models.CreateNodeResponse;
import com.aliyun.dataworks_public20240518.models.CreatePipelineRunRequest;
import com.aliyun.dataworks_public20240518.models.CreatePipelineRunResponse;
import com.aliyun.dataworks_public20240518.models.CreateResourceAdvanceRequest;
import com.aliyun.dataworks_public20240518.models.CreateResourceRequest;
import com.aliyun.dataworks_public20240518.models.CreateResourceResponse;
import com.aliyun.dataworks_public20240518.models.CreateWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.CreateWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.DeleteFolderRequest;
import com.aliyun.dataworks_public20240518.models.DeleteFolderResponse;
import com.aliyun.dataworks_public20240518.models.DeleteNodeRequest;
import com.aliyun.dataworks_public20240518.models.DeleteNodeResponse;
import com.aliyun.dataworks_public20240518.models.DeleteWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.DeleteWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.ExecPipelineRunStageRequest;
import com.aliyun.dataworks_public20240518.models.ExecPipelineRunStageResponse;
import com.aliyun.dataworks_public20240518.models.GetJobStatusRequest;
import com.aliyun.dataworks_public20240518.models.GetJobStatusResponse;
import com.aliyun.dataworks_public20240518.models.GetNodeRequest;
import com.aliyun.dataworks_public20240518.models.GetNodeResponse;
import com.aliyun.dataworks_public20240518.models.GetPipelineRunRequest;
import com.aliyun.dataworks_public20240518.models.GetPipelineRunResponse;
import com.aliyun.dataworks_public20240518.models.GetProjectRequest;
import com.aliyun.dataworks_public20240518.models.GetProjectResponse;
import com.aliyun.dataworks_public20240518.models.GetResourceRequest;
import com.aliyun.dataworks_public20240518.models.GetResourceResponse;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceLogRequest;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceLogResponse;
import com.aliyun.dataworks_public20240518.models.GetWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.GetWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.GetWorkflowInstanceRequest;
import com.aliyun.dataworks_public20240518.models.GetWorkflowInstanceResponse;
import com.aliyun.dataworks_public20240518.models.ImportWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.ImportWorkflowDefinitionResponse;
import com.aliyun.dataworks_public20240518.models.ListDataSourcesRequest;
import com.aliyun.dataworks_public20240518.models.ListDataSourcesResponse;
import com.aliyun.dataworks_public20240518.models.ListFoldersRequest;
import com.aliyun.dataworks_public20240518.models.ListFoldersResponse;
import com.aliyun.dataworks_public20240518.models.ListNodeDependenciesRequest;
import com.aliyun.dataworks_public20240518.models.ListNodeDependenciesResponse;
import com.aliyun.dataworks_public20240518.models.ListNodesRequest;
import com.aliyun.dataworks_public20240518.models.ListNodesResponse;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunItemsRequest;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunItemsResponse;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunsRequest;
import com.aliyun.dataworks_public20240518.models.ListPipelineRunsResponse;
import com.aliyun.dataworks_public20240518.models.ListProjectMembersRequest;
import com.aliyun.dataworks_public20240518.models.ListProjectMembersResponse;
import com.aliyun.dataworks_public20240518.models.ListProjectsRequest;
import com.aliyun.dataworks_public20240518.models.ListProjectsResponse;
import com.aliyun.dataworks_public20240518.models.ListResourceGroupsRequest;
import com.aliyun.dataworks_public20240518.models.ListResourceGroupsResponse;
import com.aliyun.dataworks_public20240518.models.ListResourcesRequest;
import com.aliyun.dataworks_public20240518.models.ListResourcesResponse;
import com.aliyun.dataworks_public20240518.models.ListTaskInstancesRequest;
import com.aliyun.dataworks_public20240518.models.ListTaskInstancesResponse;
import com.aliyun.dataworks_public20240518.models.ListWorkflowDefinitionsRequest;
import com.aliyun.dataworks_public20240518.models.ListWorkflowDefinitionsResponse;
import com.aliyun.dataworks_public20240518.models.UpdateNodeRequest;
import com.aliyun.dataworks_public20240518.models.UpdateNodeResponse;
import com.aliyun.dataworks_public20240518.models.UpdateResourceAdvanceRequest;
import com.aliyun.dataworks_public20240518.models.UpdateResourceResponse;
import com.aliyun.dataworks_public20240518.models.UpdateWorkflowDefinitionRequest;
import com.aliyun.dataworks_public20240518.models.UpdateWorkflowDefinitionResponse;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwNewideInfraClient {
    private static final Logger log = LoggerFactory.getLogger(DwNewideInfraClient.class);
    private com.aliyun.dataworks_public20240518.Client client;
    private Integer maxRetryCount = 3;
    private Long delayIntervalMax = 5000L;
    private Long delayIntervalMin = 1000L;
    private Long delayInterval = 200L;
    private Long apiCallCount = 0L;
    private List<String> RETRY_EXCEPTION_LIST = List.of("code: 400, Throttling.User", "code: 417, Your request is too frequent. Try again later.");

    public DwNewideInfraClient(com.aliyun.dataworks_public20240518.Client client) {
        this.client = client;
    }

    public DwNewideInfraClient(String accessKeyId, String accessKeySecret, String securityToken, String endpoint, String region) {
        Client credential = new Client();
        Config config = new Config().setCredential(credential).setEndpoint(endpoint).setRegionId(region).setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret).setSecurityToken(securityToken);
        try {
            this.client = new com.aliyun.dataworks_public20240518.Client(config);
        }
        catch (Exception e) {
            log.error("Create DwNewideClient error", (Throwable)e);
        }
        this.apiCallCount = 0L;
    }

    public void qpsControl(Integer qps) {
        qps = qps > 20 ? 20 : qps;
        qps = qps < 1 ? 1 : qps;
        this.delayInterval = Integer.toUnsignedLong(1000 / qps);
    }

    private Boolean isRetryException(Exception e) {
        for (String exception : this.RETRY_EXCEPTION_LIST) {
            if (!ObjectUtils.isNotEmpty((Object)e.getCause()) || !e.getCause().toString().contains(exception)) continue;
            return true;
        }
        return false;
    }

    public Long getApiCallCount() {
        return this.apiCallCount;
    }

    public Object callApi(String apiName, Object request) throws Exception {
        Integer execCount = 0;
        while (true) {
            try {
                Integer n = execCount;
                execCount = execCount + 1;
                if (execCount > 1) {
                    Long ramdomdelayInterval = this.delayIntervalMin + (long)(Math.random() * (double)(this.delayIntervalMax - this.delayIntervalMin));
                    Thread.sleep(ramdomdelayInterval);
                    log.info(apiName + " retry, execCount={}", (Object)execCount);
                }
                Class<com.aliyun.dataworks_public20240518.Client> clazz = com.aliyun.dataworks_public20240518.Client.class;
                Method method = clazz.getMethod(apiName, request.getClass());
                Thread.sleep(this.delayInterval);
                Long l = this.apiCallCount;
                this.apiCallCount = this.apiCallCount + 1L;
                if (this.apiCallCount % 100L == 0L) {
                    log.info("\u672c\u6b21\u7d2f\u8ba1\u8c03\u7528api\u6b21\u6570\u8fbe{}\uff0c\u6ce8\u610fapi\u6d88\u8017\u3002API\u989d\u5ea6\uff1ahttps://help.aliyun.com/zh/dataworks/developer-reference/use-dataworks-openapi#9043e6a325tiq", (Object)this.apiCallCount);
                }
                Object result = method.invoke((Object)this.client, request);
                if (execCount > 1) {
                    log.info(apiName + " retry success, execCount={}", (Object)execCount);
                }
                return result;
            }
            catch (Exception e) {
                if (!this.isRetryException(e).booleanValue()) {
                    log.error(apiName + " error: " + String.valueOf(e.getCause()));
                    throw e;
                }
                if (execCount > this.maxRetryCount) {
                    log.error(apiName + " error, retry count exceed max retry count: " + e);
                    throw e;
                }
                log.info("Fail Request. Retry after random delay interval...");
                continue;
            }
            break;
        }
    }

    public Object callApiWithRuntimeOption(String apiName, Object request) throws Exception {
        Integer execCount = 0;
        while (true) {
            try {
                Integer n = execCount;
                execCount = execCount + 1;
                if (execCount > 1) {
                    Long ramdomdelayInterval = this.delayIntervalMin + (long)(Math.random() * (double)(this.delayIntervalMax - this.delayIntervalMin));
                    Thread.sleep(ramdomdelayInterval);
                    log.info(apiName + " retry, execCount={}", (Object)execCount);
                }
                Class<com.aliyun.dataworks_public20240518.Client> clazz = com.aliyun.dataworks_public20240518.Client.class;
                Method method = clazz.getMethod(apiName, request.getClass(), RuntimeOptions.class);
                Thread.sleep(this.delayInterval);
                Long l = this.apiCallCount;
                this.apiCallCount = this.apiCallCount + 1L;
                if (this.apiCallCount % 100L == 0L) {
                    log.info("\u672c\u6b21\u7d2f\u8ba1\u8c03\u7528api\u6b21\u6570\u8fbe{}\uff0c\u6ce8\u610fapi\u6d88\u8017\u3002API\u989d\u5ea6\uff1ahttps://help.aliyun.com/zh/dataworks/developer-reference/use-dataworks-openapi#9043e6a325tiq", (Object)this.apiCallCount);
                }
                Object result = method.invoke((Object)this.client, request, new RuntimeOptions());
                if (execCount > 1) {
                    log.info(apiName + " retry success, execCount={}", (Object)execCount);
                }
                return result;
            }
            catch (Exception e) {
                if (!this.isRetryException(e).booleanValue()) {
                    log.error(apiName + " error: " + String.valueOf(e.getCause()));
                    throw e;
                }
                if (execCount > this.maxRetryCount) {
                    log.error(apiName + " error, retry count exceed max retry count: " + e);
                    throw e;
                }
                log.info("Fail Request. Retry after random delay interval...");
                continue;
            }
            break;
        }
    }

    public ListProjectsResponse listProjects(ListProjectsRequest request) throws Exception {
        return (ListProjectsResponse)this.callApi("listProjects", request);
    }

    public GetProjectResponse getProject(GetProjectRequest request) throws Exception {
        return (GetProjectResponse)this.callApi("getProject", request);
    }

    public ListProjectMembersResponse listProjectMembers(ListProjectMembersRequest request) throws Exception {
        return (ListProjectMembersResponse)this.callApi("listProjectMembers", request);
    }

    public ListResourceGroupsResponse listResourceGroups(ListResourceGroupsRequest request) throws Exception {
        return (ListResourceGroupsResponse)this.callApi("listResourceGroups", request);
    }

    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest request) throws Exception {
        return (ListDataSourcesResponse)this.callApi("listDataSources", request);
    }

    public CreateWorkflowDefinitionResponse createWorkflowDefinition(CreateWorkflowDefinitionRequest request) throws Exception {
        return (CreateWorkflowDefinitionResponse)this.callApi("createWorkflowDefinition", request);
    }

    public ImportWorkflowDefinitionResponse importWorkflowDefinition(ImportWorkflowDefinitionRequest request) throws Exception {
        return (ImportWorkflowDefinitionResponse)this.callApi("importWorkflowDefinition", request);
    }

    public UpdateWorkflowDefinitionResponse updateWorkflowDefinition(UpdateWorkflowDefinitionRequest request) throws Exception {
        return (UpdateWorkflowDefinitionResponse)this.callApi("updateWorkflowDefinition", request);
    }

    public ListWorkflowDefinitionsResponse listWorkflowDefinitions(ListWorkflowDefinitionsRequest request) throws Exception {
        return (ListWorkflowDefinitionsResponse)this.callApi("listWorkflowDefinitions", request);
    }

    public GetWorkflowDefinitionResponse getWorkflowDefinition(GetWorkflowDefinitionRequest request) throws Exception {
        return (GetWorkflowDefinitionResponse)this.callApi("getWorkflowDefinition", request);
    }

    public DeleteWorkflowDefinitionResponse deleteWorkflowDefinition(DeleteWorkflowDefinitionRequest request) throws Exception {
        return (DeleteWorkflowDefinitionResponse)this.callApi("deleteWorkflowDefinition", request);
    }

    public CreateNodeResponse createNode(CreateNodeRequest request) throws Exception {
        return (CreateNodeResponse)this.callApi("createNode", request);
    }

    public UpdateNodeResponse updateNode(UpdateNodeRequest request) throws Exception {
        return (UpdateNodeResponse)this.callApi("updateNode", request);
    }

    public ListNodesResponse listNodes(ListNodesRequest request) throws Exception {
        return (ListNodesResponse)this.callApi("listNodes", request);
    }

    public GetNodeResponse getNode(GetNodeRequest request) throws Exception {
        return (GetNodeResponse)this.callApi("getNode", request);
    }

    public ListNodeDependenciesResponse listNodeDependencies(ListNodeDependenciesRequest request) throws Exception {
        return (ListNodeDependenciesResponse)this.callApi("listNodeDependencies", request);
    }

    public DeleteNodeResponse deleteNode(DeleteNodeRequest request) throws Exception {
        return (DeleteNodeResponse)this.callApi("deleteNode", request);
    }

    public ListFoldersResponse listFolders(ListFoldersRequest request) throws Exception {
        return (ListFoldersResponse)this.callApi("listFolders", request);
    }

    public DeleteFolderResponse deleteFolder(DeleteFolderRequest request) throws Exception {
        return (DeleteFolderResponse)this.callApi("deleteFolder", request);
    }

    public ListResourcesResponse listResources(ListResourcesRequest request) throws Exception {
        return (ListResourcesResponse)this.callApi("listResources", request);
    }

    public GetResourceResponse getResource(GetResourceRequest request) throws Exception {
        return (GetResourceResponse)this.callApi("getResource", request);
    }

    public CreateResourceResponse createResource(CreateResourceRequest request) throws Exception {
        return (CreateResourceResponse)this.callApi("createResource", request);
    }

    public CreateResourceResponse createResourceAdvance(CreateResourceAdvanceRequest request) throws Exception {
        return (CreateResourceResponse)this.callApiWithRuntimeOption("createResourceAdvance", request);
    }

    public UpdateResourceResponse updateResourceAdvance(UpdateResourceAdvanceRequest request) throws Exception {
        return (UpdateResourceResponse)this.callApiWithRuntimeOption("updateResourceAdvance", request);
    }

    public GetJobStatusResponse getJobStatus(GetJobStatusRequest request) throws Exception {
        return (GetJobStatusResponse)this.callApi("getJobStatus", request);
    }

    public CreatePipelineRunResponse createPipelineRun(CreatePipelineRunRequest request) throws Exception {
        return (CreatePipelineRunResponse)this.callApi("createPipelineRun", request);
    }

    public ListPipelineRunsResponse listPipelineRuns(ListPipelineRunsRequest request) throws Exception {
        return (ListPipelineRunsResponse)this.callApi("listPipelineRuns", request);
    }

    public GetPipelineRunResponse getPipelineRun(GetPipelineRunRequest request) throws Exception {
        return (GetPipelineRunResponse)this.callApi("getPipelineRun", request);
    }

    public ListPipelineRunItemsResponse listPipelineRunItems(ListPipelineRunItemsRequest request) throws Exception {
        return (ListPipelineRunItemsResponse)this.callApi("listPipelineRunItems", request);
    }

    public ExecPipelineRunStageResponse execPipelineRunStage(ExecPipelineRunStageRequest request) throws Exception {
        return (ExecPipelineRunStageResponse)this.callApi("execPipelineRunStage", request);
    }

    public ListTaskInstancesResponse listTaskInstances(ListTaskInstancesRequest request) throws Exception {
        return (ListTaskInstancesResponse)this.callApi("listTaskInstances", request);
    }

    public GetWorkflowInstanceResponse getWorkflowInstance(GetWorkflowInstanceRequest request) throws Exception {
        return (GetWorkflowInstanceResponse)this.callApi("getWorkflowInstance", request);
    }

    public GetTaskInstanceLogResponse getTaskInstanceLog(GetTaskInstanceLogRequest request) throws Exception {
        return (GetTaskInstanceLogResponse)this.callApi("getTaskInstanceLog", request);
    }
}

