/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.serializes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLocalDateTimeDeserializer
extends LocalDateTimeDeserializer {
    private static final Logger log = LoggerFactory.getLogger(CustomLocalDateTimeDeserializer.class);
    private static String[] formatArray = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "EEE, dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd"};

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        LocalDateTime date;
        if (6 == jsonParser.getCurrentTokenId() && Objects.nonNull(date = this.parseDateTraverseFormat(jsonParser.getText().trim()))) {
            return date;
        }
        return super.deserialize(jsonParser, deserializationContext);
    }

    private LocalDateTime parseDateTraverseFormat(String value) {
        for (String dateFormat : formatArray) {
            try {
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern(dateFormat);
                return LocalDateTime.parse(value, fmt);
            }
            catch (Exception exception) {
            }
        }
        log.error("failed to parse data String:{}", (Object)value);
        return null;
    }
}

