/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.jarload;

import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class JarLoader
extends URLClassLoader {
    public JarLoader(String[] paths) {
        this(paths, JarLoader.class.getClassLoader());
    }

    public JarLoader(String[] paths, ClassLoader parent) {
        super(JarLoader.getURLs(paths), parent);
    }

    private static URL[] getURLs(String[] paths) {
        Validate.isTrue((null != paths && 0 != paths.length ? 1 : 0) != 0, (String)"jar\u5305\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a.", (Object[])new Object[0]);
        ArrayList<String> dirs = new ArrayList<String>();
        for (String path : paths) {
            dirs.add(path);
            JarLoader.collectDirs(path, dirs);
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : dirs) {
            urls.addAll(JarLoader.doGetURLs(path));
        }
        return urls.toArray(new URL[0]);
    }

    private static void collectDirs(String path, List<String> collector) {
        if (null == path || StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        File current = new File(path);
        if (!current.exists() || !current.isDirectory()) {
            return;
        }
        for (File child : current.listFiles()) {
            if (!child.isDirectory()) continue;
            collector.add(child.getAbsolutePath());
            JarLoader.collectDirs(child.getAbsolutePath(), collector);
        }
    }

    private static List<URL> doGetURLs(String path) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)path) ? 1 : 0) != 0, (String)"jar\u5305\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a.", (Object[])new Object[0]);
        File jarPath = new File(path);
        Validate.isTrue((jarPath.exists() && jarPath.isDirectory() ? 1 : 0) != 0, (String)"jar\u5305\u8def\u5f84\u5fc5\u987b\u5b58\u5728\u4e14\u4e3a\u76ee\u5f55.", (Object[])new Object[0]);
        FileFilter jarFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        };
        File[] allJars = new File(path).listFiles(jarFilter);
        ArrayList<URL> jarURLs = new ArrayList<URL>(allJars.length);
        for (int i = 0; i < allJars.length; ++i) {
            try {
                jarURLs.add(allJars[i].toURI().toURL());
                continue;
            }
            catch (Exception e) {
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PLUGIN_INIT_ERROR, (String)"\u7cfb\u7edf\u52a0\u8f7djar\u5305\u51fa\u9519", (Throwable)e);
            }
        }
        return jarURLs;
    }
}

