/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.file;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.constant.report.StatisticsReportConstant;
import com.aliyun.migration.api.constant.report.WorkflowDatasourceSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowFunctionSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowNodeSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowResourceSheetProperties;
import com.aliyun.migration.api.constant.report.WorkflowSheetProperties;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.tea.NameInMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmPackageXlsReportFileOperator {
    private static final Logger log = LoggerFactory.getLogger(BwmPackageXlsReportFileOperator.class);

    public static StatisticOp makeStatisticOp(WorkflowProjectPackage pkg) {
        StatisticOp statisticOp = new StatisticOp();
        WorkflowSheetProperties workflowSheetProperties = new WorkflowSheetProperties();
        WorkflowNodeSheetProperties workflowNodeSheetProperties = new WorkflowNodeSheetProperties();
        WorkflowResourceSheetProperties workflowResourceSheetProperties = new WorkflowResourceSheetProperties();
        WorkflowFunctionSheetProperties workflowFunctionSheetProperties = new WorkflowFunctionSheetProperties();
        WorkflowDatasourceSheetProperties workflowDatasourceSheetProperties = new WorkflowDatasourceSheetProperties();
        for (Workflow wf : pkg.getWorkflowList()) {
            if (wf.getWorkflowNodes() != null) {
                Iterator nodeTypeStatisticEachWorkflow = new HashMap();
                for (WorkflowNode node : wf.getWorkflowNodes()) {
                    String completeNodeType = node.getNodeType() + (String)(StringUtils.isBlank((CharSequence)node.getDbType()) ? "" : "(" + node.getDbType() + ")");
                    nodeTypeStatisticEachWorkflow.put(completeNodeType, nodeTypeStatisticEachWorkflow.getOrDefault(completeNodeType, 0) + 1);
                    statisticOp.nodeTypeStatistic.put(completeNodeType, statisticOp.nodeTypeStatistic.getOrDefault(completeNodeType, 0) + 1);
                    workflowNodeSheetProperties.setPropertyValue(wf, node);
                    statisticOp.getWorkflowNodeTotalStatisticOp().incrementOne(String.join((CharSequence)StatisticsReportConstant.SPILT_DELIMITER, workflowNodeSheetProperties.getValuesForExcel()));
                }
                statisticOp.nodeTypeStatisticEachWorkflow.put(wf.getWorkflowId(), nodeTypeStatisticEachWorkflow);
            }
            if (wf.getFiles() != null) {
                for (WorkflowFileResource file : wf.getFiles()) {
                    workflowResourceSheetProperties.setPropertyValue(file);
                    statisticOp.getWorkflowResourceTotalStatisticOp().incrementOne(String.join((CharSequence)StatisticsReportConstant.SPILT_DELIMITER, workflowResourceSheetProperties.getValuesForExcel()));
                }
            }
            if (wf.getFunctions() == null) continue;
            for (WorkflowFunctionResource func : wf.getFunctions()) {
                workflowFunctionSheetProperties.setPropertyValue(func);
                statisticOp.getWorkflowFunTotalStatisticOp().incrementOne(String.join((CharSequence)StatisticsReportConstant.SPILT_DELIMITER, workflowFunctionSheetProperties.getValuesForExcel()));
            }
        }
        for (Workflow wf : pkg.getWorkflowList()) {
            workflowSheetProperties.setPropertyValue(wf);
            StringBuilder msg = new StringBuilder();
            msg.append(String.join((CharSequence)StatisticsReportConstant.SPILT_DELIMITER, workflowSheetProperties.getValuesForExcel()));
            for (String typeName : statisticOp.getNodeTypeStatistic().keySet()) {
                msg.append(StatisticsReportConstant.SPILT_DELIMITER).append(ObjectUtils.defaultIfNull((Object)((Integer)((Map)statisticOp.nodeTypeStatisticEachWorkflow.get(wf.getWorkflowId())).get(typeName)), (Object)0));
            }
            statisticOp.getWorkflowTotalStatisticOp().incrementOne(msg.toString());
        }
        if (pkg.getDatasources() != null) {
            for (WorkflowDatasource ds : pkg.getDatasources()) {
                workflowDatasourceSheetProperties.setPropertyValue(ds);
                statisticOp.getWorkflowDataSocTotalStatisticOp().incrementOne(String.join((CharSequence)StatisticsReportConstant.SPILT_DELIMITER, workflowDatasourceSheetProperties.getValuesForExcel()));
            }
        }
        return statisticOp;
    }

    public static void writeStatisticOp(StatisticOp statisticOp, File targetFile) throws IOException {
        if (statisticOp == null) {
            return;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        BwmPackageXlsReportFileOperator.exportWorkflowOverviewSta(workbook, statisticOp, BwmPackageXlsReportFileOperator.getDefaultXlsCellStyle(workbook));
        Arrays.stream(StatisticsReportConstant.StatisticEntity.values()).filter(entity -> entity.getIsForExcel()).toList().forEach(entity -> {
            try {
                BwmPackageXlsReportFileOperator.writeXLS((StatisticOp.StatisticIterm)BwmPackageXlsReportFileOperator.processAnnotations(statisticOp, entity.getStatisticOpName()), workbook, entity.name(), entity.getHeader(), BwmPackageXlsReportFileOperator.getXlsCellStyleByCanModifySwitch(entity.getColumnsCanModify(), workbook));
            }
            catch (IllegalAccessException e) {
                log.error("reader.export.statistic.error", (Throwable)e);
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_WRITE_FAILED);
            }
        });
        HSSFRow wfSheetHead = workbook.getSheet(StatisticsReportConstant.StatisticEntity.WORKFLOW.name()).getRow(0);
        Integer colIndex = wfSheetHead.getPhysicalNumberOfCells();
        for (String nodeType : statisticOp.getNodeTypeStatistic().keySet()) {
            Integer n = colIndex;
            colIndex = colIndex + 1;
            wfSheetHead.createCell(n.intValue()).setCellValue(nodeType);
        }
        File overviewFile = targetFile;
        if (!targetFile.getName().endsWith(".xls")) {
            overviewFile = new File(targetFile, "LHMPackageOverview.xls");
        }
        if (!overviewFile.getParentFile().exists()) {
            FileUtils.forceMkdir((File)overviewFile.getParentFile());
        }
        if (!overviewFile.exists()) {
            overviewFile.createNewFile();
        }
        FileOutputStream fileOut = new FileOutputStream(overviewFile);
        workbook.write((OutputStream)fileOut);
        workbook.close();
        fileOut.close();
    }

    private static CellStyle getDefaultXlsCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        cellStyle.setDataFormat((short)49);
        return cellStyle;
    }

    private static List<CellStyle> getXlsCellStyleByCanModifySwitch(List<Boolean> canModifySwitch, HSSFWorkbook workbook) {
        if (canModifySwitch == null || canModifySwitch.isEmpty()) {
            return new ArrayList<CellStyle>();
        }
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>();
        for (Boolean canModify : canModifySwitch) {
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
            cellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
            cellStyle.setDataFormat((short)49);
            HSSFFont font = workbook.createFont();
            if (canModify.booleanValue()) {
                font.setColor(IndexedColors.valueOf((String)StatisticsReportConstant.CAN_MODIFY_COLOR).getIndex());
            } else {
                font.setColor(IndexedColors.valueOf((String)StatisticsReportConstant.DEFAULT_COLOR).getIndex());
            }
            cellStyle.setFont((Font)font);
            cellStyleList.add((CellStyle)cellStyle);
        }
        return cellStyleList;
    }

    private static void exportWorkflowOverviewSta(HSSFWorkbook workbook, StatisticOp statisticOp, CellStyle cellStyle) {
        HSSFSheet sheet = workbook.createSheet("\u6982\u89c8");
        Integer lineIndex = 0;
        Object object = lineIndex;
        lineIndex = lineIndex + 1;
        BwmPackageXlsReportFileOperator.fillNewRow(sheet.createRow(((Integer)object).intValue()), List.of("Package\u6982\u89c8"), cellStyle);
        object = lineIndex;
        lineIndex = lineIndex + 1;
        BwmPackageXlsReportFileOperator.fillNewRow(sheet.createRow(((Integer)object).intValue()), List.of("Workflow\u6570\u91cf", Integer.valueOf(statisticOp.getWorkflowTotalStatisticOp().getAtomicInteger().get())), cellStyle);
        object = lineIndex;
        lineIndex = lineIndex + 1;
        BwmPackageXlsReportFileOperator.fillNewRow(sheet.createRow(((Integer)object).intValue()), List.of("WorkflowNode\u603b\u6570\u91cf", Integer.valueOf(statisticOp.getWorkflowNodeTotalStatisticOp().getAtomicInteger().get())), cellStyle);
        if (statisticOp.nodeTypeStatistic.keySet().size() > 0) {
            object = lineIndex;
            lineIndex = lineIndex + 1;
            BwmPackageXlsReportFileOperator.fillNewRow(sheet.createRow(((Integer)object).intValue()), List.of("\u7c7b\u578b", "\u6570\u91cf"), cellStyle);
            for (String nodeType : statisticOp.nodeTypeStatistic.keySet()) {
                Integer n = lineIndex;
                lineIndex = lineIndex + 1;
                BwmPackageXlsReportFileOperator.fillNewRow(sheet.createRow(n.intValue()), List.of("", nodeType, ((Integer)statisticOp.nodeTypeStatistic.get(nodeType)).toString()), cellStyle);
            }
        }
        object = lineIndex;
        lineIndex = lineIndex + 1;
        BwmPackageXlsReportFileOperator.fillNewRow(sheet.createRow(((Integer)object).intValue()), List.of("FileResource\u6570\u91cf", String.valueOf(statisticOp.getWorkflowResourceTotalStatisticOp().getAtomicInteger().get())), cellStyle);
        object = lineIndex;
        lineIndex = lineIndex + 1;
        BwmPackageXlsReportFileOperator.fillNewRow(sheet.createRow(((Integer)object).intValue()), List.of("Function\u6570\u91cf", String.valueOf(statisticOp.getWorkflowFunTotalStatisticOp().getAtomicInteger().get())), cellStyle);
        CellRangeAddress cellRange = new CellRangeAddress(1, 10, 4, 8);
        sheet.addMergedRegion(cellRange);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        HSSFFont font = workbook.createFont();
        font.setColor(IndexedColors.valueOf((String)StatisticsReportConstant.CAN_MODIFY_COLOR).getIndex());
        style.setFont((Font)font);
        HSSFCell cell = sheet.getRow(1).createCell(4);
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue("\u4f7f\u7528\u8bf4\u660e\uff1a\n\u672c\u8868\u683c\u4e3aLHM\u8c03\u5ea6\u6570\u636e\u5305\u7684\u7edf\u8ba1\u8868\uff0c\u4ee5\u5e73\u94fa\u7684\u65b9\u5f0f\u5c55\u793a\u4e86\u5305\u4e2dWorkflow\u3001WorkflowNode\u3001WorkflowResource\u3001Function\u3001DataSource\u7684\u6761\u76ee\u53ca\u5176\u4e3b\u8981\u5c5e\u6027\u3002\n\u540c\u65f6\uff0c\u5de5\u5177\u5141\u8bb8\u7528\u6237\u901a\u8fc7\u7f16\u8f91\u8868\u683c\u4ee5\u4fee\u6539\u8c03\u5ea6\u5c5e\u6027\uff0c\u5141\u8bb8\u4fee\u6539\u7684\u5b57\u6bb5\u4ee5\u84dd\u8272\u5b57\u4f53\u6807\u8bc6\u3002");
    }

    private static void fillNewRow(HSSFRow row, List<Object> values, List<CellStyle> cellStyle, HSSFWorkbook workbook) {
        while (cellStyle.size() < values.size()) {
            cellStyle.add(BwmPackageXlsReportFileOperator.getDefaultXlsCellStyle(workbook));
        }
        for (int i = 0; i < values.size(); ++i) {
            HSSFCell cell = row.createCell(i, CellType.BLANK);
            cell.setCellStyle(cellStyle.get(i));
            cell.setCellValue((String)(String.valueOf(values.get(i)).length() > 32000 ? "(\u8d85\u957f\u5f02\u5e38)" + String.valueOf(values.get(i)).substring(0, 32000) + " ..." : String.valueOf(values.get(i))));
        }
    }

    private static void fillNewRow(HSSFRow row, List<Object> values, CellStyle cellStyle) {
        for (int i = 0; i < values.size(); ++i) {
            HSSFCell cell = row.createCell(i, CellType.BLANK);
            cell.setCellStyle(cellStyle);
            cell.setCellValue((String)(String.valueOf(values.get(i)).length() > 32000 ? "(\u8d85\u957f\u5f02\u5e38)" + String.valueOf(values.get(i)).substring(0, 32000) + " ..." : String.valueOf(values.get(i))));
        }
    }

    static void writeXLS(StatisticOp.StatisticIterm iterm, HSSFWorkbook workbook, String sheetName, String header, List<CellStyle> cellStyleList) {
        HSSFSheet sheet = workbook.createSheet(sheetName);
        Integer lineIndex = 0;
        Integer n = lineIndex;
        lineIndex = lineIndex + 1;
        BwmPackageXlsReportFileOperator.fillNewRow(sheet.createRow(n.intValue()), List.of(header.split(StatisticsReportConstant.SPILT_DELIMITER)), cellStyleList, workbook);
        if (iterm.getAtomicInteger().get() > 0) {
            for (Pair workflowResourceString : iterm.getItermAndMsgs()) {
                Integer n2 = lineIndex;
                lineIndex = lineIndex + 1;
                BwmPackageXlsReportFileOperator.fillNewRow(sheet.createRow(n2.intValue()), List.of(((String)workflowResourceString.getKey()).split(StatisticsReportConstant.SPILT_DELIMITER)), cellStyleList, workbook);
            }
        }
    }

    static void writeCSV(StatisticOp.StatisticIterm iterm, File file, String header) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter writerFile = new BufferedWriter(new FileWriter(file, Charset.forName("GB2312")));
        writerFile.write(header);
        writerFile.newLine();
        if (iterm.getAtomicInteger().get() > 0) {
            for (Pair workflowResourceString : iterm.getItermAndMsgs()) {
                writerFile.write((String)workflowResourceString.getKey());
                writerFile.newLine();
            }
        }
        writerFile.flush();
        writerFile.close();
    }

    public static Object processAnnotations(Object obj, String annotationName) throws IllegalAccessException {
        Field[] fields;
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(NameInMap.class)) continue;
            NameInMap annotation = field.getAnnotation(NameInMap.class);
            String nodeName = annotation.value();
            field.setAccessible(true);
            if (!nodeName.equals(annotationName)) continue;
            return field.get(obj);
        }
        return null;
    }

    public static void getChangeFromStatisticXls(WorkflowProjectPackage pkg, File file) {
        if (!(file != null && file.exists() && file.isFile() && file.getName().endsWith(".xls"))) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u7edf\u8ba1\u8868\uff0c\u8df3\u8fc7\u6279\u91cf\u4fee\u6539");
            return;
        }
        log.info("\u83b7\u53d6\u5230\u6709\u6548\u7684\u7edf\u8ba1\u8868\uff0c\u5f00\u59cb\u6279\u91cf\u4fee\u6539\u5305\u5185\u4fe1\u606f");
        HashMap<String, Workflow> workflowMap = new HashMap<String, Workflow>();
        HashMap<String, WorkflowNode> workflowNodeMap = new HashMap<String, WorkflowNode>();
        for (Workflow workflow2 : pkg.getWorkflowList()) {
            workflowMap.put(workflow2.getWorkflowId(), workflow2);
            for (WorkflowNode workflowNode : workflow2.getWorkflowNodes()) {
                workflowNodeMap.put(workflowNode.getNodeId(), workflowNode);
            }
        }
        try (FileInputStream fis = new FileInputStream(file);){
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fis);
            Sheet workflowSheet = workbook.getSheet(StatisticsReportConstant.StatisticEntity.WORKFLOW.name());
            if (workflowSheet != null) {
                HashMap<Workflow, Boolean> workflowExistedMap = new HashMap<Workflow, Boolean>();
                for (Workflow wf : pkg.getWorkflowList()) {
                    workflowExistedMap.put(wf, false);
                }
                Row headerRow = workflowSheet.getRow(0);
                ArrayList<String> headerList = new ArrayList<String>();
                for (int i = 0; i < headerRow.getPhysicalNumberOfCells(); ++i) {
                    headerList.add(BwmPackageXlsReportFileOperator.getCellValue(headerRow, i));
                }
                WorkflowSheetProperties workflowSheetProperties = new WorkflowSheetProperties(headerList);
                for (int line_index = 1; line_index < workflowSheet.getPhysicalNumberOfRows(); ++line_index) {
                    Workflow workflow3;
                    Row row = workflowSheet.getRow(line_index);
                    ArrayList<String> rowList = new ArrayList<String>();
                    for (int i = 0; i < row.getPhysicalNumberOfCells(); ++i) {
                        rowList.add(BwmPackageXlsReportFileOperator.getCellValue(row, i));
                    }
                    workflowSheetProperties.setPropertyValue(rowList);
                    String workflowId = BwmPackageXlsReportFileOperator.getCellValue(row, 0);
                    if (StringUtils.isEmpty((CharSequence)workflowId) || !workflowMap.containsKey(workflowId)) {
                        workflow3 = new Workflow();
                        log.info("create workflowId:{}", (Object)workflowId);
                        workflowSheetProperties.createWorkflowFromExcel(workflow3);
                        pkg.getWorkflowList().add(workflow3);
                        workflowMap.put(workflowId, workflow3);
                        workflowExistedMap.put(workflow3, true);
                        continue;
                    }
                    workflow3 = (Workflow)workflowMap.get(workflowId);
                    workflowExistedMap.put(workflow3, true);
                    workflowSheetProperties.setWorkflowPropertyValueFromExcel(workflow3);
                }
                workflowExistedMap.forEach((workflow, existed) -> {
                    if (!existed.booleanValue()) {
                        pkg.getWorkflowList().remove(workflow);
                    }
                });
            } else {
                log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684{}\u5de5\u4f5c\u8868\uff0c\u8df3\u8fc7\u6279\u91cf\u4fee\u6539", (Object)StatisticsReportConstant.StatisticEntity.WORKFLOW.name());
            }
            Sheet nodeSheet = workbook.getSheet(StatisticsReportConstant.StatisticEntity.WORKFLOW_NODE.name());
            if (nodeSheet != null) {
                Row nodeSheetHeaderRow = nodeSheet.getRow(0);
                ArrayList<String> nodeSheetHeaderList = new ArrayList<String>();
                for (int i = 0; i < nodeSheetHeaderRow.getPhysicalNumberOfCells(); ++i) {
                    nodeSheetHeaderList.add(BwmPackageXlsReportFileOperator.getCellValue(nodeSheetHeaderRow, i));
                }
                WorkflowNodeSheetProperties workflowNodeSheetProperties = new WorkflowNodeSheetProperties(nodeSheetHeaderList);
                ArrayList newRelationPackages = new ArrayList();
                for (int line_index = 1; line_index < nodeSheet.getPhysicalNumberOfRows(); ++line_index) {
                    WorkflowNode workflowNode;
                    Row row = nodeSheet.getRow(line_index);
                    ArrayList<String> rowList = new ArrayList<String>();
                    for (int i = 0; i < row.getPhysicalNumberOfCells(); ++i) {
                        rowList.add(BwmPackageXlsReportFileOperator.getCellValue(row, i));
                    }
                    workflowNodeSheetProperties.setPropertyValue(rowList);
                    String workflowNodeId = BwmPackageXlsReportFileOperator.getCellValue(row, 0);
                    if (!workflowNodeMap.containsKey(workflowNodeId)) {
                        List<File> scriptFiles;
                        log.info("create workflowNodeId:{}", (Object)workflowNodeId);
                        workflowNode = new WorkflowNode();
                        ArrayList relationPackages = new ArrayList();
                        workflowNodeSheetProperties.createNewNodeFromExcel(workflowNode, relationPackages);
                        if (StringUtils.isBlank((CharSequence)workflowNode.getScript()) && CollectionUtils.isNotEmpty(scriptFiles = BwmPackageXlsReportFileOperator.findFilesByNameWithoutExtension(file.getParentFile().getAbsolutePath(), workflowNode.getNodeName() + "#" + workflowNode.getNodeId()))) {
                            File scriptFile = scriptFiles.get(0);
                            String script = FileUtils.readFileToString((File)scriptFile);
                            workflowNode.setScript(script);
                        }
                        newRelationPackages.addAll(relationPackages);
                        workflowNodeMap.put(workflowNodeId, workflowNode);
                        if (StringUtils.isNotBlank((CharSequence)workflowNode.getWorkflowId()) && workflowMap.containsKey(workflowNode.getWorkflowId())) {
                            if (((Workflow)workflowMap.get(workflowNode.getWorkflowId())).getWorkflowNodes() == null) {
                                ((Workflow)workflowMap.get(workflowNode.getWorkflowId())).setWorkflowNodes(new ArrayList());
                            }
                            ((Workflow)workflowMap.get(workflowNode.getWorkflowId())).getWorkflowNodes().add(workflowNode);
                            if (((Workflow)workflowMap.get(workflowNode.getWorkflowId())).getNodeRelations() == null) {
                                ((Workflow)workflowMap.get(workflowNode.getWorkflowId())).setNodeRelations(new ArrayList());
                            }
                            ((Workflow)workflowMap.get(workflowNode.getWorkflowId())).getNodeRelations().addAll(relationPackages);
                            continue;
                        }
                        log.info("create node but not found workflow, workflowNodeId:{}", (Object)workflowNodeId);
                        continue;
                    }
                    workflowNode = (WorkflowNode)workflowNodeMap.get(workflowNodeId);
                    workflowNodeSheetProperties.setNodePropertyValueFromExcel(workflowNode);
                }
                for (RelationPackage relationPackage : newRelationPackages) {
                    if (workflowMap.containsKey(relationPackage.getFrom())) {
                        relationPackage.setReType(RelationPackage.ReType.WORKFLOW_NODE);
                        continue;
                    }
                    if (!workflowNodeMap.containsKey(relationPackage.getFrom())) continue;
                    relationPackage.setReType(RelationPackage.ReType.NODE);
                }
            } else {
                log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684{}\u5de5\u4f5c\u8868\uff0c\u8df3\u8fc7\u6279\u91cf\u4fee\u6539", (Object)StatisticsReportConstant.StatisticEntity.WORKFLOW_NODE.name());
            }
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> cutParamFromString(String text, char splitLetter, char expressionLetter) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return new HashMap<String, Object>();
        }
        if (!text.contains(String.valueOf(expressionLetter))) {
            log.info("\u8c03\u5ea6\u53c2\u6570\u4e3a\u7b49\u53f7\u8868\u8fbe\u5f0f\uff0c\u4f46\u83b7\u53d6\u5230\u4e00\u4e2a\u4e0d\u5305\u542b=\u7684\u503c\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\uff1a", (Object)text);
            return new HashMap<String, Object>();
        }
        int commaPos = -1;
        int equalPos = 0;
        String key = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Integer pos = 0;
        while (pos < text.length()) {
            String value;
            if (text.charAt(pos) == splitLetter) {
                commaPos = pos;
            }
            if (text.charAt(pos) == expressionLetter) {
                if (!StringUtils.isEmpty(key) && !StringUtils.isEmpty((CharSequence)(value = text.substring(equalPos + 1, commaPos)))) {
                    paramMap.put(key, value);
                }
                equalPos = pos;
                key = text.substring(commaPos + 1, equalPos);
            }
            if (pos == text.length() - 1 && !StringUtils.isEmpty((CharSequence)(value = text.substring(equalPos + 1)))) {
                paramMap.put(key, value);
            }
            Integer n = pos;
            pos = pos + 1;
        }
        return paramMap;
    }

    private static String getCellValue(Row row, Integer index) {
        if (row.getCell(index.intValue()) == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)row.getCell(index.intValue()).getStringCellValue())) {
            return null;
        }
        return row.getCell(index.intValue()).getStringCellValue();
    }

    private String makeMapping(List<String> obj) {
        JSONObject mapping = new JSONObject();
        if (obj != null && obj.size() > 0) {
            obj.forEach(s -> mapping.put(s, s));
        }
        return mapping.toJSONString(new JSONWriter.Feature[0]);
    }

    private String makeMapping(Map<String, Object> obj) {
        JSONObject mapping = new JSONObject();
        if (obj != null && obj.size() == 0) {
            obj.forEach((k, v) -> mapping.put(k, v));
        }
        return mapping.toJSONString(new JSONWriter.Feature[0]);
    }

    public static List<File> findFilesByNameWithoutExtension(String rootFolderPath, String targetFileName) {
        ArrayList<File> targetFiles = new ArrayList<File>();
        File rootFolder = new File(rootFolderPath);
        if (!rootFolder.exists() || !rootFolder.isDirectory()) {
            return targetFiles;
        }
        BwmPackageXlsReportFileOperator.searchFilesRecursively(rootFolder, targetFileName, targetFiles);
        return targetFiles;
    }

    private static void searchFilesRecursively(File folder, String targetFileName, List<File> result) {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileNameWithoutExtension;
            if (file.isDirectory()) {
                BwmPackageXlsReportFileOperator.searchFilesRecursively(file, targetFileName, result);
                continue;
            }
            if (!file.isFile()) continue;
            String fileName = file.getName();
            int lastDotIndex = fileName.lastIndexOf(46);
            String string = fileNameWithoutExtension = lastDotIndex == -1 ? fileName : fileName.substring(0, lastDotIndex);
            if (!targetFileName.equals(fileNameWithoutExtension)) continue;
            result.add(file);
        }
    }
}

