/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.file;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.api.utils.UuidUtils;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmPackageSrMergeFileOperator {
    private static final Logger log = LoggerFactory.getLogger(BwmPackageSrMergeFileOperator.class);
    private static Charset charset = Charset.forName("UTF-8");

    public static void writeMigrationSrConflictFile(JSONArray conflictElement, BwmSaasConfiguration bwmSaasConfiguration) {
        if (conflictElement == null || conflictElement.isEmpty()) {
            log.warn("\u672a\u83b7\u53d6\u5230ConflictElement\u5217\u8868\uff0c\u8df3\u8fc7\u5b58\u50a8");
            return;
        }
        String srFilePath = bwmSaasConfiguration.getMigrationSrStatisticsFileSavePath("merge_conflict");
        JSONArray result = new JSONArray();
        Integer i = 0;
        while (i < conflictElement.size()) {
            JSONObject jsonObject = conflictElement.getJSONObject(i.intValue());
            jsonObject.put((Object)"gmt_create", (Object)AbstractSheetProperties.getCurrentTime());
            jsonObject.put((Object)"gmt_modified", (Object)AbstractSheetProperties.getCurrentTime());
            jsonObject.put((Object)"tenant_id", (Object)bwmSaasConfiguration.getMeta().getTenantUuid());
            jsonObject.put((Object)"merge_instance_id", (Object)bwmSaasConfiguration.getMeta().getInstanceUuid());
            jsonObject.put((Object)"uuid", (Object)UuidUtils.randomUuidByObject((Object)jsonObject));
            result.add((Object)jsonObject);
            Integer n = i;
            i = i + 1;
        }
        try {
            FileUtils.writeStringToFile((File)new File(srFilePath), (String)result.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeMigrationSrConflictFile error", (Throwable)e);
        }
    }
}

