/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.file;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.constant.report.AbstractSheetProperties;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmPackageSrDiffFileOperator {
    private static final Logger log = LoggerFactory.getLogger(BwmPackageSrDiffFileOperator.class);
    private static Charset charset = Charset.forName("UTF-8");

    public static void writeMigrationSrDiffFile(WorkflowProjectPackage workflowProjectPackage, Map<PackageStage, JSONArray> diffElementMap, BwmSaasConfiguration bwmSaasConfiguration) {
        if (diffElementMap == null || CollectionUtils.isEmpty(diffElementMap.keySet())) {
            log.warn("\u672a\u83b7\u53d6\u5230DiffElement\u5217\u8868\uff0c\u8df3\u8fc7\u5b58\u50a8");
            return;
        }
        JSONArray result = new JSONArray();
        String srFilePath = bwmSaasConfiguration.getMigrationSrSnapshotFileSavePath("package_diff");
        for (PackageStage packageStage : diffElementMap.keySet()) {
            JSONArray diffElementList = diffElementMap.get((Object)packageStage);
            if (CollectionUtils.isEmpty((Collection)diffElementList)) continue;
            Integer i = 0;
            while (i < diffElementList.size()) {
                JSONObject jsonObject = diffElementList.getJSONObject(i.intValue());
                jsonObject.put((Object)"gmt_create", (Object)AbstractSheetProperties.getCurrentTime());
                jsonObject.put((Object)"gmt_modified", (Object)AbstractSheetProperties.getCurrentTime());
                jsonObject.put((Object)"tenant_id", (Object)bwmSaasConfiguration.getMeta().getTenantUuid());
                jsonObject.put((Object)"migration_task_id", (Object)bwmSaasConfiguration.getMeta().getTaskUuid());
                jsonObject.put((Object)"merge_instance_id", (Object)bwmSaasConfiguration.getMeta().getInstanceUuid());
                switch (packageStage) {
                    case SOURCE: {
                        jsonObject.put((Object)"old_meta_package_id", (Object)bwmSaasConfiguration.getMeta().getInputMetaVersion().getOldReaderOutputPackage());
                        jsonObject.put((Object)"novel_meta_package_id", (Object)bwmSaasConfiguration.getMeta().getInputMetaVersion().getNewReaderOutputPackage());
                        break;
                    }
                    case AFTER_CONVERT: {
                        jsonObject.put((Object)"old_meta_package_id", (Object)bwmSaasConfiguration.getMeta().getInputMetaVersion().getOldConverterOutputPackage());
                        jsonObject.put((Object)"novel_meta_package_id", (Object)bwmSaasConfiguration.getMeta().getInputMetaVersion().getNewConverterOutputPackage());
                        break;
                    }
                    case TARGET: {
                        jsonObject.put((Object)"old_meta_package_id", (Object)bwmSaasConfiguration.getMeta().getInputMetaVersion().getOldWriterOutputPackage());
                        jsonObject.put((Object)"novel_meta_package_id", (Object)bwmSaasConfiguration.getMeta().getInputMetaVersion().getNewDataWorksReaderOutputPackage());
                    }
                }
                jsonObject.put((Object)"package_stage", (Object)packageStage.getCode());
                result.add((Object)jsonObject);
                Integer n = i;
                i = i + 1;
            }
        }
        try {
            FileUtils.writeStringToFile((File)new File(srFilePath), (String)result.toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue, JSONWriter.Feature.WriteNullListAsEmpty}), (Charset)charset);
        }
        catch (IOException e) {
            log.error("writeMigrationSrDiffFile error", (Throwable)e);
        }
    }

    public static enum PackageStage {
        SOURCE(0),
        AFTER_CONVERT(1),
        TARGET(2);

        private Integer code;

        private PackageStage(int code) {
            this.code = code;
        }

        public Integer getCode() {
            return this.code;
        }
    }
}

