/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.sqoop2di;

import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.convert.sqoop2di.AbstractSqoopConverter;
import com.aliyun.migration.workflow.migration.common.convert.sqoop2di.MySQL2MySQLForSqoopReaderConverter;
import com.aliyun.migration.workflow.migration.common.convert.sqoop2di.SqoopType;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqoopReaderConvertFactory {
    private BwmConfiguration readerConfiguration;
    private List<Datasource> datasourceList;

    public SqoopReaderConvertFactory(BwmConfiguration bwmConfiguration, List<Datasource> datasourceList) {
        this.readerConfiguration = bwmConfiguration;
        this.datasourceList = datasourceList;
    }

    public AbstractSqoopConverter getReaderConvert(String readName) {
        Map<String, Object> configurationMap = this.readerConfiguration.getMap("self", new HashMap<String, Object>());
        BwmConfiguration dataxConfiguration = BwmConfiguration.from(configurationMap.getOrDefault("datax.datasource.map", "{}").toString());
        SqoopType sqoopType = SqoopType.getTypeByName(readName);
        switch (sqoopType) {
            case MYSQL: {
                return new MySQL2MySQLForSqoopReaderConverter(this.datasourceList);
            }
        }
        return null;
    }
}

