/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.shell2n.component;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIConfigTemplate;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.migration.workflow.migration.common.convert.datax2di.DataxType;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopCommand {
    private static final Logger log = LoggerFactory.getLogger(SqoopCommand.class);
    public static final String SQOOP_KEYWORD = "sqoop";
    public static final String SQOOP_IMPORT_KEYWORD = "sqoop import";
    public static final String SQOOP_EXPORT_KEYWORD = "sqoop export";
    private Boolean isImport = null;
    private Map<String, Pair<String, Boolean>> rawArgs = new HashMap<String, Pair<String, Boolean>>();

    public SqoopCommand(String cmd) {
        String[] args;
        if (cmd.contains(SQOOP_IMPORT_KEYWORD)) {
            this.isImport = true;
            cmd = cmd.substring(cmd.indexOf(SQOOP_IMPORT_KEYWORD) + SQOOP_IMPORT_KEYWORD.length());
        } else if (cmd.contains(SQOOP_EXPORT_KEYWORD)) {
            this.isImport = false;
            cmd = cmd.substring(cmd.indexOf(SQOOP_EXPORT_KEYWORD) + SQOOP_EXPORT_KEYWORD.length());
        } else {
            log.warn("cmd.is.not.sqoop.import.cmd");
            return;
        }
        for (String arg : args = (" " + cmd.trim()).split(" --")) {
            if (arg.trim().isEmpty()) continue;
            String[] kv = arg.trim().split(" ", 2);
            if (kv.length == 1) {
                this.rawArgs.put(kv[0], (Pair<String, Boolean>)Pair.of((Object)null, (Object)false));
                continue;
            }
            if (kv.length != 2) continue;
            String value = kv[1];
            if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                value = StringEscapeUtils.unescapeJava((String)value.substring(1, value.length() - 1));
            }
            this.rawArgs.put(kv[0], (Pair<String, Boolean>)Pair.of((Object)value, (Object)false));
        }
    }

    public DIJsonProcessor convertCmdToDiJson() {
        DIJsonProcessor diProcessor = DIJsonProcessor.from((String)DIConfigTemplate.DI_CODE_TEMPLATE);
        DIJsonProcessor readerJp = diProcessor.getConfiguration("steps[0]");
        DIJsonProcessor writerJp = diProcessor.getConfiguration("steps[1]");
        if (this.isImport == null) {
            log.warn("bash.is.not.sqoop.import.or.export.cmd:");
            return null;
        }
        if (Boolean.TRUE.equals(this.isImport)) {
            this.sqoopImportConvert(readerJp, writerJp);
        } else {
            this.sqoopExportConvert(readerJp, writerJp);
        }
        this.exportArgsHaveNotBeenCovered();
        return diProcessor;
    }

    private void sqoopImportConvert(DIJsonProcessor readerJp, DIJsonProcessor writerJp) {
        this.sqoopImportReaderConvert(readerJp);
        this.sqoopImportWriterConvert(writerJp);
    }

    private void sqoopExportConvert(DIJsonProcessor readerJp, DIJsonProcessor writerJp) {
        this.sqoopExportReaderConvert(readerJp);
        this.sqoopExportWriterConvert(writerJp);
    }

    private void sqoopImportReaderConvert(DIJsonProcessor readerJp) {
        Object object;
        JSONArray connection = new JSONArray();
        JSONObject singleConnection = new JSONObject();
        connection.add((Object)singleConnection);
        readerJp.set("parameter.connection", (Object)connection);
        this.setUsed("connect");
        readerJp.set("stepType", (Object)(this.rawArgs.containsKey("connect") ? SqoopCommand.getDatabaseTypeFromUrl(this.get("connect")).getType() : DataxType.DEFAULT.getType()));
        singleConnection.put((Object)"datasource", (Object)(this.rawArgs.containsKey("connect") ? SqoopCommand.getDatabaseFromUrl(this.get("connect")) : ""));
        this.setUsed("columns");
        if (this.rawArgs.containsKey("columns")) {
            object = this.rawArgs.get("columns").getKey();
        } else {
            String[] stringArray = new String[1];
            object = stringArray;
            stringArray[0] = "*";
        }
        readerJp.set("parameter.column", object);
        this.setUsed("query");
        singleConnection.put((Object)"querySql", this.rawArgs.containsKey("query") ? this.rawArgs.get("query").getKey() : new String[]{});
        this.setUsed("table");
        singleConnection.put((Object)"table", this.rawArgs.containsKey("table") ? this.rawArgs.get("table").getKey() : new String[]{});
        this.setUsed("where");
        readerJp.set("parameter.where", this.rawArgs.containsKey("where") ? this.rawArgs.get("where").getKey() : "");
    }

    private void sqoopImportWriterConvert(DIJsonProcessor writerJp) {
        writerJp.set("stepType", (Object)DataxType.HDFS.getType());
        this.setUsed("target-dir");
        writerJp.set("parameter.path", this.rawArgs.containsKey("target-dir") ? this.rawArgs.get("target-dir").getKey() : "");
        this.setUsed("split-by");
        writerJp.set("parameter.fieldDelimiter", this.rawArgs.containsKey("split-by") ? this.rawArgs.get("split-by").getKey() : "");
        this.setUsed("null-string");
        this.setUsed("null-non-string");
        writerJp.set("parameter.nullFormat", this.rawArgs.containsKey("null-non-string") ? this.rawArgs.get("null-non-string").getKey() : "");
        writerJp.set("parameter.nullFormat", this.rawArgs.containsKey("null-string") ? this.rawArgs.get("null-string").getKey() : writerJp.get("parameter.nullFormat"));
        this.setUsed("hive-import");
        if (this.rawArgs.containsKey("hive-import")) {
            writerJp.set("stepType", (Object)DataxType.HIVE.getType());
            this.setUsed("hive-database");
            writerJp.set("parameter.datasource", this.rawArgs.containsKey("hive-database") ? this.rawArgs.get("hive-database").getKey() : "");
            this.setUsed("hive-table");
            writerJp.set("parameter.table", this.rawArgs.containsKey("hive-table") ? this.rawArgs.get("hive-table").getKey() : new String[]{});
        }
    }

    private void sqoopExportReaderConvert(DIJsonProcessor readerJp) {
        readerJp.set("stepType", (Object)DataxType.HDFS.getType());
        this.setUsed("target-dir");
        readerJp.set("parameter.path", this.rawArgs.containsKey("target-dir") ? this.rawArgs.get("target-dir").getKey() : "");
        this.setUsed("split-by");
        readerJp.set("parameter.fieldDelimiter", this.rawArgs.containsKey("split-by") ? this.rawArgs.get("split-by").getKey() : "");
        this.setUsed("null-string");
        this.setUsed("null-non-string");
        readerJp.set("parameter.nullFormat", this.rawArgs.containsKey("null-non-string") ? this.rawArgs.get("null-non-string").getKey() : "");
        readerJp.set("parameter.nullFormat", this.rawArgs.containsKey("null-string") ? this.rawArgs.get("null-string").getKey() : readerJp.get("parameter.nullFormat"));
        this.setUsed("hive-import");
        if (this.rawArgs.containsKey("--hive-import")) {
            readerJp.set("stepType", (Object)DataxType.HIVE.getType());
            this.setUsed("hive-database");
            readerJp.set("parameter.datasource", this.rawArgs.containsKey("hive-database") ? this.rawArgs.get("hive-database").getKey() : "");
            this.setUsed("hive-table");
            readerJp.set("parameter.table", this.rawArgs.containsKey("hive-table") ? this.rawArgs.get("hive-table").getKey() : new String[]{});
        }
    }

    private void sqoopExportWriterConvert(DIJsonProcessor writerJp) {
        Object object;
        JSONArray connection = new JSONArray();
        JSONObject singleConnection = new JSONObject();
        connection.add((Object)singleConnection);
        writerJp.set("parameter.connection", (Object)connection);
        this.setUsed("connect");
        writerJp.set("stepType", (Object)(this.rawArgs.containsKey("connect") ? SqoopCommand.getDatabaseTypeFromUrl(this.get("connect")).getType() : DataxType.DEFAULT.getType()));
        singleConnection.put((Object)"datasource", (Object)(this.rawArgs.containsKey("connect") ? SqoopCommand.getDatabaseFromUrl(this.get("connect")) : ""));
        this.setUsed("columns");
        if (this.rawArgs.containsKey("columns")) {
            object = this.rawArgs.get("columns").getKey();
        } else {
            String[] stringArray = new String[1];
            object = stringArray;
            stringArray[0] = "*";
        }
        writerJp.set("parameter.column", object);
        this.setUsed("query");
        singleConnection.put((Object)"querySql", this.rawArgs.containsKey("query") ? this.rawArgs.get("query").getKey() : new String[]{});
        this.setUsed("table");
        singleConnection.put((Object)"table", this.rawArgs.containsKey("table") ? this.rawArgs.get("table").getKey() : new String[]{});
    }

    private List<String> getKeySet() {
        return this.rawArgs.keySet().stream().toList();
    }

    private String get(String key) {
        return (String)this.rawArgs.get(key).getKey();
    }

    private void setUsed(String key) {
        if (this.rawArgs.containsKey(key)) {
            this.rawArgs.put(key, (Pair<String, Boolean>)Pair.of((Object)this.get(key), (Object)true));
        }
    }

    private void exportArgsHaveNotBeenCovered() {
        ArrayList<String> argsNotCovered = new ArrayList<String>();
        for (String key : this.getKeySet()) {
            if (!Boolean.FALSE.equals(this.rawArgs.get(key).getValue())) continue;
            argsNotCovered.add(key);
        }
        if (!argsNotCovered.isEmpty()) {
            log.info("sqoop\u53ef\u914d\u7f6e\u53c2\u6570\u8fc7\u591a\uff0c\u5de5\u5177\u5c1a\u672a\u8986\u76d6\u5168\u90e8\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u4e0b\u5217\u53c2\u6570\u662f\u5426\u9700\u8981\u6620\u5c04\u5230DI\u8282\u70b9\uff1a{}\uff08\u6ce8\u610f\uff0c\u90e8\u5206\u53c2\u6570\u9700\u8981\u624b\u52a8\u5199\u5165\u5230Dw\u6570\u636e\u6e90\uff0c\u800c\u4e0d\u662f\u5728DI\u8282\u70b9\u4e2d\uff09", argsNotCovered);
        }
    }

    public static DataxType getDatabaseTypeFromUrl(String jdbcUrl) {
        String url = jdbcUrl.substring(5);
        if (url.contains("://")) {
            url.substring(0, url.indexOf("://"));
        }
        for (DataxType type : DataxType.values()) {
            if (!url.contains(type.getType())) continue;
            return type;
        }
        return DataxType.DEFAULT;
    }

    public static String getDatabaseFromUrl(String jdbcUrl) {
        try {
            URI uri = new URI(jdbcUrl.substring(5));
            String databaseName = uri.getPath().substring(1);
            return databaseName;
        }
        catch (Exception e) {
            log.warn("jdbcURL\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u5176\u5185\u90e8\u662f\u5426\u6709\u5c40\u90e8\u53d8\u91cf", (Object)e.getMessage());
            return "";
        }
    }
}

