/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert.shell2n;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.convert.shell2n.AbstractShellConverter;
import com.aliyun.migration.workflow.migration.common.convert.shell2n.DefaultShellConverter;
import com.aliyun.migration.workflow.migration.common.convert.shell2n.ShellScriptType;
import com.aliyun.migration.workflow.migration.common.convert.shell2n.ShellShellConverter;
import com.aliyun.migration.workflow.migration.common.convert.shell2n.ShellSqlConverter;
import com.aliyun.migration.workflow.migration.common.convert.shell2n.ShellSqoopConverter;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;

public class ShellConvertFactory
extends AbstractConvertFactory {
    private BwmConfiguration writerConfiguration;

    public ShellConvertFactory(BwmConfiguration bwmConfiguration) {
        this.writerConfiguration = bwmConfiguration;
    }

    public AbstractShellConverter getShellConvert(String targetTypeName, TaskContext taskContext, Workflow workflow) {
        ShellScriptType shellScriptType = ShellScriptType.getTypeByTargetType(CodeProgramType.getNodeTypeByName((String)targetTypeName));
        switch (shellScriptType) {
            case SHELL: {
                return new ShellShellConverter(taskContext, workflow);
            }
            case PYTHON: {
                return new DefaultShellConverter(taskContext, workflow);
            }
            case SQOOP: {
                return new ShellSqoopConverter(taskContext, workflow);
            }
            case SQL: {
                return new ShellSqlConverter(taskContext, workflow);
            }
        }
        return new DefaultShellConverter(taskContext, workflow);
    }
}

