/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwFunction;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwProject;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Function;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Resource;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.common.utils.BwmCommonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DwSpec2WorkflowConvert {
    private static final Logger log = LoggerFactory.getLogger(DwSpec2WorkflowConvert.class);

    public WorkflowProjectPackage convertDwPackage2WorkflowPackage(DataWorksPackage dataWorksPackage) {
        if (Objects.isNull(dataWorksPackage)) {
            return null;
        }
        DwProject dwProject = dataWorksPackage.getDwProject();
        if (Objects.isNull(dwProject)) {
            return null;
        }
        WorkflowProjectPackage wfPackage = new WorkflowProjectPackage();
        WorkflowProject workflowProject = new WorkflowProject();
        workflowProject.setName(dwProject.getName());
        ArrayList workflowDatasourceList = new ArrayList();
        ((List)Optional.ofNullable(dwProject.getDatasources()).orElse(new ArrayList())).forEach(datasource -> {
            WorkflowDatasource workflowDatasource = new WorkflowDatasource();
            workflowDatasource.setName(datasource.getName());
            workflowDatasource.setType(datasource.getType());
            workflowDatasource.setDatasourceId(datasource.getUniqueKey());
            workflowDatasource.setCustomProperties(new HashMap());
            workflowDatasource.getCustomProperties().put("connection", datasource.getConnection());
            workflowDatasourceList.add(workflowDatasource);
        });
        workflowProject.setDatasources(workflowDatasourceList);
        wfPackage.setWorkflowProject(workflowProject);
        ArrayList workflows = new ArrayList();
        HashSet wfNameSet = new HashSet();
        ((List)Optional.ofNullable(dwProject.getWorkflows()).orElse(new ArrayList())).forEach(workflow -> {
            String name = workflow.getName();
            if (wfNameSet.contains(name)) {
                return;
            }
            wfNameSet.add(name);
            Workflow wf = new Workflow();
            wf.setProjectId(workflowProject.getProjectId());
            wf.setProjectName(workflowProject.getName());
            wf.setWorkflowName(workflow.getName());
            wf.setOwner(workflow.getOwner());
            wf.setFiles(this.convertFileResource(workflow.getResources()));
            if (workflow.getParameters() != null) {
                try {
                    JSONObject parameters = JSONObject.parseObject((String)workflow.getParameters());
                    if (wf.getParamMap() == null) {
                        wf.setParamMap(new HashMap());
                    }
                    parameters.forEach((k, v) -> {
                        if (StringUtils.isNotBlank((String)k) && Objects.nonNull(v)) {
                            wf.getParamMap().put(k, v.toString());
                        }
                    });
                }
                catch (Exception e) {
                    log.error("convert parameters error", (Throwable)e);
                }
            }
            wf.setFunctions(this.convertFunctions(workflow.getFunctions()));
            wf.setWorkflowNodes(this.convertNodes(wf, workflow.getNodes()));
            wf.setNodeRelations(this.convertRelation(workflow.getNodes()));
            workflows.add(wf);
        });
        wfPackage.setWorkflowList(workflows);
        return wfPackage;
    }

    private List<WorkflowFileResource> convertFileResource(List<Resource> resources) {
        ArrayList<WorkflowFileResource> workflowFileResources = new ArrayList<WorkflowFileResource>();
        ((List)Optional.ofNullable(resources).orElse(new ArrayList())).forEach(x -> {
            if (x instanceof DwResource) {
                DwResource dwResource = (DwResource)x;
                WorkflowFileResource workflowFileResource = new WorkflowFileResource();
                workflowFileResource.setName(x.getName());
                workflowFileResource.setFileType(x.getType());
                workflowFileResource.setPath(x.getPath());
                workflowFileResource.setPath(dwResource.getLocalPath());
                workflowFileResource.setFolder(dwResource.getFolder());
                workflowFileResource.setFileId(dwResource.getDmObjectUuid());
                HashMap<String, String> customProperties = new HashMap<String, String>();
                customProperties.put("FILE_SOURCE_DATA", BwmJsonUtil.toJsonString(x));
                workflowFileResource.setCustomProperties(customProperties);
            }
        });
        return workflowFileResources;
    }

    private List<RelationPackage> convertRelation(List<Node> nodes) {
        ArrayList<RelationPackage> relationPackageList = new ArrayList<RelationPackage>();
        Map<String, List<Node>> nodeNameMap = ((List)Optional.ofNullable(nodes).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(Node::getName));
        ((List)Optional.ofNullable(nodes).orElse(new ArrayList())).forEach(x -> x.getInputs().forEach(input -> {
            if (Objects.nonNull(input)) {
                String taskName = BwmCommonUtil.getTaskNameByInput(input.getData());
                List preTasks = (List)nodeNameMap.get(taskName);
                if (CollectionUtils.isEmpty((Collection)preTasks)) {
                    log.warn("not found dw input {}", input);
                    return;
                }
                RelationPackage relationPackage = new RelationPackage();
                Node preTask = (Node)preTasks.get(0);
                String dmObjectUuid = preTask.getDmObjectUuid();
                relationPackage.setFrom(dmObjectUuid);
                relationPackage.setTo(x.getDmObjectUuid());
                relationPackage.setReType(RelationPackage.ReType.NODE);
                relationPackageList.add(relationPackage);
            }
        }));
        return relationPackageList;
    }

    private List<WorkflowNode> convertNodes(Workflow wf, List<Node> nodes) {
        ArrayList<WorkflowNode> workflowNodes = new ArrayList<WorkflowNode>();
        ((List)Optional.ofNullable(nodes).orElse(new ArrayList())).forEach(x -> {
            if (x instanceof DwNode) {
                DwNode dwNode = (DwNode)x;
                WorkflowNode workflowNode = new WorkflowNode();
                workflowNode.setNodeId(dwNode.getDmObjectUuid());
                workflowNode.setNodeName(dwNode.getName());
                workflowNode.setWorkflowId(wf.getWorkflowId());
                workflowNode.setWorkflowName(wf.getWorkflowName());
                workflowNode.setCategoryValue(dwNode.getFolder());
                workflowNode.setDescription(dwNode.getDescription());
                workflowNode.setOwner(dwNode.getOwner());
                workflowNode.setNodeType(dwNode.getType());
                workflowNode.setScript(dwNode.getCode());
                workflowNode.setParamMap(BwmCommonUtil.convertMapFromStr(dwNode.getParameter()));
                workflowNode.setRerunMode(WorkflowNode.RerunMode.valueOf((String)dwNode.getRerunMode().name()));
                workflowNode.setCategoryValue(dwNode.getFolder());
                workflowNode.setPriority(dwNode.getPriority());
                WorkflowTrigger workflowTrigger = new WorkflowTrigger();
                workflowTrigger.setCron(dwNode.getCronExpress());
                workflowTrigger.setEndTime(BwmCommonUtil.dateToLocalDateTime(dwNode.getEndEffectDate()));
                workflowTrigger.setStartTime(BwmCommonUtil.dateToLocalDateTime(dwNode.getStartEffectDate()));
                workflowNode.setTrigger(workflowTrigger);
                if ("custom".equalsIgnoreCase(dwNode.getType())) {
                    workflowNode.setOriginScript(dwNode.getOrigin());
                    workflowNode.setTempType("custom");
                }
                workflowNodes.add(workflowNode);
            }
        });
        return workflowNodes;
    }

    private List<WorkflowFunctionResource> convertFunctions(List<Function> functions) {
        ArrayList<WorkflowFunctionResource> workflowNodes = new ArrayList<WorkflowFunctionResource>();
        ((List)Optional.ofNullable(functions).orElse(new ArrayList())).forEach(x -> {
            if (x instanceof DwFunction) {
                DwFunction dwFunction = (DwFunction)x;
                WorkflowFunctionResource functionResource = new WorkflowFunctionResource();
                functionResource.setFunctionId(x.getDmObjectUuid());
                functionResource.setFunctionType(WorkflowFunctionResource.FunctionType.valueOf((String)x.getFunctionType()));
                functionResource.setName(dwFunction.getName());
                functionResource.setFunctionId(dwFunction.getDmObjectUuid());
                functionResource.setClassName(dwFunction.getClazz());
                functionResource.setEmbeddedCode(dwFunction.getCommand());
                functionResource.setEmbeddedCodeType(dwFunction.getType());
                functionResource.setArgumentsDescription(dwFunction.getArguments());
                functionResource.setReturnValueDescription(dwFunction.getReturnValue());
                functionResource.setUsageDescription(dwFunction.getDescription());
            }
        });
        return workflowNodes;
    }
}

