/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.StatisticOp;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultConvert
extends AbstractConvert<WorkflowProjectPackage> {
    public DefaultConvert(TaskContext taskContext) {
        super(taskContext);
    }

    @Override
    public WorkflowProjectPackage convert(WorkflowProjectPackage t) {
        Datasource readerDatasource = this.taskContext.getReaderDatasource();
        Map readerDatasourceProperties = readerDatasource.getProperties();
        String readSourceFilePath = (String)readerDatasourceProperties.get("source-file-path");
        Datasource writerDatasource = this.taskContext.getWriterDatasource();
        Map writerDatasourceProperties = writerDatasource.getProperties();
        writerDatasourceProperties.put("source-file-path", readSourceFilePath);
        this.collectStatisticOp(t);
        return t;
    }

    private void collectStatisticOp(WorkflowProjectPackage t) {
        StatisticOp statisticOp = this.taskContext.getStatisticOp();
        ((List)Optional.ofNullable(t.getWorkflowList()).orElse(new ArrayList())).forEach(workflow -> {
            statisticOp.addWorkflowTotal(1);
            statisticOp.addWorkflowSuccess(workflow.getWorkflowId());
            ((List)Optional.ofNullable(workflow.getWorkflowNodes()).orElse(new ArrayList())).forEach(workflowNode -> {
                statisticOp.addWorkflowNodeTotal(1);
                statisticOp.addWorkflowNodeSuccess(workflowNode.getNodeId());
            });
            ((List)Optional.ofNullable(workflow.getFunctions()).orElse(new ArrayList())).forEach(function -> {
                statisticOp.addWorkflowFunTotal(1);
                statisticOp.addWorkflowFunSuccess(function.getFunctionId());
            });
            ((List)Optional.ofNullable(workflow.getFiles()).orElse(new ArrayList())).forEach(workflowFileResource -> {
                statisticOp.addWorkflowResourceTotal(workflow.getFiles().size());
                statisticOp.addWorkflowResourceSuccess(workflowFileResource.getFileId());
            });
        });
    }
}

