/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.convert;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.DefaultConvert;
import com.aliyun.migration.workflow.migration.common.convert.DefaultNodeConvert;
import com.aliyun.migration.workflow.migration.common.convert.FileResourceConvert;
import com.aliyun.migration.workflow.migration.common.convert.FunctionConvert;
import com.aliyun.migration.workflow.migration.common.convert.ProjectConvert;
import com.aliyun.migration.workflow.migration.common.convert.WorkflowConvert;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractConvertFactory.class);

    public AbstractConvert<WorkflowProjectPackage> getDefaultConvert(TaskContext taskContext) {
        return new DefaultConvert(taskContext);
    }

    public AbstractConvert<WorkflowProject> getProjectConvert(TaskContext taskContext) {
        return new ProjectConvert(taskContext);
    }

    public AbstractConvert<Workflow> getWorkflowConvert(TaskContext taskContext) {
        return new WorkflowConvert(taskContext);
    }

    public AbstractConvert<WorkflowFunctionResource> getFunctionConvert(TaskContext taskContext) {
        return new FunctionConvert(taskContext);
    }

    public AbstractConvert<WorkflowFileResource> getFileConvert(TaskContext taskContext) {
        return new FileResourceConvert(taskContext);
    }

    public AbstractConvert<List<WorkflowNode>> getDefaultNodeConvert(TaskContext taskContext, Workflow workflow) {
        return new DefaultNodeConvert(taskContext, workflow);
    }

    public AbstractConvert<List<WorkflowNode>> getCustomNodeConvert(TaskContext taskContext, WorkflowNode workflowNode, Workflow workflow) {
        return new DefaultNodeConvert(taskContext, workflow);
    }

    public AbstractConvert<List<WorkflowNode>> getNodeListConvert(String taskTypeStr, TaskContext taskContext, Workflow workflow) {
        return new DefaultNodeConvert(taskContext, workflow);
    }
}

