/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.circuitbreaker.event;

import com.alibaba.securitysdk.logging.circuitbreaker.ThresholdCircuitBreakerEvent;
import com.alibaba.securitysdk.logging.utils.AssertUtil;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class OsThresholdCircuitBreakerEvent
implements ThresholdCircuitBreakerEvent<OperatingSystemMXBean> {
    private OperatingSystemMXBean operatingSystemMXBean;
    private final double cpuThreshold;
    private final double osMemoryThreshold;

    public OsThresholdCircuitBreakerEvent(double cpuThreshold, double osMemoryThreshold) {
        this(cpuThreshold, osMemoryThreshold, ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class));
    }

    public OsThresholdCircuitBreakerEvent(double cpuThreshold, double osMemoryThreshold, OperatingSystemMXBean operatingSystemMXBean) {
        this.cpuThreshold = cpuThreshold;
        this.osMemoryThreshold = osMemoryThreshold;
        this.operatingSystemMXBean = (OperatingSystemMXBean)AssertUtil.notNull((Object)operatingSystemMXBean);
    }

    @Override
    public OperatingSystemMXBean getObject() {
        return this.operatingSystemMXBean;
    }

    @Override
    public boolean exceedThreshold() {
        double memoryRatio = (double)this.operatingSystemMXBean.getFreePhysicalMemorySize() / (double)this.operatingSystemMXBean.getTotalPhysicalMemorySize();
        return this.cpuThreshold <= 0.0 || memoryRatio > this.osMemoryThreshold || this.operatingSystemMXBean.getSystemLoadAverage() > this.cpuThreshold;
    }

    public static void main(String[] args) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        System.out.println(operatingSystemMXBean.getFreeSwapSpaceSize());
        new OsThresholdCircuitBreakerEvent(0.8, 0.9).exceedThreshold();
    }
}

