/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.util;

import com.aliyun.securitysdk.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SensitiveDataUtil {
    public static final String SEPARATOR = "-";
    private static final String ID_CARD_REGEXP = "[0-9]{15}|[0-9]{18}|[0-9]{14}X|[0-9]{17}X";
    private static final String BANK_CARD_REGEXP = "[0-9]{13,19}";
    private static final String PHONE_TEL_REGEXP = "[0-9]{3,4}[-]?[0-9]{7,8}";
    private static final String EMAIL_ADDRESS_REGEXP = "^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$";
    private static final Pattern ID_CARD_PATTERN = Pattern.compile("[0-9]{15}|[0-9]{18}|[0-9]{14}X|[0-9]{17}X");
    private static final Pattern BANK_CARD_PATTERN = Pattern.compile("[0-9]{13,19}");
    private static final Pattern PHONE_TEL_PATTERN = Pattern.compile("[0-9]{3,4}[-]?[0-9]{7,8}");
    public static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    public static boolean isPhoneOrTelNo(String phoneOrTelNo) {
        if (StringUtils.isBlank(phoneOrTelNo)) {
            return false;
        }
        Matcher matcher = PHONE_TEL_PATTERN.matcher(phoneOrTelNo.trim());
        return matcher.matches();
    }

    public static boolean isBankCardNo(String bankCardNo) {
        if (StringUtils.isBlank(bankCardNo)) {
            return false;
        }
        Matcher matcher = BANK_CARD_PATTERN.matcher(bankCardNo.trim());
        return matcher.matches();
    }

    public static boolean isIdCardNo(String idCardNo) {
        if (StringUtils.isBlank(idCardNo)) {
            return false;
        }
        Matcher matcher = ID_CARD_PATTERN.matcher(idCardNo.trim());
        return matcher.matches();
    }

    public static boolean isEmailAddress(String address) {
        Matcher matcher = EMAIL_ADDRESS_PATTERN.matcher(address);
        return matcher.find();
    }

    public static String customizeMark(String sensitiveData, int frontCharNum, int tailCharNum) {
        int i;
        if (StringUtils.isEmpty(sensitiveData)) {
            return null;
        }
        int length = sensitiveData.length();
        if (frontCharNum < 0 || tailCharNum < 0 || frontCharNum + tailCharNum > length) {
            return null;
        }
        int beginIndex = frontCharNum;
        int endIndex = length - tailCharNum;
        char[] result = new char[length];
        for (i = 0; i < beginIndex; ++i) {
            result[i] = 42;
        }
        sensitiveData.getChars(beginIndex, endIndex, result, beginIndex);
        for (i = endIndex; i < length; ++i) {
            result[i] = 42;
        }
        return new String(result);
    }

    public static String customizeIntraMarkOne(String sensitiveData, int frontCharNum, int tailCharNum) {
        return SensitiveDataUtil.customizeIntraMark(sensitiveData, frontCharNum, tailCharNum, 1);
    }

    public static String customizeIntraMark(String sensitiveData, int frontCharNum, int tailCharNum, int num) {
        if (StringUtils.isEmpty(sensitiveData)) {
            return null;
        }
        int length = sensitiveData.length();
        int markLength = frontCharNum + tailCharNum;
        if (frontCharNum < 0 || tailCharNum < 0 || markLength > length) {
            return null;
        }
        int beginIndex = frontCharNum;
        int endIndex = frontCharNum + num;
        int resultLength = markLength + num;
        char[] result = new char[resultLength];
        sensitiveData.getChars(0, beginIndex, result, 0);
        for (int i = 0; i < num; ++i) {
            result[beginIndex + i] = 42;
        }
        sensitiveData.getChars(length - tailCharNum, length, result, endIndex);
        return new String(result);
    }

    public static String customizeIntraMark(String sensitiveData, int frontCharNum, int tailCharNum, int num, char reserved) {
        if (StringUtils.isEmpty(sensitiveData)) {
            return null;
        }
        int length = sensitiveData.length();
        int markLength = frontCharNum + tailCharNum;
        if (frontCharNum < 0 || tailCharNum < 0 || markLength > length) {
            return null;
        }
        if (markLength == length) {
            return sensitiveData;
        }
        StringBuilder sb = new StringBuilder(sensitiveData.length());
        sb.append(sensitiveData, 0, frontCharNum);
        int beginIndex = frontCharNum;
        int endIndex = length - tailCharNum;
        boolean shouldPadding = true;
        for (int i = beginIndex; i < endIndex; ++i) {
            if (sensitiveData.charAt(i) == reserved) {
                shouldPadding = true;
                sb.append(reserved);
                continue;
            }
            if (shouldPadding) {
                for (int j = 0; j < num; ++j) {
                    sb.append('*');
                }
            }
            shouldPadding = false;
        }
        sb.append(sensitiveData.substring(endIndex));
        return sb.toString();
    }

    public static String customizeIntraMark(String sensitiveData, int frontCharNum, int tailCharNum) {
        return SensitiveDataUtil.customizeIntraMark(sensitiveData, frontCharNum, tailCharNum, '\u0000');
    }

    public static String customizeIntraMark(String sensitiveData, int frontCharNum, int tailCharNum, char reserved) {
        if (StringUtils.isEmpty(sensitiveData)) {
            return null;
        }
        int length = sensitiveData.length();
        if (frontCharNum < 0 || tailCharNum < 0 || frontCharNum + tailCharNum > length) {
            return null;
        }
        int beginIndex = frontCharNum;
        int endIndex = length - tailCharNum;
        char[] result = new char[length];
        sensitiveData.getChars(0, beginIndex, result, 0);
        for (int i = beginIndex; i < endIndex; ++i) {
            result[i] = sensitiveData.charAt(i) == reserved ? reserved : (char)42;
        }
        sensitiveData.getChars(endIndex, length, result, endIndex);
        return new String(result);
    }

    public static String customizeIntraMark(String sensitiveData, int num) {
        if (sensitiveData == null || sensitiveData.isEmpty()) {
            return sensitiveData;
        }
        int len = sensitiveData.length();
        if (len == 1) {
            return "*";
        }
        if (len == 2) {
            return "*" + sensitiveData.charAt(1);
        }
        int head = 0;
        int tail = len / 3;
        head = len % 3 == 0 ? len / 3 : len / 3 + 1;
        if (num == -1) {
            return SensitiveDataUtil.customizeIntraMark(sensitiveData, head, tail);
        }
        return SensitiveDataUtil.customizeIntraMark(sensitiveData, head, tail, num);
    }

    public static String customizeIntraMark(String sensitiveData) {
        return SensitiveDataUtil.customizeIntraMark(sensitiveData, -1);
    }
}

