/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf.policy;

import com.aliyun.rapt.commons.utils.JavaVersion;
import com.aliyun.rapt.commons.utils.SystemUtils;
import com.aliyun.securitysdk.rass.net.AliyunSecurityNetHooksProvider;
import com.aliyun.securitysdk.rass.net.NetHooksEventListener;
import com.aliyun.securitysdk.url.exception.SSRFThrowableFactory;
import com.aliyun.securitysdk.url.ssrf.AliSecurityManager;
import com.aliyun.securitysdk.url.ssrf.HostCachePolicy;
import com.aliyun.securitysdk.url.ssrf.SSRFNetHooksEventListener;
import com.aliyun.securitysdk.url.ssrf.checkcondition.CustomExpirationCacheSSRFNetHooksCheckCondition;
import com.aliyun.securitysdk.url.ssrf.checkcondition.CustomExpirationCacheSecurityManagerConnectCheckCondition;
import com.aliyun.securitysdk.url.ssrf.checkcondition.ExpirationCacheSSRFNetHooksCheckCondition;
import com.aliyun.securitysdk.url.ssrf.checkcondition.ExpirationCacheSecurityManagerConnectCheckCondition;
import com.aliyun.securitysdk.url.ssrf.checkcondition.SSRFNetHooksCheckCondition;
import com.aliyun.securitysdk.url.ssrf.checkcondition.SecurityManagerConnectCheckCondition;
import com.aliyun.securitysdk.url.ssrf.checkcondition.ThreadLocalSSRFNetHooksCheckCondition;
import com.aliyun.securitysdk.url.ssrf.checkcondition.ThreadLocalSecurityManagerConnectCheckCondition;
import com.aliyun.securitysdk.util.ClassUtils;
import com.aliyun.securitysdk.util.expiringmap.ExpiringMap;
import com.aliyun.securitysdk.util.expiringmap.ExpiringSet;

public class CompatibleSsrfCheckerRegister {
    public static final ExpiringSet<String> EXPIRING_SET = CompatibleSsrfCheckerRegister.initExpiringSet();
    public static final ExpiringSet<String> CUSTOM_EXPIRING_SET = CompatibleSsrfCheckerRegister.initExpiringSet();
    private static final String NET_HOOKS_PROVIDER_CLASS_PATH = "sun.net.NetHooks.Provider";
    private static Boolean ENABLE_NET_HOOKS = false;
    private static Boolean ENABLE_SECURITY_MANAGER_CHECK = false;

    public static void start() {
        CompatibleSsrfCheckerRegister.initiate();
        if (ENABLE_NET_HOOKS.booleanValue()) {
            SSRFNetHookCheckingFlagHolder.NEED_CHECKING.set(true);
        } else if (ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) {
            SSRFSecurtiyManagerCheckingFlagHolder.NEED_CHECKING.set(true);
        }
    }

    public static void startCachedNetHooking(String host, boolean isCustomThrowable) {
        CompatibleSsrfCheckerRegister.initiate();
        if (ENABLE_NET_HOOKS.booleanValue() || ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) {
            if (isCustomThrowable) {
                CUSTOM_EXPIRING_SET.add(host);
            } else {
                EXPIRING_SET.add(host);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initiate() {
        if (ENABLE_NET_HOOKS.booleanValue() || ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) return;
        String string = NET_HOOKS_PROVIDER_CLASS_PATH;
        synchronized (NET_HOOKS_PROVIDER_CLASS_PATH) {
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7)) {
                if (ENABLE_NET_HOOKS.booleanValue()) return;
                try {
                    if (!ClassUtils.isPresent(NET_HOOKS_PROVIDER_CLASS_PATH, ClassUtils.getDefaultClassLoader())) return;
                    SSRFNetHooksEventListener listener = new SSRFNetHooksEventListener(CompatibleSsrfCheckerRegister.getDefaultSSRFNetHooksCheckCondition());
                    AliyunSecurityNetHooksProvider.registerListener((NetHooksEventListener)listener);
                }
                finally {
                    ENABLE_NET_HOOKS = true;
                }
            }
            if (ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) return;
            try {
                SecurityManager currentSecurityManager = System.getSecurityManager();
                if (currentSecurityManager instanceof AliSecurityManager) return;
                System.setSecurityManager(new AliSecurityManager(currentSecurityManager, CompatibleSsrfCheckerRegister.getDefaultSecurityManagerConnectCondition()));
            }
            finally {
                ENABLE_SECURITY_MANAGER_CHECK = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void registerNetHooksProviderListener(NetHooksEventListener listener) {
        if (ClassUtils.isPresent(NET_HOOKS_PROVIDER_CLASS_PATH, ClassUtils.getDefaultClassLoader())) {
            AliyunSecurityNetHooksProvider.registerListener((NetHooksEventListener)listener);
        }
    }

    private static SSRFNetHooksCheckCondition[] getDefaultSSRFNetHooksCheckCondition() {
        return new SSRFNetHooksCheckCondition[]{new ThreadLocalSSRFNetHooksCheckCondition(), new ExpirationCacheSSRFNetHooksCheckCondition(), new CustomExpirationCacheSSRFNetHooksCheckCondition()};
    }

    private static SecurityManagerConnectCheckCondition[] getDefaultSecurityManagerConnectCondition() {
        return new SecurityManagerConnectCheckCondition[]{new ThreadLocalSecurityManagerConnectCheckCondition(), new ExpirationCacheSecurityManagerConnectCheckCondition(), new CustomExpirationCacheSecurityManagerConnectCheckCondition()};
    }

    public static void stop() {
        if (ENABLE_NET_HOOKS.booleanValue()) {
            SSRFNetHookCheckingFlagHolder.NEED_CHECKING.set(false);
        } else if (ENABLE_SECURITY_MANAGER_CHECK.booleanValue()) {
            SSRFSecurtiyManagerCheckingFlagHolder.NEED_CHECKING.set(false);
        }
    }

    private static ExpiringSet<String> initExpiringSet() {
        return HostCachePolicy.expiringSet();
    }

    private static ExpiringMap<String, SSRFThrowableFactory> initExpiringMap() {
        return HostCachePolicy.expiringMap();
    }

    public static class SSRFSecurtiyManagerCheckingFlagHolder {
        public static final ThreadLocal<Boolean> NEED_CHECKING = new ThreadLocal<Boolean>(){

            @Override
            public Boolean initialValue() {
                return false;
            }
        };
    }

    public static class SSRFNetHookCheckingFlagHolder {
        public static final ThreadLocal<Boolean> NEED_CHECKING = new ThreadLocal<Boolean>(){

            @Override
            public Boolean initialValue() {
                return false;
            }
        };
    }
}

