/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.ssrf;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.net.NetHooksEvent;
import com.aliyun.securitysdk.rass.net.NetHooksEventListener;
import com.aliyun.securitysdk.url.exception.GlobalSSRFThrowableFactory;
import com.aliyun.securitysdk.url.exception.SSRFUnsafeConnectionException;
import com.aliyun.securitysdk.url.ssrf.SSRFCheckerImpl;
import com.aliyun.securitysdk.url.ssrf.checkcondition.SSRFNetHooksCheckCondition;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SSRFNetHooksEventListener
implements NetHooksEventListener {
    private static final Logger logger = SecurityLogManager.getLogger(SSRFNetHooksEventListener.class);
    protected static final String LOG_CONNECT_FORMAT = "Connecting: %s";
    protected static final String LOG_INFO_FORMAT = "Address %s is not allowed to connect!";
    private final List<SSRFNetHooksCheckCondition> checkConditions;

    public SSRFNetHooksEventListener(SSRFNetHooksCheckCondition ... conditions) {
        this.checkConditions = Collections.unmodifiableList(Arrays.asList(conditions));
    }

    public void handleBeforeTcpConnect(NetHooksEvent event) {
        InetAddress address = event.getInetAddress();
        logger.debug("Connecting: {}", (Object)address);
        this.check(address);
    }

    public void handleBeforeTcpBind(NetHooksEvent event) {
    }

    protected void check(InetAddress address) {
        for (SSRFNetHooksCheckCondition checkCondition : this.checkConditions) {
            if (!checkCondition.needsCheck(address)) continue;
            boolean allowedAddress = SSRFCheckerImpl.isAllowedAddress(address);
            if (!allowedAddress) {
                logger.warn("ssrf attack, address: " + address);
                this.throwsErrorOrRuntimeException(checkCondition, address);
                continue;
            }
            logger.info("ssrf check: {}, result: true", (Object)address.toString());
        }
    }

    private void throwsErrorOrRuntimeException(SSRFNetHooksCheckCondition checkCondition, InetAddress address) {
        if (checkCondition.isCustomThrowable()) {
            throw GlobalSSRFThrowableFactory.defaultFactory().newRuntimeException("unsafe address", address);
        }
        throw new SSRFUnsafeConnectionException("unsafe address", address);
    }
}

