/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.sensitive.entity;

import java.util.List;
import java.util.Map;

public class SensitiveRule {
    private String name;
    private String type;
    private List<String> keyword;
    private List<String> delimiters;
    private List<String> value;
    private Map<String, List<String>> whiteRegex;
    private boolean defaultRule;

    public String toString() {
        return "Rule{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", keyword=" + this.keyword + ", delimiters=" + this.delimiters + ", value=" + this.value + ", white_regex=" + this.whiteRegex + ", defaultRule=" + this.defaultRule + '}';
    }

    public void validate() {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Rule name cannot be null or empty");
        }
        if (this.value == null || this.value.isEmpty()) {
            throw new IllegalArgumentException("Rule value cannot be null or empty");
        }
        if ((this.keyword == null || this.keyword.isEmpty()) && this.delimiters != null && !this.delimiters.isEmpty()) {
            throw new IllegalArgumentException("When Rule keyword is empty, delimiters must be empty");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getKeyword() {
        return this.keyword;
    }

    public List<String> getDelimiters() {
        return this.delimiters;
    }

    public List<String> getValue() {
        return this.value;
    }

    public Map<String, List<String>> getWhiteRegex() {
        return this.whiteRegex;
    }

    public boolean isDefaultRule() {
        return this.defaultRule;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setKeyword(List<String> keyword) {
        this.keyword = keyword;
    }

    public void setDelimiters(List<String> delimiters) {
        this.delimiters = delimiters;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public void setWhiteRegex(Map<String, List<String>> whiteRegex) {
        this.whiteRegex = whiteRegex;
    }

    public void setDefaultRule(boolean defaultRule) {
        this.defaultRule = defaultRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SensitiveRule)) {
            return false;
        }
        SensitiveRule other = (SensitiveRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDefaultRule() != other.isDefaultRule()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$keyword = this.getKeyword();
        List<String> other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !((Object)this$keyword).equals(other$keyword)) {
            return false;
        }
        List<String> this$delimiters = this.getDelimiters();
        List<String> other$delimiters = other.getDelimiters();
        if (this$delimiters == null ? other$delimiters != null : !((Object)this$delimiters).equals(other$delimiters)) {
            return false;
        }
        List<String> this$value = this.getValue();
        List<String> other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Map<String, List<String>> this$whiteRegex = this.getWhiteRegex();
        Map<String, List<String>> other$whiteRegex = other.getWhiteRegex();
        return !(this$whiteRegex == null ? other$whiteRegex != null : !((Object)this$whiteRegex).equals(other$whiteRegex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SensitiveRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefaultRule() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : ((Object)$keyword).hashCode());
        List<String> $delimiters = this.getDelimiters();
        result = result * 59 + ($delimiters == null ? 43 : ((Object)$delimiters).hashCode());
        List<String> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Map<String, List<String>> $whiteRegex = this.getWhiteRegex();
        result = result * 59 + ($whiteRegex == null ? 43 : ((Object)$whiteRegex).hashCode());
        return result;
    }
}

