/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.pass;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.rapt.commons.utils.IOUtils;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.pass.PasswordTool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PasswordToolImpl
implements PasswordTool {
    private static final Logger logger = SecurityLogManager.getLogger(PasswordToolImpl.class);
    private static final String blockListFilename = "/pass/blocklist.txt";
    private static final Set<String> blockList = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBlocklistFromResource() throws IOException {
        if (!blockList.isEmpty()) {
            return;
        }
        Set<String> set = blockList;
        synchronized (set) {
            if (!blockList.isEmpty()) {
                return;
            }
            InputStream is = PasswordToolImpl.class.getResourceAsStream(blockListFilename);
            if (is == null) {
                return;
            }
            List passwords = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
            is.close();
            blockList.addAll(passwords);
        }
    }

    public boolean checkPasswordStrength(String password) {
        return this.checkPasswordStrength(password, false);
    }

    public boolean checkPasswordStrength(String password, boolean acceptCommonPassword) {
        if (password == null || password.length() < 8) {
            return false;
        }
        int upper = 0;
        int lower = 0;
        int numeric = 0;
        int special = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if ('a' <= c && c <= 'z') {
                lower = 1;
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                upper = 1;
                continue;
            }
            if ('0' <= c && c <= '9') {
                numeric = 1;
                continue;
            }
            special = 1;
        }
        if (upper + lower + numeric + special < 3) {
            return false;
        }
        if (acceptCommonPassword) {
            return true;
        }
        try {
            PasswordToolImpl.loadBlocklistFromResource();
        }
        catch (Exception e) {
            logger.warn("load block list error");
            logger.warn((Object)e);
        }
        return !blockList.contains(this.getPasswordHash(password));
    }

    protected String getPasswordHash(String pwd) {
        pwd = "MR29##" + pwd + "##@Komsy";
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(pwd.getBytes(StandardCharsets.UTF_8));
            return PasswordToolImpl.bytesToHex(encodedhash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

