/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.mask.division;

import com.aliyun.securitysdk.mask.division.AdministrativeDivision;
import com.aliyun.securitysdk.mask.division.AreaNormalizer;
import com.aliyun.securitysdk.mask.division.DivisionLoader;
import com.aliyun.securitysdk.mask.division.model.AreaEntity;
import com.aliyun.securitysdk.mask.division.model.CityEntity;
import com.aliyun.securitysdk.mask.division.model.DivisionEntity;
import com.aliyun.securitysdk.mask.division.model.ProvinceEntity;
import com.aliyun.securitysdk.util.Function;
import com.aliyun.securitysdk.util.Maps;
import com.aliyun.securitysdk.util.trie.AhoCorasickDoubleArrayTrie;
import java.util.List;
import java.util.Map;

public class SimpleAreaNormalizer
implements AreaNormalizer {
    private static final AhoCorasickDoubleArrayTrie<String> TRIE = new AhoCorasickDoubleArrayTrie();

    public AdministrativeDivision normalize(String address) {
        List<AhoCorasickDoubleArrayTrie.Hit<String>> hits = TRIE.parseText(address);
        AdministrativeDivision division = new AdministrativeDivision();
        for (AhoCorasickDoubleArrayTrie.Hit<String> hit : hits) {
            this.extract(DivisionLoader.instance.getNamedDivisionEntityMap().get(hit.value), division);
        }
        return division;
    }

    private void extract(DivisionEntity divisionEntity, AdministrativeDivision division) {
        if (divisionEntity instanceof ProvinceEntity) {
            this.extract((ProvinceEntity)divisionEntity, division);
        } else if (divisionEntity instanceof CityEntity) {
            this.extract((CityEntity)divisionEntity, division);
        } else if (divisionEntity instanceof AreaEntity) {
            this.extract((AreaEntity)divisionEntity, division);
        }
    }

    private void extract(ProvinceEntity divisionEntity, AdministrativeDivision division) {
        if (divisionEntity != null && division.getProvince() == null) {
            division.setProvince(divisionEntity.getName());
        }
    }

    private void extract(CityEntity divisionEntity, AdministrativeDivision division) {
        if (divisionEntity != null) {
            if (division.getCity() == null) {
                division.setCity(divisionEntity.getName());
            }
            if (division.getProvince() == null) {
                division.setProvince(divisionEntity.getProvince());
            }
        }
    }

    private void extract(AreaEntity divisionEntity, AdministrativeDivision division) {
        if (divisionEntity != null) {
            if (division.getDistrict() == null) {
                division.setDistrict(divisionEntity.getName());
            }
            if (division.getCity() == null) {
                Integer cityId = divisionEntity.getId() / 100 * 100;
                DivisionEntity cityDivisionEntity = DivisionLoader.instance.getIdDivisionEntityMap().get(cityId);
                this.extract(cityDivisionEntity, division);
            }
        }
    }

    static {
        Map<String, String> entityMap = Maps.index(DivisionLoader.instance.getNamedDivisionEntityMap().keySet(), new Function<String, String>(){

            @Override
            public String apply(String key) {
                return key;
            }
        });
        TRIE.build(entityMap);
    }
}

