/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import java.util.Arrays;
import java.util.List;

public class LindormLikeUrlParser
extends DefaultUrlParser {
    protected List<String> acceptedSchemes = Arrays.asList("jdbc:lindorm:table:", "jdbc:lindorm:search:", "jdbc:lindorm:phoenix:", "jdbc:lindorm:analytics:", "jdbc:lindorm:tsdb:");

    @Override
    protected String getParamSeparator() {
        return ";";
    }

    @Override
    public void parse(String url) throws JdbcURLException {
        String[] kvs;
        String urlSecondPart = null;
        for (String s : this.getAcceptedSchemes()) {
            if (!url.startsWith(s)) continue;
            this.scheme = s;
            urlSecondPart = url.substring(s.length());
            break;
        }
        if (urlSecondPart == null) {
            throw new JdbcURLUnsafeException("url not supported: " + url);
        }
        for (String kv : kvs = urlSecondPart.split(";")) {
            String[] fields = kv.split("=");
            if (fields.length != 2) continue;
            this.properties.put(fields[0].trim(), fields[1].trim());
        }
    }

    @Override
    public String toString() {
        return this.getScheme() + this.propertiesToString();
    }

    public List<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }
}

