/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.parser;

import com.aliyun.securitysdk.jdbc.JdbcURLException;
import com.aliyun.securitysdk.jdbc.JdbcURLUnsafeException;
import com.aliyun.securitysdk.jdbc.parser.DefaultUrlParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ElasticSearchParser
extends DefaultUrlParser {
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("^(https?://)(.*)");
    private String connType = "";

    @Override
    public void parse(String url) throws JdbcURLException {
        this.initialUrl = url;
        int separator = url.indexOf("//");
        if (separator == -1) {
            throw new JdbcURLUnsafeException("url parsing error : '//' is not present in the url " + url);
        }
        this.scheme = url.substring(0, separator);
        String urlSecondPart = url.substring(separator + 2);
        Matcher matcher = HTTP_URL_PATTERN.matcher(urlSecondPart);
        if (matcher.find()) {
            this.connType = matcher.group(1);
            this.parseUrlWithoutScheme(matcher.group(2));
        } else {
            this.parseUrlWithoutScheme(urlSecondPart);
        }
    }

    @Override
    public String toString() {
        return this.scheme + "//" + this.connType + this.host + (this.port > -1 ? ":" + this.port : "") + (this.database != null ? "/" + this.database : "/") + (this.properties.isEmpty() ? "" : this.getParamMarker() + this.propertiesToString());
    }
}

