/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.jdbc.filters;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.jdbc.UrlParser;
import com.aliyun.securitysdk.jdbc.filters.DefaultFilter;
import com.aliyun.securitysdk.jdbc.parser.BigQueryParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class BigQueryFilter
extends DefaultFilter {
    private static final Logger logger = SecurityLogManager.getLogger(BigQueryFilter.class);
    private final Set<String> acceptedSchemes = new HashSet<String>(Arrays.asList("jdbc:bigquery:"));
    private Set<String> acceptedPropertyKeys = new HashSet<String>(Arrays.asList("ProjectId", "OAuthType", "AdditionalProjects", "AllowLargeResults", "DefaultDataset", "EnableHighThroughputAPI", "EnableSession", "FilterTablesOnDefaultDataset", "HighThroughputActivationRatio", "HighThroughputMinTableSize", "KMSKeyName", "LargeResultDataset", "LargeResultsDatasetExpirationTime", "LargeResultTable", "Location", "MaxResults", "MetaDataFetchThreadCount", "OAuthAccessToken", "OAuthClientId", "OAuthClientSecret", "OAuthPvtKey", "OAuthRefreshToken", "OAuthServiceAcctEmail", "OAuthType", "QueryDialect", "QueryProperties", "RequestGoogleDriveScope", "StringColumnLength", "Timeout", "TimestampFallback", "UnsupportedHTAPIFallback", "useQueryCache"));
    private static final Map<String, Pattern> propertyPatterns = new HashMap<String, Pattern>();
    private Set<String> propertyKeyWhiteList = new HashSet<String>(Arrays.asList("OAuthPvtKey"));

    @Override
    public Map<String, Pattern> getPropertyPatterns() {
        return propertyPatterns;
    }

    @Override
    public boolean checkAndFilterProperties(UrlParser parser) {
        boolean ret = super.checkAndFilterProperties(parser);
        String pvtKey = (String)parser.getProperties().get("OAuthPvtKey");
        if (pvtKey == null || pvtKey.isEmpty()) {
            return ret;
        }
        if ((pvtKey = pvtKey.trim()).contains("../") || pvtKey.startsWith("/") || !pvtKey.startsWith("{")) {
            parser.getProperties().remove("OAuthPvtKey");
            logger.info("OAuthPvtKey is removed by jdbc url filter: ", (Object)pvtKey);
            return false;
        }
        return ret;
    }

    @Override
    public UrlParser getUrlParser() {
        return new BigQueryParser();
    }

    @Override
    public Set<String> getAcceptedSchemes() {
        return this.acceptedSchemes;
    }

    @Override
    public Set<String> getAcceptedPropertyKeys() {
        return this.acceptedPropertyKeys;
    }

    @Override
    public void setAcceptedPropertyKeys(Set<String> acceptedPropertyKeys) {
        this.acceptedPropertyKeys = acceptedPropertyKeys;
    }

    @Override
    public Set<String> getPropertyKeyWhiteList() {
        return this.propertyKeyWhiteList;
    }

    @Override
    public void setPropertyKeyWhiteList(Set<String> propertyKeyWhiteList) {
        this.propertyKeyWhiteList = propertyKeyWhiteList;
    }

    static {
        propertyPatterns.put("AdditionalProjects".toLowerCase(), Pattern.compile("^[a-zA-Z0-9_\\-\\.:,]+$"));
        propertyPatterns.put("OAuthServiceAcctEmail".toLowerCase(), Pattern.compile("^[a-zA-Z0-9_\\-\\.:,@]+$"));
        propertyPatterns.put("QueryProperties".toLowerCase(), Pattern.compile("^[a-zA-Z0-9_\\-\\.:,=]+$"));
        propertyPatterns.put("OAuthClientSecret".toLowerCase(), Pattern.compile("^[a-zA-Z0-9_\\-\\.:,/=+]+$"));
    }
}

