/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.api.servlets.providers;

import com.alibaba.securitysdk.logging.api.factories.LoggerManager;
import com.alibaba.securitysdk.logging.api.loggers.SimpleLogger;
import com.alibaba.securitysdk.logging.api.servlets.ProfileProvider;
import com.alibaba.securitysdk.logging.api.servlets.profiles.ServletContextInfo;
import com.alibaba.securitysdk.logging.utils.AssertUtil;
import javax.servlet.ServletContext;

public class ServletContextProvider
implements ProfileProvider<ServletContextInfo> {
    private final ServletContext sc;
    private final SimpleLogger logger = LoggerManager.getLogger(SimpleLogger.class);

    public ServletContextProvider(ServletContext sc) {
        this.sc = (ServletContext)AssertUtil.notNull((Object)sc);
    }

    @Override
    public ServletContextInfo provide() {
        ServletContextInfo servletContextInfo = new ServletContextInfo();
        try {
            servletContextInfo.setMajorVersion(this.sc.getMajorVersion());
            servletContextInfo.setMinorVersion(this.sc.getMinorVersion());
            servletContextInfo.setEffectiveMajorVersion(this.sc.getEffectiveMajorVersion());
            servletContextInfo.setEffectiveMinorVersion(this.sc.getEffectiveMinorVersion());
        }
        catch (UnsupportedOperationException ex) {
            this.logger.warn(ex.toString(), ex, new Object[0]);
        }
        return servletContextInfo;
    }
}

