/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.api.utils.UuidUtils;
import com.aliyun.migration.client.Command;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrResultStatisticFileOperator;
import com.aliyun.migration.workflow.migration.common.spi.PluginHandler;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.ZipFileUtil;
import com.aliyun.migration.workflow.migration.common.utils.cloud.CallbackProperties;
import com.aliyun.migration.workflow.migration.common.utils.cloud.ExecCallbackMessage;
import com.aliyun.migration.workflow.migration.common.utils.cloud.MnsClient;
import com.aliyun.migration.workflow.migration.common.utils.cloud.OssCloudClient;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ReaderCommand
extends Command {
    private static final Logger log = LoggerFactory.getLogger(ReaderCommand.class);
    private Reader reader;
    private List<String> projects;

    public ReaderCommand() {
        this.addOption();
    }

    @Override
    public void getPlugin(TaskContext taskContext) {
        this.reader = PluginHandler.getReader((String)taskContext.getReaderName());
        this.commandName = "reader";
    }

    @Override
    public void closePlugin() {
        Optional.ofNullable(this.reader).ifPresent(Reader::close);
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        String outFilePath;
        String sourceFilePath;
        Datasource datasource;
        BwmConfiguration configration;
        String sourceSchedule;
        String readerType = cmd.getOptionValue("t");
        String configStr = BwmPackageFileOperator.JsonType.JSON_TYPE.value;
        if (cmd.hasOption("c")) {
            String configPath = cmd.getOptionValue("c");
            File file = new File(configPath);
            if (file.exists()) {
                configStr = FileUtils.readFileToString((File)file, (String)Charsets.UTF_8.name());
            } else {
                log.error("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)configPath);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(sourceSchedule = (configration = BwmConfiguration.from((String)configStr)).getString("schedule_datasource")))) {
            datasource = (Datasource)JSONObject.parseObject((String)sourceSchedule, Datasource.class);
            if (Objects.isNull(datasource)) {
                log.error("\u65e0\u6cd5\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u8fc1\u79fb\u6e90\u7aef\u6570\u636e\u6e90\u4fe1\u606f\uff1a{}", (Object)sourceSchedule);
                datasource = new Datasource();
            }
        } else {
            log.warn("\u914d\u7f6e\u9879\u4e2d\u672a\u83b7\u53d6\u5230\u6e90\u7aef\u8c03\u5ea6\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u9ed8\u8ba4\u4f7f\u7528\u7a7a\u6570\u636e\u6e90");
            datasource = new Datasource();
        }
        if (CollectionUtils.isEmpty((Map)datasource.getProperties())) {
            datasource.setProperties(new HashMap());
        }
        if (cmd.hasOption("f") && !StringUtils.isEmpty((CharSequence)(sourceFilePath = cmd.getOptionValue("f")))) {
            datasource.getProperties().put("source-file-path", sourceFilePath);
        }
        if (cmd.hasOption("o") && !StringUtils.isEmpty((CharSequence)(outFilePath = cmd.getOptionValue("o")))) {
            datasource.getProperties().put("export-file-path", outFilePath);
        }
        TaskContext taskContext = new TaskContext();
        taskContext.setReaderDatasource(datasource);
        taskContext.setReaderName(readerType);
        taskContext.setBwmConfiguration(configration.getString("conf"));
        taskContext.setSaasConfiguration(configration.getString("saas"));
        return taskContext;
    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {
        Object sourcePath = (String)taskContext.getReaderDatasource().getProperties().get("source-file-path");
        Object exportPath = (String)taskContext.getReaderDatasource().getProperties().get("export-file-path");
        if (taskContext.getReaderDatasource().getProperties().containsKey("operator") && ((String)taskContext.getReaderDatasource().getProperties().get("operator")).equalsIgnoreCase(Datasource.OperaterType.MANUAL.name())) {
            if (StringUtils.isEmpty((CharSequence)sourcePath) || !new File((String)sourcePath).exists()) {
                log.error("\u79bb\u7ebf\u6a21\u5f0f\uff0c\u8f93\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", sourcePath);
                throw new RuntimeException("\u79bb\u7ebf\u6a21\u5f0f\uff0c\u8f93\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + (String)sourcePath);
            }
            if (StringUtils.isEmpty((CharSequence)exportPath)) {
                taskContext.getReaderDatasource().getProperties().put("export-file-path", "/temp/export/ReaderOutput.zip");
            }
            this.reader.init(taskContext);
            WorkflowProjectPackage readerResultPkg = this.reader.read();
            this.reader.makeStatisticOp();
            this.reader.export();
            this.projects = new ArrayList<String>();
            this.projects.add(readerResultPkg.getWorkflowProject().getProjectId());
        } else {
            this.projects = new ArrayList<String>();
            if (taskContext.getReaderDatasource().getProperties().containsKey("project")) {
                this.projects = Arrays.asList(((String)taskContext.getReaderDatasource().getProperties().get("project")).split(","));
                this.reader.init(taskContext);
                workflowProjectList = this.reader.getProjectList();
                if (!CollectionUtils.isEmpty((Collection)workflowProjectList) && !CollectionUtils.isEmpty(this.projects)) {
                    ArrayList projectIds = new ArrayList();
                    for (WorkflowProject workflowProject : workflowProjectList) {
                        if ((!StringUtils.isNotBlank((CharSequence)workflowProject.getProjectId()) || !this.projects.contains(workflowProject.getProjectId())) && (!StringUtils.isNotBlank((CharSequence)workflowProject.getName()) || !this.projects.contains(workflowProject.getName()))) continue;
                        projectIds.add(workflowProject.getProjectId());
                    }
                    if (CollectionUtils.isEmpty((Collection)projectIds)) {
                        log.error("\u65e0\u6cd5\u83b7\u53d6\u5230\u6307\u5b9aproject\u7684\u4fe1\u606f\uff1a{}", this.projects);
                        throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6307\u5b9aproject\u7684\u4fe1\u606f\uff1a" + this.projects);
                    }
                    this.projects = projectIds;
                    log.info("\u83b7\u53d6\u5230\u6307\u5b9aproject\u7684\u4fe1\u606f\uff1a{}", this.projects);
                }
            } else {
                try {
                    this.reader.init(taskContext);
                    workflowProjectList = this.reader.getProjectList();
                    for (WorkflowProject workflowProject : workflowProjectList) {
                        this.projects.add(workflowProject.getProjectId());
                    }
                }
                catch (Exception e) {
                    log.warn("\u65e0\u6cd5\u83b7\u53d6\u5230project\u5217\u8868", (Throwable)e);
                }
            }
            if (this.projects.size() == 0) {
                if (StringUtils.isEmpty((CharSequence)sourcePath)) {
                    taskContext.getReaderDatasource().getProperties().put("source-file-path", "/temp/source/SourceOutput.zip");
                }
                if (StringUtils.isEmpty((CharSequence)exportPath)) {
                    taskContext.getReaderDatasource().getProperties().put("export-file-path", "/temp/export/ReaderOutput.zip");
                }
                this.reader.init(taskContext);
                this.reader.read();
                this.reader.makeStatisticOp();
                this.reader.export();
            } else if (this.projects.size() == 1) {
                if (StringUtils.isEmpty((CharSequence)sourcePath)) {
                    sourcePath = "/temp/source";
                }
                if (StringUtils.isEmpty((CharSequence)exportPath)) {
                    exportPath = "/temp/export";
                }
                if (new File((String)sourcePath).isDirectory()) {
                    sourcePath = (String)sourcePath + "/" + this.projects.get(0) + ".zip";
                }
                if (new File((String)exportPath).isDirectory()) {
                    exportPath = (String)exportPath + "/" + this.projects.get(0) + ".zip";
                }
                taskContext.getReaderDatasource().getProperties().put("project", this.projects.get(0));
                taskContext.getReaderDatasource().getProperties().put("source-file-path", sourcePath);
                taskContext.getReaderDatasource().getProperties().put("export-file-path", exportPath);
                this.reader.init(taskContext);
                this.reader.read();
                this.reader.makeStatisticOp();
                this.reader.export();
            } else {
                if (StringUtils.isEmpty((CharSequence)sourcePath)) {
                    sourcePath = "/temp/source";
                }
                if (StringUtils.isEmpty((CharSequence)exportPath)) {
                    exportPath = "/temp/export";
                }
                if (new File((String)sourcePath).isFile()) {
                    sourcePath = new File((String)sourcePath).getParent();
                }
                if (new File((String)exportPath).isFile()) {
                    exportPath = new File((String)exportPath).getParent();
                }
                for (String project : this.projects) {
                    try {
                        log.info("\u5f00\u59cb\u83b7\u53d6project: {}, \u8f93\u51fa\u81f3\uff1a{}", (Object)project, (Object)((String)exportPath + "/" + project + ".zip"));
                        taskContext.getReaderDatasource().getProperties().put("project", project);
                        taskContext.getReaderDatasource().getProperties().put("source-file-path", (String)sourcePath + "/" + project + ".zip");
                        taskContext.getReaderDatasource().getProperties().put("export-file-path", (String)exportPath + "/" + project + ".zip");
                        this.reader.init(taskContext);
                        this.reader.read();
                        this.reader.makeStatisticOp();
                        this.reader.export();
                    }
                    catch (Exception e) {
                        log.warn("\u83b7\u53d6project: {} \u5931\u8d25", (Object)project, (Object)e);
                    }
                }
            }
        }
    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        ArrayList<WorkflowProjectPackage> pkgs = new ArrayList<WorkflowProjectPackage>();
        ArrayList<String> pkgFilePaths = new ArrayList<String>();
        if (Objects.isNull(bwmSaasConfiguration.getLocal())) {
            log.info("SaaS\u914d\u7f6e\u4e2dlocal\u914d\u7f6e\u4e3a\u7a7a, use default");
            bwmSaasConfiguration.getLocal().useDefault("");
            taskContext.setSaasConfiguration(JSONObject.toJSONString((Object)bwmSaasConfiguration, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        }
        if (Objects.isNull(bwmSaasConfiguration.getOss())) {
            log.warn("SaaS\u914d\u7f6e\u4e2doss\u914d\u7f6e\u4e3a\u7a7a, \u6267\u884c\u5b8c\u6210\u540e\u5c06\u8df3\u8fc7\u4e0a\u4f20");
        }
        if (taskContext.getReaderDatasource().getProperties().containsKey("operator") && ((String)taskContext.getReaderDatasource().getProperties().get("operator")).equalsIgnoreCase(Datasource.OperaterType.MANUAL.name())) {
            String sourcePath = bwmSaasConfiguration.getLocal().getInputFileReadPath().getMainPackage();
            if (StringUtils.isEmpty((CharSequence)sourcePath) || !new File(sourcePath).exists()) {
                log.error("SaaS\u79bb\u7ebf\u6570\u636e\u6e90\u6a21\u5f0f\uff0c\u8f93\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)sourcePath);
                throw new RuntimeException("\u79bb\u7ebf\u6a21\u5f0f\uff0c\u8f93\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + sourcePath);
            }
            log.info("SaaS\u79bb\u7ebf\u6570\u636e\u6e90\u6a21\u5f0f\uff0c\u83b7\u53d6\u5230\u8f93\u5165\u6587\u4ef6\uff1a{}", (Object)sourcePath);
            taskContext.setSourceFilePackage(sourcePath);
            if (MapUtils.isEmpty((Map)taskContext.getReaderDatasource().getProperties())) {
                taskContext.getReaderDatasource().setProperties(new HashMap());
            }
            taskContext.getReaderDatasource().getProperties().put("source-file-path", sourcePath);
            String exportPath = bwmSaasConfiguration.getDiscoveryPackageZipSavePath(null);
            pkgFilePaths.add(exportPath);
            taskContext.getReaderDatasource().getProperties().put("export-file-path", exportPath);
            this.reader.init(taskContext);
            WorkflowProjectPackage pkg = this.reader.read();
            pkgs.add((WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)pkg, WorkflowProjectPackage.class));
            this.projects = List.of(pkg.getWorkflowProject().getProjectId());
            this.reader.makeStatisticOp();
            this.reader.export();
        } else {
            this.projects = new ArrayList<String>();
            if (taskContext.getReaderDatasource().getProperties().containsKey("project")) {
                this.projects = Arrays.asList(((String)taskContext.getReaderDatasource().getProperties().get("project")).split(","));
                this.reader.init(taskContext);
                workflowProjectList = this.reader.getProjectList();
                if (!CollectionUtils.isEmpty((Collection)workflowProjectList) && !CollectionUtils.isEmpty(this.projects)) {
                    ArrayList projectIds = new ArrayList();
                    for (WorkflowProject workflowProject : workflowProjectList) {
                        if ((!StringUtils.isNotBlank((CharSequence)workflowProject.getProjectId()) || !this.projects.contains(workflowProject.getProjectId())) && (!StringUtils.isNotBlank((CharSequence)workflowProject.getName()) || !this.projects.contains(workflowProject.getName()))) continue;
                        projectIds.add(workflowProject.getProjectId());
                    }
                    if (CollectionUtils.isEmpty((Collection)projectIds)) {
                        log.error("\u65e0\u6cd5\u83b7\u53d6\u5230\u6307\u5b9aproject\u7684\u4fe1\u606f\uff1a{}", this.projects);
                        throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6307\u5b9aproject\u7684\u4fe1\u606f\uff1a" + this.projects);
                    }
                    this.projects = projectIds;
                    log.info("\u83b7\u53d6\u5230\u6307\u5b9aproject\u7684\u4fe1\u606f\uff1a{}", this.projects);
                }
            } else {
                try {
                    this.reader.init(taskContext);
                    workflowProjectList = this.reader.getProjectList();
                    for (WorkflowProject workflowProject : workflowProjectList) {
                        this.projects.add(workflowProject.getProjectId());
                    }
                }
                catch (Exception e) {
                    log.warn("\u65e0\u6cd5\u83b7\u53d6\u5230project\u5217\u8868", (Throwable)e);
                }
            }
            if (this.projects.size() == 0) {
                sourcePath = bwmSaasConfiguration.getDiscoveryApiOutputPackageZipSavePath(null);
                exportPath = bwmSaasConfiguration.getDiscoveryPackageZipSavePath(null);
                taskContext.getReaderDatasource().getProperties().put("source-file-path", sourcePath);
                taskContext.getReaderDatasource().getProperties().put("export-file-path", exportPath);
                pkgFilePaths.add(exportPath);
                this.reader.init(taskContext);
                pkg = this.reader.read();
                pkgs.add((WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)pkg, WorkflowProjectPackage.class));
                this.reader.makeStatisticOp();
                this.reader.export();
            } else if (this.projects.size() == 1) {
                sourcePath = bwmSaasConfiguration.getDiscoveryApiOutputPackageZipSavePath(this.projects.get(0));
                exportPath = bwmSaasConfiguration.getDiscoveryPackageZipSavePath(this.projects.get(0));
                taskContext.getReaderDatasource().getProperties().put("project", this.projects.get(0));
                taskContext.getReaderDatasource().getProperties().put("source-file-path", sourcePath);
                taskContext.getReaderDatasource().getProperties().put("export-file-path", exportPath);
                pkgFilePaths.add(exportPath);
                this.reader.init(taskContext);
                pkg = this.reader.read();
                pkgs.add((WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)pkg, WorkflowProjectPackage.class));
                this.reader.makeStatisticOp();
                this.reader.export();
            } else {
                for (String project : this.projects) {
                    try {
                        String sourcePath = bwmSaasConfiguration.getDiscoveryApiOutputPackageZipSavePath(project);
                        String exportPath = bwmSaasConfiguration.getDiscoveryPackageZipSavePath(project);
                        log.info("\u5f00\u59cb\u83b7\u53d6project: {}, \u8f93\u51fa\u81f3\uff1a{}", (Object)project, (Object)exportPath);
                        taskContext.getReaderDatasource().getProperties().put("project", project);
                        taskContext.getReaderDatasource().getProperties().put("source-file-path", sourcePath);
                        taskContext.getReaderDatasource().getProperties().put("export-file-path", exportPath);
                        pkgFilePaths.add(exportPath);
                        this.reader.init(taskContext);
                        WorkflowProjectPackage pkg = this.reader.read();
                        pkgs.add((WorkflowProjectPackage)BwmJsonUtil.deepCopy((Object)pkg, WorkflowProjectPackage.class));
                        this.reader.makeStatisticOp();
                        this.reader.export();
                    }
                    catch (Exception e) {
                        log.warn("\u83b7\u53d6project: {} \u5931\u8d25", (Object)project, (Object)e);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(pkgFilePaths)) {
            ZipFileUtil.compressFilesToZip(pkgFilePaths, (String)bwmSaasConfiguration.getDiscoveryPackageZipBatchSavePath());
        }
        this.saveSaasInstanceOverviewSrJsonFile(pkgs, bwmSaasConfiguration);
    }

    public void saveSaasInstanceOverviewSrJsonFile(List<WorkflowProjectPackage> pkgs, BwmSaasConfiguration bwmSaasConfiguration) {
        BwmPackageSrResultStatisticFileOperator.writeDiscoverySrResultMappingOverviewFile(pkgs, (BwmSaasConfiguration)bwmSaasConfiguration);
    }

    @Override
    public void copyLogFile(TaskContext taskContext) {
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        String logFilePath = bwmSaasConfiguration.getDiscoveryLogFileSavePath(null);
        File systemLogFolder = new File("./logs");
        try {
            FileUtils.copyDirectory((File)systemLogFolder, (File)new File(logFilePath));
        }
        catch (IOException e) {
            log.warn("\u62f7\u8d1d\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void uploadFileToOss(TaskContext taskContext) {
        if (StringUtils.isEmpty((CharSequence)taskContext.getSaasConfiguration())) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u5230OSS");
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        if (Objects.isNull(bwmSaasConfiguration.getLocal())) {
            log.warn("SaaS\u914d\u7f6e\u4e2dlocal\u914d\u7f6e\u4e3a\u7a7a, \u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        if (Objects.isNull(bwmSaasConfiguration.getOss())) {
            log.warn("SaaS\u914d\u7f6e\u4e2doss\u914d\u7f6e\u4e3a\u7a7a, \u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        OssCloudClient ossCloudClient = new OssCloudClient(bwmSaasConfiguration.getOss().getEndpoint(), bwmSaasConfiguration.getOss().getAk(), bwmSaasConfiguration.getOss().getSk());
        ossCloudClient.uploadAndMergeFolder(bwmSaasConfiguration.getOss().getBucket(), bwmSaasConfiguration.getOss().getRootPath(), bwmSaasConfiguration.getLocal().getOutputFileSaveRootPath());
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5b8c\u6210");
        ossCloudClient.createFile(bwmSaasConfiguration.getOss().getBucket(), bwmSaasConfiguration.getDiscoveryInstanceStatusFileOssPath(), "{\"status\":\"finish\"}");
    }

    @Override
    public void sendMns(BwmSaasConfiguration bwmSaasConfiguration) {
        if (bwmSaasConfiguration == null) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u53d1\u9001MNS");
            return;
        }
        CallbackProperties properties = new CallbackProperties();
        properties.setAccessKeyId(bwmSaasConfiguration.getMns().getAk());
        properties.setAccessKeySecret(bwmSaasConfiguration.getMns().getSk());
        properties.setEndpoint(bwmSaasConfiguration.getMns().getEndpoint());
        properties.setTopicName(bwmSaasConfiguration.getMns().getTopicName());
        MnsClient mnsClient = new MnsClient(properties);
        ExecCallbackMessage callbackMessage = new ExecCallbackMessage();
        callbackMessage.setTenantUuid(bwmSaasConfiguration.getMeta().getTenantUuid());
        callbackMessage.setTaskUuid(bwmSaasConfiguration.getMeta().getTaskUuid());
        callbackMessage.setInstanceChainUuid(bwmSaasConfiguration.getMeta().getInstanceChainUuid());
        callbackMessage.setInstanceUuid(bwmSaasConfiguration.getMeta().getInstanceUuid());
        callbackMessage.setMetaVersion(bwmSaasConfiguration.getMeta().getMetaVersion());
        callbackMessage.setScheduleDatasourceUuid(bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        callbackMessage.setInputMetaVersion(bwmSaasConfiguration.getMeta().getInputMetaVersion());
        callbackMessage.setIsSuccess(Boolean.valueOf(true));
        callbackMessage.setMsgTime(callbackMessage.ofBizDate());
        callbackMessage.setErrorMsg(null);
        callbackMessage.setStageType(bwmSaasConfiguration.getStageType().name());
        callbackMessage.setProjectIds(this.projects);
        callbackMessage.setUid(UuidUtils.randomUuid());
        mnsClient.sendMessage(callbackMessage);
        mnsClient.close();
    }

    @Override
    public void addOption() {
        this.options.addOption(Option.builder((String)"c").argName("conf").hasArg().desc("\u914d\u7f6e\u6587\u4ef6").required(false).build());
        this.options.addOption(Option.builder((String)"f").argName("file").hasArg().desc("\uff08\u53ef\u9009\uff09\u539f\u59cb\u6587\u4ef6").required(false).build());
        this.options.addOption(Option.builder((String)"o").argName("out").hasArg().desc("\u8f93\u51fa\u6587\u4ef6\u540d\u79f0\u53ca\u8def\u5f84").required(false).build());
        this.options.addOption(Option.builder((String)"t").argName("type").hasArg().desc("\u8bfb\u63d2\u4ef6\u7c7b\u578b").required(true).build());
    }

    @Override
    public String getName() {
        return "read";
    }

    @Override
    public String desc() {
        return "\u901a\u8fc7\u6307\u5b9a\u914d\u7f6e\u5b8c\u6210\u8c03\u5ea6\u7684\u89e3\u6790\u548c\u8bfb\u53d6";
    }
}

