/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.utils.UuidUtils;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.spi.RegisterOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmCommonUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmHttpClientUtil;
import com.aliyun.migration.workflow.migration.common.utils.cloud.CallbackProperties;
import com.aliyun.migration.workflow.migration.common.utils.cloud.ExecCallbackMessage;
import com.aliyun.migration.workflow.migration.common.utils.cloud.MnsClient;
import com.aliyun.migration.workflow.migration.common.utils.cloud.OssCloudClient;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command {
    private static final Logger log = LoggerFactory.getLogger(Command.class);
    protected HelpFormatter formatter = new HelpFormatter();
    protected CommandLineParser parse = new DefaultParser();
    protected Options options = new Options();
    protected String commandName;

    protected Command() {
        this.formatter.setOptionComparator((o1, o2) -> 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String[] args) throws Exception {
        System.setProperty("file.encoding", "zh_CN.UTF-8");
        TaskContext taskContext = new TaskContext();
        try {
            CommandLine cmd = this.parse.parse(this.options, args);
            if (cmd.hasOption("help")) {
                this.usage();
                return;
            }
            taskContext = this.getTaskContext(cmd);
            this.downloadFileFromOss(taskContext);
            this.getPlugin(taskContext);
            log.info("taskContext:{}", (Object)taskContext.getBwmConfiguration());
            log.info("exec start!");
            if (StringUtils.isEmpty((CharSequence)taskContext.getSaasConfiguration())) {
                log.info("\u975eSaaS");
                this.execLocal(taskContext);
            } else {
                log.info("SaaS");
                this.execSaas(taskContext);
                this.copyLogFile(taskContext);
                this.uploadFileToOss(taskContext);
                this.sendMns(taskContext);
            }
        }
        catch (Exception e) {
            log.error("exec error\uff0c", (Throwable)e);
            this.usage();
            this.closePlugin();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{taskContext.getSaasConfiguration()})) {
                this.sendMns(taskContext, e.getMessage());
                this.copyLogFile(taskContext);
                this.uploadFileToOss(taskContext);
            }
            System.exit(1);
        }
        finally {
            this.closePlugin();
            log.info("exec finished!");
        }
        System.exit(0);
    }

    public abstract TaskContext getTaskContext(CommandLine var1) throws Exception;

    public abstract void getPlugin(TaskContext var1) throws Exception;

    public abstract void execLocal(TaskContext var1) throws Exception;

    public abstract void execSaas(TaskContext var1) throws Exception;

    public abstract void closePlugin();

    public void copyLogFile(TaskContext taskContext) {
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        String logFilePath = bwmSaasConfiguration.getMigrationLogFileSavePath();
        File systemLogFolder = new File("./logs");
        try {
            FileUtils.copyDirectory((File)systemLogFolder, (File)new File(logFilePath));
        }
        catch (IOException e) {
            log.warn("\u62f7\u8d1d\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public void downloadFileFromOss(TaskContext taskContext) {
        if (StringUtils.isEmpty((CharSequence)taskContext.getSaasConfiguration())) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u4e0b\u8f7d");
            return;
        }
        log.info("\u5f00\u59cb\u4e0b\u8f7d\u6587\u4ef6");
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        this.downloadFileFromOss(bwmSaasConfiguration);
    }

    public void downloadFileFromOss(BwmSaasConfiguration bwmSaasConfiguration) {
        if (Objects.isNull(bwmSaasConfiguration.getOss())) {
            log.warn("SaaS\u914d\u7f6e\u4e2doss\u914d\u7f6e\u4e3a\u7a7a, \u8df3\u8fc7\u4e0b\u8f7d");
            return;
        }
        if (bwmSaasConfiguration.getOss().getDownloadPackageToLocal() == null || CollectionUtils.isEmpty(bwmSaasConfiguration.getOss().getDownloadPackageToLocal().keySet())) {
            log.warn("SaaS\u914d\u7f6e\u4e2doss\u914d\u7f6e\u7684\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a, \u8df3\u8fc7\u4e0b\u8f7d");
            return;
        }
        OssCloudClient ossCloudClient = new OssCloudClient(bwmSaasConfiguration.getOss().getEndpoint(), bwmSaasConfiguration.getOss().getAk(), bwmSaasConfiguration.getOss().getSk());
        for (String fileName2 : bwmSaasConfiguration.getOss().getDownloadPackageToLocal().keySet()) {
            String objectName = (String)bwmSaasConfiguration.getOss().getDownloadPackageToLocal().get(fileName2);
            String localFilePath = fileName2;
            if (!new File(localFilePath).getParentFile().exists()) {
                try {
                    FileUtils.forceMkdir((File)new File(localFilePath).getParentFile());
                }
                catch (IOException e) {
                    log.error("save oss file error", (Throwable)e);
                }
            }
            if (objectName.startsWith("https://") || objectName.startsWith("http://")) {
                BwmHttpClientUtil.downloadFile((String)objectName, null, (File)new File(localFilePath));
                continue;
            }
            if (objectName.startsWith("/")) {
                objectName = objectName.substring(1);
            }
            ossCloudClient.downloadFile(bwmSaasConfiguration.getOss().getBucket(), objectName, localFilePath);
        }
    }

    public void uploadFileToOss(TaskContext taskContext) {
        if (StringUtils.isEmpty((CharSequence)taskContext.getSaasConfiguration())) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u5230OSS");
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        if (Objects.isNull(bwmSaasConfiguration.getLocal())) {
            log.warn("SaaS\u914d\u7f6e\u4e2dlocal\u914d\u7f6e\u4e3a\u7a7a, \u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        if (Objects.isNull(bwmSaasConfiguration.getOss())) {
            log.warn("SaaS\u914d\u7f6e\u4e2doss\u914d\u7f6e\u4e3a\u7a7a, \u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        OssCloudClient ossCloudClient = new OssCloudClient(bwmSaasConfiguration.getOss().getEndpoint(), bwmSaasConfiguration.getOss().getAk(), bwmSaasConfiguration.getOss().getSk());
        ossCloudClient.uploadAndMergeFolder(bwmSaasConfiguration.getOss().getBucket(), bwmSaasConfiguration.getOss().getRootPath(), bwmSaasConfiguration.getLocal().getOutputFileSaveRootPath());
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5b8c\u6210");
    }

    public void sendMns(TaskContext taskContext, String errorMsg) {
        if (StringUtils.isEmpty((CharSequence)taskContext.getSaasConfiguration())) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u53d1\u9001MNS");
            return;
        }
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        this.sendMns(bwmSaasConfiguration, errorMsg);
    }

    public void sendMns(TaskContext taskContext) {
        if (StringUtils.isEmpty((CharSequence)taskContext.getSaasConfiguration())) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u53d1\u9001MNS");
            return;
        }
        BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)taskContext.getSaasConfiguration(), BwmSaasConfiguration.class);
        this.sendMns(bwmSaasConfiguration);
    }

    public void sendMns(BwmSaasConfiguration bwmSaasConfiguration) {
        this.sendMns(bwmSaasConfiguration, null);
    }

    public void sendMns(BwmSaasConfiguration bwmSaasConfiguration, String errorMsg) {
        if (bwmSaasConfiguration == null) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u53d1\u9001MNS");
            return;
        }
        CallbackProperties properties = new CallbackProperties();
        properties.setAccessKeyId(bwmSaasConfiguration.getMns().getAk());
        properties.setAccessKeySecret(bwmSaasConfiguration.getMns().getSk());
        properties.setEndpoint(bwmSaasConfiguration.getMns().getEndpoint());
        properties.setTopicName(bwmSaasConfiguration.getMns().getTopicName());
        MnsClient mnsClient = new MnsClient(properties);
        ExecCallbackMessage callbackMessage = new ExecCallbackMessage();
        callbackMessage.setTenantUuid(bwmSaasConfiguration.getMeta().getTenantUuid());
        callbackMessage.setTaskUuid(bwmSaasConfiguration.getMeta().getTaskUuid());
        callbackMessage.setInstanceChainUuid(bwmSaasConfiguration.getMeta().getInstanceChainUuid());
        callbackMessage.setInstanceUuid(bwmSaasConfiguration.getMeta().getInstanceUuid());
        callbackMessage.setMetaVersion(bwmSaasConfiguration.getMeta().getMetaVersion());
        callbackMessage.setScheduleDatasourceUuid(bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        callbackMessage.setInputMetaVersion(bwmSaasConfiguration.getMeta().getInputMetaVersion());
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            callbackMessage.setIsSuccess(Boolean.valueOf(false));
            callbackMessage.setErrorMsg(errorMsg);
        } else {
            callbackMessage.setIsSuccess(Boolean.valueOf(true));
            callbackMessage.setErrorMsg(null);
        }
        callbackMessage.setMsgTime(callbackMessage.ofBizDate());
        callbackMessage.setStageType(bwmSaasConfiguration.getStageType().name());
        callbackMessage.setUid(UuidUtils.randomUuid());
        mnsClient.sendMessage(callbackMessage);
        mnsClient.close();
    }

    public abstract void addOption();

    public abstract String getName();

    public abstract String desc();

    public void usage() {
        this.formatter.printHelp(this.getName().toLowerCase(Locale.ROOT), this.desc() + "\n\n", this.options, "\n@\u51e0\u6f2b", true);
    }

    protected void init() {
        String pluginLoadPath = BwmCommonUtil.getPluginLoadPath();
        try {
            FileUtils.forceMkdir((File)new File(pluginLoadPath));
        }
        catch (IOException e) {
            log.error("create plugin path error", (Throwable)e);
        }
        RegisterOperator.doRegister();
    }
}

