/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.client;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.utils.UuidUtils;
import com.aliyun.migration.client.Command;
import com.aliyun.migration.client.ConverterCommand;
import com.aliyun.migration.client.DwDIJobPlainMigrationCommand;
import com.aliyun.migration.client.MergeCommand;
import com.aliyun.migration.client.MigrationSupervisorCommand;
import com.aliyun.migration.client.PluginCommand;
import com.aliyun.migration.client.ReaderCommand;
import com.aliyun.migration.client.WriterCommand;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migration.workflow.migration.common.utils.cloud.CallbackProperties;
import com.aliyun.migration.workflow.migration.common.utils.cloud.ExecCallbackMessage;
import com.aliyun.migration.workflow.migration.common.utils.cloud.MnsClient;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BwmClientApp
extends Command {
    private static final Logger log = LoggerFactory.getLogger(BwmClientApp.class);
    private TreeMap<String, Command> commandTreeMap;

    public BwmClientApp() {
        this.formatter.setOptPrefix("");
        this.commandTreeMap = new TreeMap();
        this.addCommand(new ReaderCommand());
        this.addCommand(new ConverterCommand());
        this.addCommand(new WriterCommand());
        this.addCommand(new PluginCommand());
        this.addCommand(new DwDIJobPlainMigrationCommand());
        this.addCommand(new MergeCommand());
        this.addCommand(new MigrationSupervisorCommand());
        for (Map.Entry<String, Command> entry : this.commandTreeMap.entrySet()) {
            this.options.addOption(entry.getKey(), entry.getValue().desc());
        }
        this.options.addOption("help", "\u6253\u5370\u5e2e\u52a9\u4fe1\u606f");
    }

    private void addCommand(Command command) {
        this.commandTreeMap.put(command.getName().toLowerCase(Locale.ROOT), command);
    }

    public static void main(String[] args) {
        log.info("exec args : {}", (Object[])args);
        BwmClientApp bwmClient = new BwmClientApp();
        try {
            bwmClient.exec(args);
        }
        catch (Exception e) {
            log.error("exec error ", (Throwable)e);
            bwmClient.usage();
            BwmClientApp.sendMnsHere(args, e.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }

    @Override
    public void exec(String[] args) throws Exception {
        if (null == args || args.length == 0) {
            this.usage();
            return;
        }
        CommandLine cmd = this.parse.parse(this.options, new String[]{args[0]});
        if (cmd.hasOption("help")) {
            this.usage();
            return;
        }
        Command command = this.commandTreeMap.get(args[0].toLowerCase(Locale.ROOT));
        if (null == command) {
            this.usage();
            return;
        }
        if (args.length == 1) {
            command.usage();
            return;
        }
        this.init();
        command.exec(Arrays.asList(args).subList(1, args.length).toArray(new String[0]));
    }

    @Override
    public TaskContext getTaskContext(CommandLine cmd) throws Exception {
        return null;
    }

    public static void sendMnsHere(String[] args, String errorMsg) {
        try {
            BwmConfiguration configration;
            String saasConfStr;
            DefaultParser parse = new DefaultParser();
            Options options = new Options();
            CommandLine cmd = parse.parse(options, new String[]{args[0]});
            String configStr = BwmPackageFileOperator.JsonType.JSON_TYPE.value;
            if (cmd.hasOption("c")) {
                String configPath = cmd.getOptionValue("c");
                File file = new File(configPath);
                if (file.exists()) {
                    configStr = FileUtils.readFileToString((File)file, (String)Charsets.UTF_8.name());
                } else {
                    log.error("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)configPath);
                }
            }
            if (StringUtils.isEmpty((CharSequence)(saasConfStr = (configration = BwmConfiguration.from((String)configStr)).getString("saas")))) {
                log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u53d1\u9001MNS");
                return;
            }
            BwmSaasConfiguration bwmSaasConfiguration = (BwmSaasConfiguration)JSONObject.parseObject((String)saasConfStr, BwmSaasConfiguration.class);
            BwmClientApp.sendMnsHere(bwmSaasConfiguration, errorMsg);
        }
        catch (Exception e) {
            log.error("sendMns error ", (Throwable)e);
        }
    }

    public static void sendMnsHere(BwmSaasConfiguration bwmSaasConfiguration, String errorMsg) {
        if (bwmSaasConfiguration == null) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u53d1\u9001MNS");
            return;
        }
        CallbackProperties properties = new CallbackProperties();
        properties.setAccessKeyId(bwmSaasConfiguration.getMns().getAk());
        properties.setAccessKeySecret(bwmSaasConfiguration.getMns().getSk());
        properties.setEndpoint(bwmSaasConfiguration.getMns().getEndpoint());
        properties.setTopicName(bwmSaasConfiguration.getMns().getTopicName());
        MnsClient mnsClient = new MnsClient(properties);
        ExecCallbackMessage callbackMessage = new ExecCallbackMessage();
        callbackMessage.setTenantUuid(bwmSaasConfiguration.getMeta().getTenantUuid());
        callbackMessage.setTaskUuid(bwmSaasConfiguration.getMeta().getTaskUuid());
        callbackMessage.setInstanceChainUuid(bwmSaasConfiguration.getMeta().getInstanceChainUuid());
        callbackMessage.setInstanceUuid(bwmSaasConfiguration.getMeta().getInstanceUuid());
        callbackMessage.setMetaVersion(bwmSaasConfiguration.getMeta().getMetaVersion());
        callbackMessage.setScheduleDatasourceUuid(bwmSaasConfiguration.getMeta().getScheduleDatasourceUuid());
        callbackMessage.setInputMetaVersion(bwmSaasConfiguration.getMeta().getInputMetaVersion());
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            callbackMessage.setIsSuccess(Boolean.valueOf(false));
            callbackMessage.setErrorMsg(errorMsg);
        } else {
            callbackMessage.setIsSuccess(Boolean.valueOf(true));
            callbackMessage.setErrorMsg(null);
        }
        callbackMessage.setMsgTime(callbackMessage.ofBizDate());
        callbackMessage.setStageType(bwmSaasConfiguration.getStageType().name());
        callbackMessage.setUid(UuidUtils.randomUuid());
        mnsClient.sendMessage(callbackMessage);
        mnsClient.close();
    }

    @Override
    public void getPlugin(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execLocal(TaskContext taskContext) throws Exception {
    }

    @Override
    public void execSaas(TaskContext taskContext) throws Exception {
    }

    @Override
    public void closePlugin() {
    }

    @Override
    public void addOption() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "bwmclient";
    }

    @Override
    public String desc() {
        return "\u8c03\u5ea6\u8fc1\u79fb\u5ba2\u6237\u7aef\u5de5\u5177";
    }
}

