/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils.tpslimit;

import com.alibaba.securitysdk.logging.utils.AssertUtil;
import com.alibaba.securitysdk.logging.utils.tpslimit.FixedIntervalRefillTokenBucket;
import com.alibaba.securitysdk.logging.utils.tpslimit.TokenBucket;
import java.util.concurrent.TimeUnit;

public final class TokenBuckets {
    private TokenBuckets() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long capacity = null;
        private long initialTokens = 0L;
        private long refillTokens = 10L;
        private long periodInNanos;

        public Builder withCapacity(long numTokens) {
            AssertUtil.checkArgument(numTokens > 0L, "Must specify a positive number of tokens");
            this.capacity = numTokens;
            return this;
        }

        public Builder withInitialTokens(long numTokens) {
            AssertUtil.checkArgument(numTokens > 0L, "Must specify a positive number of tokens");
            this.initialTokens = numTokens;
            return this;
        }

        public Builder withFixedIntervalRefillStrategy(long refillTokens, long period, TimeUnit unit) {
            AssertUtil.checkArgument(refillTokens > 0L, "Must specify a positive number of tokens");
            AssertUtil.checkArgument(period > 0L, "Must specify a positive number of period");
            this.refillTokens = refillTokens;
            this.periodInNanos = unit.toNanos(period);
            return this;
        }

        public TokenBucket build() {
            AssertUtil.notNull(this.capacity, "Must specify a capacity");
            AssertUtil.notNull(this.refillTokens, "Must specify a refill token");
            return new FixedIntervalRefillTokenBucket(this.capacity, this.initialTokens, this.refillTokens, this.periodInNanos);
        }
    }
}

