/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils.tpslimit;

import com.alibaba.securitysdk.logging.utils.AssertUtil;
import com.alibaba.securitysdk.logging.utils.tpslimit.TokenBucket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class FixedIntervalRefillTokenBucket
implements TokenBucket {
    private final long capacity;
    private final long numTokensPerPeriod;
    private final long periodDurationInNanos;
    private AtomicLong currentTokens;
    private long lastRefillTime;
    private AtomicLong nextRefillTime;

    FixedIntervalRefillTokenBucket(long capacity, long initialTokens, long refillTokens, long periodDurationInNanos) {
        AssertUtil.checkArgument(capacity > 0L);
        AssertUtil.checkArgument(initialTokens <= capacity);
        this.capacity = capacity;
        this.currentTokens = new AtomicLong(initialTokens);
        this.numTokensPerPeriod = refillTokens;
        this.periodDurationInNanos = periodDurationInNanos;
        this.lastRefillTime = System.nanoTime() + periodDurationInNanos;
        this.nextRefillTime = new AtomicLong(System.nanoTime() + periodDurationInNanos);
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getCurrentTokens() {
        this.refill(this.refill());
        return this.currentTokens.get();
    }

    @Override
    public long getDurationUntilNextRefill(TimeUnit unit) throws UnsupportedOperationException {
        return unit.convert(Math.max(0L, this.nextRefillTime.get() - System.nanoTime()), TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean tryConsume() {
        return this.tryConsume(1L);
    }

    @Override
    public boolean tryConsume(long numTokens) {
        AssertUtil.checkArgument(numTokens > 0L, "Number of tokens to consume must be positive");
        AssertUtil.checkArgument(numTokens <= this.capacity, "Number of tokens to consume must be less than the capacity of the bucket.");
        this.refill(this.refill());
        return this.casDecreases(this.currentTokens, numTokens);
    }

    private boolean casDecreases(AtomicLong al, long needToken) {
        long current;
        do {
            if (needToken <= (current = al.get())) continue;
            return false;
        } while (!al.compareAndSet(current, current - needToken));
        return true;
    }

    @Override
    public void refill(long numTokens) {
        long max;
        long current;
        long newTokens = Math.min(this.capacity, Math.max(0L, numTokens));
        while (!this.currentTokens.compareAndSet(current = this.currentTokens.get(), max = Math.max(0L, Math.min(current + newTokens, this.capacity)))) {
        }
    }

    private long refill() {
        long numPeriods;
        long current;
        long now = System.nanoTime();
        do {
            if (now < (current = this.nextRefillTime.get())) {
                return 0L;
            }
            numPeriods = Math.max(0L, (now - this.lastRefillTime) / this.periodDurationInNanos);
            this.lastRefillTime += numPeriods * this.periodDurationInNanos;
        } while (!this.nextRefillTime.compareAndSet(current, this.lastRefillTime + this.periodDurationInNanos));
        return numPeriods * this.numTokensPerPeriod;
    }
}

