/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils.filewatch;

import com.alibaba.securitysdk.logging.utils.filewatch.FileWatchEventListener;
import com.alibaba.securitysdk.logging.utils.filewatch.FileWatchExistsException;
import com.alibaba.securitysdk.logging.utils.filewatch.FileWatcher;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum FileWatcherManager {
    INSTANCE;

    private Map<Path, List<FileWatchEventListener>> fileWatchEventListenerMap = new ConcurrentHashMap<Path, List<FileWatchEventListener>>();
    private Map<Path, FileWatcher> fileWatcherMap = new ConcurrentHashMap<Path, FileWatcher>();

    public FileWatcher createFileWatcher(Path root, FileWatchEventListener ... listeners) throws IOException, FileWatchExistsException {
        if (this.fileWatcherMap.containsKey(root)) {
            throw new FileWatchExistsException(root);
        }
        FileWatcher fileWatcher = new FileWatcher(root);
        return this.addFileWatcher(fileWatcher, root, listeners);
    }

    public FileWatcher createFileWatcher(Path root, boolean recursive, FileWatchEventListener ... listeners) throws IOException, FileWatchExistsException {
        if (this.fileWatcherMap.containsKey(root)) {
            throw new FileWatchExistsException(root);
        }
        FileWatcher fileWatcher = new FileWatcher(root, recursive);
        return this.addFileWatcher(fileWatcher, root, listeners);
    }

    private FileWatcher addFileWatcher(FileWatcher fileWatcher, Path root, FileWatchEventListener ... listeners) {
        List<FileWatchEventListener> fileWatchEventListeners = Arrays.asList(listeners);
        fileWatcher.registerListeners(fileWatchEventListeners);
        this.fileWatchEventListenerMap.put(root, fileWatchEventListeners);
        this.fileWatcherMap.put(root, fileWatcher);
        return fileWatcher;
    }

    public FileWatcher getFileWatcher(Path root) {
        if (this.fileWatcherMap.containsKey(root)) {
            return this.fileWatcherMap.get(root);
        }
        return null;
    }

    public Set<Path> getWatchingPaths() {
        return this.fileWatchEventListenerMap.keySet();
    }

    public Collection<FileWatcher> getFileWathchers() {
        return this.fileWatcherMap.values();
    }

    public List<FileWatcher> listRunningFileWathchers() {
        ArrayList<FileWatcher> runningFileWatchers = new ArrayList<FileWatcher>();
        for (FileWatcher fileWatcher : this.getFileWathchers()) {
            if (!fileWatcher.isStarted()) continue;
            runningFileWatchers.add(fileWatcher);
        }
        return runningFileWatchers;
    }

    public boolean isWatcherAlive(FileWatcher fileWatcher) {
        return fileWatcher.isStarted();
    }
}

