/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils;

import com.alibaba.securitysdk.logging.utils.StringUtils;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class OsUtils {
    private static final String USER_HOME = OsUtils.locateUserHome();
    private static String OS = System.getProperty("os.name").toLowerCase();
    public static final boolean IS_OS_UNIX = OsUtils.innerIsUnix();
    public static final boolean IS_OS_WINDOWS = OsUtils.innerIsWindows();
    public static final boolean IS_OS_MAX = OsUtils.innerIsMac();

    private OsUtils() {
    }

    private static boolean innerIsUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    private static boolean innerIsMac() {
        return OS.contains("mac os");
    }

    private static boolean innerIsWindows() {
        return OS.startsWith("Windows");
    }

    private static String locateUserHome() {
        String userHome = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("user.home");
            }
        }).toString();
        if (StringUtils.isNotBlank(userHome)) {
            if (!userHome.endsWith(File.separator)) {
                userHome = userHome + File.separator;
            }
        } else {
            userHome = "/tmp/";
        }
        return userHome;
    }

    public static boolean isUnix() {
        return IS_OS_UNIX;
    }

    public static boolean isMacOS() {
        return IS_OS_MAX;
    }

    public static boolean isWindows() {
        return IS_OS_WINDOWS;
    }

    public static String getUserHome() {
        return USER_HOME;
    }
}

