/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractCopyOnWriteMap<K, V>
implements Map<K, V> {
    protected volatile Map<K, V> core;
    private volatile Map<K, V> view;
    final transient ReentrantLock lock = new ReentrantLock();

    protected AbstractCopyOnWriteMap(Map<K, V> core) {
        this.update(core);
    }

    protected AbstractCopyOnWriteMap() {
        this.update(Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Map<K, V> m) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.core = m;
            this.view = Collections.unmodifiableMap(this.core);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBy(Map<? extends K, ? extends V> data) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Map<? extends K, ? extends V> d = this.copy();
            d.clear();
            d.putAll(data);
            this.update(d);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Map<K, V> m = this.copy();
            V r = m.put(key, value);
            this.update(m);
            V v = r;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Map<K, V> m = this.copy();
            V r = m.remove(key);
            this.update(m);
            V v = r;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Map<? extends K, ? extends V> m = this.copy();
            m.putAll(t);
            this.update(m);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.core.size();
    }

    @Override
    public boolean isEmpty() {
        return this.core.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.core.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.core.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.core.get(key);
    }

    protected abstract Map<K, V> newMap();

    protected abstract Map<K, V> copy();

    @Override
    public void clear() {
        this.update(Collections.emptyMap());
    }

    @Override
    public Set<K> keySet() {
        return this.view.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.view.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.view.entrySet();
    }

    @Override
    public int hashCode() {
        return this.copy().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.copy().equals(obj);
    }

    public String toString() {
        return this.copy().toString();
    }
}

