/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.security.shade.org.apache.logging.log4j.core.util;

import com.aliyun.security.shade.org.apache.logging.log4j.core.time.PreciseClock;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.CachedClock;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.Clock;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.CoarseCachedClock;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.Loader;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.SystemClock;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.SystemMillisClock;
import com.aliyun.security.shade.org.apache.logging.log4j.status.StatusLogger;
import com.aliyun.security.shade.org.apache.logging.log4j.util.PropertiesUtil;
import com.aliyun.security.shade.org.apache.logging.log4j.util.Supplier;
import java.util.HashMap;
import java.util.Map;

public final class ClockFactory {
    public static final String PROPERTY_NAME = "com.aliyun.security.log4j.Clock";
    private static final StatusLogger LOGGER = StatusLogger.getLogger();

    private ClockFactory() {
    }

    public static Clock getClock() {
        return ClockFactory.createClock();
    }

    private static Map<String, Supplier<Clock>> aliases() {
        HashMap<String, Supplier<Clock>> result = new HashMap<String, Supplier<Clock>>();
        result.put("SystemClock", new Supplier<Clock>(){

            @Override
            public Clock get() {
                return new SystemClock();
            }
        });
        result.put("SystemMillisClock", new Supplier<Clock>(){

            @Override
            public Clock get() {
                return new SystemMillisClock();
            }
        });
        result.put("CachedClock", new Supplier<Clock>(){

            @Override
            public Clock get() {
                return CachedClock.instance();
            }
        });
        result.put("CoarseCachedClock", new Supplier<Clock>(){

            @Override
            public Clock get() {
                return CoarseCachedClock.instance();
            }
        });
        result.put("com.aliyun.security.shade.org.apache.logging.log4j.core.util.CachedClock", new Supplier<Clock>(){

            @Override
            public Clock get() {
                return CachedClock.instance();
            }
        });
        result.put("com.aliyun.security.shade.org.apache.logging.log4j.core.util.CoarseCachedClock", new Supplier<Clock>(){

            @Override
            public Clock get() {
                return CoarseCachedClock.instance();
            }
        });
        return result;
    }

    private static Clock createClock() {
        String userRequest = PropertiesUtil.getProperties().getStringProperty(PROPERTY_NAME);
        if (userRequest == null) {
            LOGGER.trace("Using default SystemClock for timestamps.");
            return ClockFactory.logSupportedPrecision(new SystemClock());
        }
        Supplier<Clock> specified = ClockFactory.aliases().get(userRequest);
        if (specified != null) {
            LOGGER.trace("Using specified {} for timestamps.", (Object)userRequest);
            return ClockFactory.logSupportedPrecision(specified.get());
        }
        try {
            Clock result = Loader.newCheckedInstanceOf(userRequest, Clock.class);
            LOGGER.trace("Using {} for timestamps.", (Object)result.getClass().getName());
            return ClockFactory.logSupportedPrecision(result);
        }
        catch (Exception e) {
            String fmt = "Could not create {}: {}, using default SystemClock for timestamps.";
            LOGGER.error("Could not create {}: {}, using default SystemClock for timestamps.", (Object)userRequest, (Object)e);
            return ClockFactory.logSupportedPrecision(new SystemClock());
        }
    }

    private static Clock logSupportedPrecision(Clock clock) {
        String support = clock instanceof PreciseClock ? "supports" : "does not support";
        LOGGER.debug("{} {} precise timestamps.", (Object)clock.getClass().getName(), (Object)support);
        return clock;
    }
}

