/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.security.shade.org.apache.logging.log4j.core.lookup;

import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.security.shade.org.apache.logging.log4j.core.LogEvent;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.ConfigurationAware;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import com.aliyun.security.shade.org.apache.logging.log4j.core.config.plugins.util.PluginType;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.AbstractConfigurationAwareLookup;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.ContextMapLookup;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.DateLookup;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.MainMapLookup;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.MapLookup;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.MarkerLookup;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.StrLookup;
import com.aliyun.security.shade.org.apache.logging.log4j.core.lookup.SystemPropertiesLookup;
import com.aliyun.security.shade.org.apache.logging.log4j.core.util.ReflectionUtil;
import com.aliyun.security.shade.org.apache.logging.log4j.status.StatusLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Interpolator
extends AbstractConfigurationAwareLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    static final char PREFIX_SEPARATOR = ':';
    private final Map<String, StrLookup> strLookupMap = new HashMap<String, StrLookup>();
    private final StrLookup defaultLookup;

    public Interpolator(StrLookup defaultLookup) {
        this(defaultLookup, null);
    }

    public Interpolator(StrLookup defaultLookup, List<String> pluginPackages) {
        this.defaultLookup = defaultLookup == null ? new MapLookup(new HashMap<String, String>()) : defaultLookup;
        PluginManager manager = new PluginManager("Lookup");
        manager.collectPlugins(pluginPackages);
        Map<String, PluginType<?>> plugins = manager.getPlugins();
        for (Map.Entry<String, PluginType<?>> entry : plugins.entrySet()) {
            try {
                Class<StrLookup> clazz = entry.getValue().getPluginClass().asSubclass(StrLookup.class);
                this.strLookupMap.put(entry.getKey().toLowerCase(), ReflectionUtil.instantiate(clazz));
            }
            catch (Throwable t) {
                this.handleError(entry.getKey(), t);
            }
        }
    }

    public Interpolator() {
        this((Map<String, String>)null);
    }

    public Interpolator(Map<String, String> properties) {
        this.defaultLookup = new MapLookup(properties == null ? new HashMap() : properties);
        this.strLookupMap.put("sys", new SystemPropertiesLookup());
        this.strLookupMap.put("main", MainMapLookup.MAIN_SINGLETON);
        this.strLookupMap.put("marker", new MarkerLookup());
        this.strLookupMap.put("date", new DateLookup());
        this.strLookupMap.put("ctx", new ContextMapLookup());
    }

    public Map<String, StrLookup> getStrLookupMap() {
        return this.strLookupMap;
    }

    private void handleError(String lookupKey, Throwable t) {
        switch (lookupKey) {
            default: 
        }
        LOGGER.error("Unable to create Lookup for {}", (Object)lookupKey, (Object)t);
    }

    @Override
    public String lookup(LogEvent event, String var) {
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            String prefix = var.substring(0, prefixPos).toLowerCase(Locale.US);
            String name = var.substring(prefixPos + 1);
            StrLookup lookup = this.strLookupMap.get(prefix);
            if (lookup instanceof ConfigurationAware) {
                ((ConfigurationAware)((Object)lookup)).setConfiguration(this.configuration);
            }
            String value = null;
            if (lookup != null) {
                String string = value = event == null ? lookup.lookup(name) : lookup.lookup(event, name);
            }
            if (value != null) {
                return value;
            }
            var = var.substring(prefixPos + 1);
        }
        if (this.defaultLookup != null) {
            return event == null ? this.defaultLookup.lookup(var) : this.defaultLookup.lookup(event, var);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.strLookupMap.keySet()) {
            if (sb.length() == 0) {
                sb.append('{');
            } else {
                sb.append(", ");
            }
            sb.append(name);
        }
        if (sb.length() > 0) {
            sb.append('}');
        }
        return sb.toString();
    }
}

