/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model.serialize;

import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.model.ErrorMessageResult;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.MessagePropertyValue;
import com.aliyun.mns.model.MessageSystemPropertyName;
import com.aliyun.mns.model.MessageSystemPropertyValue;
import com.aliyun.mns.model.PropertyType;
import com.aliyun.mns.model.SystemPropertyType;
import com.aliyun.mns.model.serialize.BaseXMLSerializer;
import com.aliyun.mns.model.serialize.Deserializer;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLDeserializer<T>
extends BaseXMLSerializer<T>
implements Deserializer<T> {
    protected String safeGetElementContent(Element root, String tagName, String defaultValue) {
        NodeList nodes = root.getElementsByTagName(tagName);
        if (nodes != null) {
            Node node = nodes.item(0);
            if (node == null) {
                return defaultValue;
            }
            return node.getTextContent();
        }
        return defaultValue;
    }

    protected Element safeGetElement(Element root, String tagName) {
        NodeList nodes = root.getElementsByTagName(tagName);
        if (nodes != null) {
            Node node = nodes.item(0);
            if (node == null) {
                return null;
            }
            return (Element)node;
        }
        return null;
    }

    protected List<Element> safeGetElements(Element parent, String tagName) {
        NodeList nodeList = parent.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    protected ErrorMessageResult parseErrorMessageResult(Element root) {
        ErrorMessageResult result = new ErrorMessageResult();
        String errorCode = this.safeGetElementContent(root, "ErrorCode", null);
        result.setErrorCode(errorCode);
        String errorMessage = this.safeGetElementContent(root, "ErrorMessage", null);
        result.setErrorMessage(errorMessage);
        return result;
    }

    protected void safeAddPropertiesToMessage(Element root, Message message) {
        Element userPropertiesElement = this.safeGetElement(root, "UserProperties");
        if (userPropertiesElement != null) {
            Map<String, MessagePropertyValue> userProperties = message.getUserProperties();
            if (userProperties == null) {
                userProperties = new HashMap<String, MessagePropertyValue>();
                message.setUserProperties(userProperties);
            }
            for (Element propertyValueElement : this.safeGetElements(userPropertiesElement, "PropertyValue")) {
                String name = this.safeGetElementContent(propertyValueElement, "Name", null);
                String value = this.safeGetElementContent(propertyValueElement, "Value", null);
                String type = this.safeGetElementContent(propertyValueElement, "Type", null);
                if (name == null || value == null || type == null) continue;
                PropertyType typeEnum = PropertyType.valueOf(type);
                if (typeEnum == PropertyType.BINARY) {
                    try {
                        byte[] decodedBytes = Base64.decodeBase64((String)value);
                        value = new String(decodedBytes, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new ClientException("Not support enconding:UTF-8", null, e);
                    }
                }
                MessagePropertyValue propertyValue = new MessagePropertyValue(PropertyType.valueOf(type), value);
                userProperties.put(name, propertyValue);
            }
        }
    }

    protected void safeAddSystemPropertiesToMessage(Element root, Message message) {
        Element systemPropertiesElement = this.safeGetElement(root, "SystemProperties");
        if (systemPropertiesElement != null) {
            for (Element propertyValueElement : this.safeGetElements(systemPropertiesElement, "SystemPropertyValue")) {
                String name = this.safeGetElementContent(propertyValueElement, "Name", null);
                String value = this.safeGetElementContent(propertyValueElement, "Value", null);
                String type = this.safeGetElementContent(propertyValueElement, "Type", null);
                if (name == null || value == null || type == null) continue;
                SystemPropertyType systemPropertyType = SystemPropertyType.valueOf(type);
                MessageSystemPropertyValue propertyValue = new MessageSystemPropertyValue(systemPropertyType, value);
                MessageSystemPropertyName propertyName = MessageSystemPropertyName.getByValue(name);
                message.putSystemProperty(propertyName, propertyValue);
            }
        }
    }
}

