/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model;

import com.aliyun.mns.model.MessagePropertyValue;
import com.aliyun.mns.model.MessageSystemPropertyName;
import com.aliyun.mns.model.MessageSystemPropertyValue;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseMessage {
    private String requestId = null;
    private String messageId = null;
    private String messageBodyMD5 = null;
    private byte[] messageBodyBytes = null;
    private Map<String, MessagePropertyValue> userProperties = new ConcurrentHashMap<String, MessagePropertyValue>();
    private Map<String, MessageSystemPropertyValue> systemProperties = new ConcurrentHashMap<String, MessageSystemPropertyValue>();

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageBodyMD5() {
        return this.messageBodyMD5;
    }

    public void setMessageBodyMD5(String messageBodyMD5) {
        this.messageBodyMD5 = messageBodyMD5;
    }

    protected byte[] getMessageBodyBytes() {
        return this.messageBodyBytes;
    }

    protected void setMessageBodyBytes(byte[] messageBodyBytes) {
        this.messageBodyBytes = messageBodyBytes;
    }

    public void setBaseMessageBody(byte[] messageBody) {
        this.setMessageBodyBytes(messageBody);
    }

    public void setBaseMessageBody(String messageBody) {
        this.setMessageBodyBytes(messageBody.getBytes(Charset.forName("utf-8")));
    }

    public String getOriginalMessageBody() {
        byte[] messageBodyAsBytes = this.getMessageBodyBytes();
        if (messageBodyAsBytes == null) {
            return null;
        }
        try {
            return new String(messageBodyAsBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding: UTF-8");
        }
    }

    public abstract String getMessageBody();

    public abstract void setMessageBody(String var1);

    public abstract void setMessageBody(byte[] var1);

    public Map<String, MessagePropertyValue> getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Map<String, MessagePropertyValue> userProperties) {
        this.userProperties = userProperties;
    }

    public MessageSystemPropertyValue getSystemProperty(MessageSystemPropertyName key) {
        if (key == null) {
            return null;
        }
        return this.systemProperties.get(key.getValue());
    }

    public void putSystemProperty(MessageSystemPropertyName keyName, MessageSystemPropertyValue value) {
        this.systemProperties.put(keyName.getValue(), value);
    }

    public Map<String, MessageSystemPropertyValue> getSystemProperties() {
        return this.systemProperties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.messageId != null) {
            sb.append("MessageID:").append(this.messageId).append(",");
        }
        if (this.messageBodyMD5 != null) {
            sb.append("MessageMD5:").append(this.messageBodyMD5).append(",");
        }
        if (this.requestId != null) {
            sb.append("RequestID:").append(this.requestId).append(",");
        }
        if (this.userProperties != null) {
            for (Map.Entry<String, MessagePropertyValue> entry : this.userProperties.entrySet()) {
                sb.append("Property.").append(entry.getKey()).append(":").append(entry.getValue()).append(",");
            }
        }
        return sb.toString();
    }
}

