/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.client.impl.topic;

import com.aliyun.mns.client.impl.AbstractAction;
import com.aliyun.mns.common.HttpMethod;
import com.aliyun.mns.common.auth.ServiceCredentials;
import com.aliyun.mns.common.http.RequestMessage;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.http.ServiceClient;
import com.aliyun.mns.common.parser.ResultParseException;
import com.aliyun.mns.common.parser.ResultParser;
import com.aliyun.mns.model.PagingListResult;
import com.aliyun.mns.model.TopicMeta;
import com.aliyun.mns.model.request.topic.ListTopicRequest;
import com.aliyun.mns.model.serialize.topic.TopicArraryDeserializer;
import java.net.URI;

public class ListTopicAction
extends AbstractAction<ListTopicRequest, PagingListResult<TopicMeta>> {
    public ListTopicAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.GET, "ListTopic", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(ListTopicRequest reqObject) {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setResourcePath(reqObject.getRequestPath());
        if (reqObject.getPrefix() != null && !"".equals(reqObject.getPrefix())) {
            requestMessage.addHeader("x-mns-prefix", reqObject.getPrefix());
        }
        if (reqObject.getMarker() != null && !"".equals(reqObject.getMarker())) {
            requestMessage.addHeader("x-mns-marker", reqObject.getMarker());
        }
        if (reqObject.getMaxRet() != null) {
            requestMessage.addHeader("x-mns-ret-number", reqObject.getMaxRet().toString());
        }
        if (reqObject.getWithMeta() != null) {
            requestMessage.addHeader("x-mns-with-meta", reqObject.getWithMeta().toString());
        }
        return requestMessage;
    }

    @Override
    protected ResultParser<PagingListResult<TopicMeta>> buildResultParser() {
        return new ResultParser<PagingListResult<TopicMeta>>(){

            @Override
            public PagingListResult<TopicMeta> parse(ResponseMessage response) throws ResultParseException {
                TopicArraryDeserializer deserializer = new TopicArraryDeserializer();
                try {
                    return deserializer.deserialize(response.getContent());
                }
                catch (Exception e) {
                    AbstractAction.logger.warn("Unmarshal error,cause by:" + e.getMessage());
                    throw new ResultParseException("Unmarshal error,cause by:" + e.getMessage(), e);
                }
            }
        };
    }
}

