/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.statistics;

import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.constant.PackageDiffConstant;
import com.aliyun.migration.spec.domain.dataworks.CycleWorkflowSingleSpec;
import com.aliyun.migration.spec.domain.dataworks.WorkflowMainSpec;
import com.aliyun.migration.spec.domain.dataworks.node.DataWorksNodeTypeUtils;
import com.aliyun.migration.spec.domain.dataworks.node.NodeSingleSpec;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.dw.merge.diff.PackageDiffCompareTool;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffElement;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffCommonTools;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.script.ScriptDiffElement;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.script.ScriptDiffTool;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.statistics.StatisticsChangeMetric;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.statistics.StatisticsMainMetric;
import com.aliyun.migration.workflow.migration.dw.migration.supervisor.common.statistics.StatisticsOverviewMetric;
import com.aliyun.migration.workflow.migration.dw.newide.converter.workflow.WorkflowConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticsTool {
    private WorkflowProjectPackage orgPackage;
    private Map<String, Workflow> orgWorkflowIdMap;
    private Map<String, WorkflowNode> orgWorkflowNodeIdMap;
    private Map<String, RelationPackage> orgRelationMap;
    private WorkflowProjectPackage lhmFinalPackage;
    private Map<String, Workflow> lhmFinalWorkflowIdMap;
    private Map<String, WorkflowNode> lhmFinalWorkflowNodeIdMap;
    private Map<String, RelationPackage> lhmFinalRelationMap;
    private WorkflowProjectPackage migrationFinalPackage;
    private Map<String, Workflow> migrationFinalWorkflowIdMap;
    private Map<String, WorkflowNode> migrationFinalWorkflowNodeIdMap;
    private Map<String, RelationPackage> migrationFinalRelationMap;
    private StatisticsMainMetric result;

    public void init(WorkflowProjectPackage orgPackage, WorkflowProjectPackage lhmFinalPackage, WorkflowProjectPackage migrationFinalPackage) {
        this.orgPackage = orgPackage;
        this.lhmFinalPackage = lhmFinalPackage;
        this.migrationFinalPackage = migrationFinalPackage;
        this.orgWorkflowIdMap = new HashMap<String, Workflow>();
        this.orgWorkflowNodeIdMap = new HashMap<String, WorkflowNode>();
        this.orgRelationMap = new HashMap<String, RelationPackage>();
        PackageDiffCommonTools.buildMap((WorkflowProjectPackage)orgPackage, this.orgWorkflowIdMap, this.orgWorkflowNodeIdMap, this.orgRelationMap);
        this.lhmFinalWorkflowIdMap = new HashMap<String, Workflow>();
        this.lhmFinalWorkflowNodeIdMap = new HashMap<String, WorkflowNode>();
        this.lhmFinalRelationMap = new HashMap<String, RelationPackage>();
        PackageDiffCommonTools.buildMap((WorkflowProjectPackage)lhmFinalPackage, this.lhmFinalWorkflowIdMap, this.lhmFinalWorkflowNodeIdMap, this.lhmFinalRelationMap);
        this.migrationFinalWorkflowIdMap = new HashMap<String, Workflow>();
        this.migrationFinalWorkflowNodeIdMap = new HashMap<String, WorkflowNode>();
        this.migrationFinalRelationMap = new HashMap<String, RelationPackage>();
        PackageDiffCommonTools.buildMap((WorkflowProjectPackage)migrationFinalPackage, this.migrationFinalWorkflowIdMap, this.migrationFinalWorkflowNodeIdMap, this.migrationFinalRelationMap);
    }

    public StatisticsMainMetric makeStatistics() {
        StatisticsOverviewMetric overview = this.calculateOverview();
        StatisticsChangeMetric overviewAcceptRate = this.calculateOverviewAcceptRate();
        StatisticsChangeMetric nodeAcceptRate = this.calculateNodeAcceptRate();
        StatisticsChangeMetric relationAcceptRate = this.calculateRelationAcceptRate();
        Map<String, StatisticsChangeMetric> propertyAcceptRate = this.calculatePropertyAcceptRate();
        Map<String, StatisticsChangeMetric> nodeScriptAcceptRate = this.calculateScriptAcceptRate();
        this.result = StatisticsMainMetric.builder().overview(overview).overviewAcceptRate(overviewAcceptRate).nodeAcceptRate(nodeAcceptRate).relationAcceptRate(relationAcceptRate).propertyAcceptRate(propertyAcceptRate).nodeScriptAcceptRate(nodeScriptAcceptRate).build();
        return this.result;
    }

    public StatisticsMainMetric getResult() {
        return this.result;
    }

    private StatisticsOverviewMetric calculateOverview() {
        HashMap<String, Integer> orgNodeTypeMap = new HashMap<String, Integer>();
        for (String string : this.orgWorkflowNodeIdMap.keySet()) {
            orgNodeTypeMap.put(this.orgWorkflowNodeIdMap.get(string).getNodeType(), orgNodeTypeMap.getOrDefault(this.orgWorkflowNodeIdMap.get(string).getNodeType(), 0) + 1);
        }
        HashMap<String, Integer> lhmFinalNodeTypeMap = new HashMap<String, Integer>();
        for (String workflowNodeId : this.lhmFinalWorkflowNodeIdMap.keySet()) {
            lhmFinalNodeTypeMap.put(this.lhmFinalWorkflowNodeIdMap.get(workflowNodeId).getNodeType(), lhmFinalNodeTypeMap.getOrDefault(this.lhmFinalWorkflowNodeIdMap.get(workflowNodeId).getNodeType(), 0) + 1);
        }
        StatisticsOverviewMetric statisticsOverviewMetric = StatisticsOverviewMetric.builder().srcWorkflowNodeTotalCount(this.orgWorkflowNodeIdMap.size()).tgtWorkflowNodeTotalCount(this.lhmFinalWorkflowNodeIdMap.size()).srcWorkflowTotalCount(this.orgWorkflowIdMap.size()).tgtWorkflowTotalCount(this.lhmFinalWorkflowIdMap.size()).srcWorkflowRelationTotalCount(this.orgRelationMap.size()).tgtWorkflowRelationTotalCount(this.lhmFinalRelationMap.size()).srcNodeTypeCount(orgNodeTypeMap).tgtNodeTypeCount(lhmFinalNodeTypeMap).build();
        statisticsOverviewMetric.setSrcWorkflowTotalCount(this.lhmFinalPackage.getWorkflowList().size());
        statisticsOverviewMetric.setTgtWorkflowTotalCount(this.migrationFinalPackage.getWorkflowList().size());
        return statisticsOverviewMetric;
    }

    private StatisticsChangeMetric calculateOverviewAcceptRate() {
        HashMap<String, String> lhmWorkflowSpecMap = new HashMap<String, String>();
        HashMap<String, Map<String, String>> lhmWorkflowNodeSpecMap = new HashMap<String, Map<String, String>>();
        this.getDataWorksSpec(lhmWorkflowSpecMap, lhmWorkflowNodeSpecMap, this.lhmFinalPackage);
        HashMap<String, String> migrationWorkflowSpecMap = new HashMap<String, String>();
        HashMap<String, Map<String, String>> migrationWorkflowNodeSpecMap = new HashMap<String, Map<String, String>>();
        this.getDataWorksSpec(migrationWorkflowSpecMap, migrationWorkflowNodeSpecMap, this.migrationFinalPackage);
        ScriptDiffTool scriptDiffTool = new ScriptDiffTool();
        ScriptDiffElement scriptDiffElement = ScriptDiffElement.builder().rawLineCount(0).addLineCount(0).deleteLintCount(0).build();
        for (String workflowId : lhmWorkflowSpecMap.keySet()) {
            if (!migrationWorkflowSpecMap.containsKey(workflowId)) {
                scriptDiffElement.add(scriptDiffTool.diffCount((String)lhmWorkflowSpecMap.get(workflowId), ""));
                for (String nodeId : ((Map)lhmWorkflowNodeSpecMap.get(workflowId)).keySet()) {
                    scriptDiffElement.add(scriptDiffTool.diffCount((String)((Map)lhmWorkflowNodeSpecMap.get(workflowId)).get(nodeId), ""));
                }
                continue;
            }
            scriptDiffElement.add(scriptDiffTool.diffCount((String)lhmWorkflowSpecMap.get(workflowId), (String)migrationWorkflowSpecMap.get(workflowId)));
            for (String nodeId : ((Map)lhmWorkflowNodeSpecMap.get(workflowId)).keySet()) {
                if (!((Map)migrationWorkflowNodeSpecMap.get(workflowId)).containsKey(nodeId)) {
                    scriptDiffElement.add(scriptDiffTool.diffCount((String)((Map)lhmWorkflowNodeSpecMap.get(workflowId)).get(nodeId), ""));
                    continue;
                }
                scriptDiffElement.add(scriptDiffTool.diffCount((String)((Map)lhmWorkflowNodeSpecMap.get(workflowId)).get(nodeId), (String)((Map)migrationWorkflowNodeSpecMap.get(workflowId)).get(nodeId)));
            }
            for (String nodeId : ((Map)migrationWorkflowNodeSpecMap.get(workflowId)).keySet()) {
                if (((Map)lhmWorkflowNodeSpecMap.get(workflowId)).containsKey(nodeId)) continue;
                scriptDiffElement.add(scriptDiffTool.diffCount("", (String)((Map)migrationWorkflowNodeSpecMap.get(workflowId)).get(nodeId)));
            }
        }
        StatisticsChangeMetric statisticsChangeMetric = new StatisticsChangeMetric();
        statisticsChangeMetric.setRawTotalCount(scriptDiffElement.getRawLineCount());
        statisticsChangeMetric.setAddCount(scriptDiffElement.getAddLineCount());
        statisticsChangeMetric.setDeleteCount(scriptDiffElement.getDeleteLintCount());
        statisticsChangeMetric.calculateRate();
        return statisticsChangeMetric;
    }

    public void getDataWorksSpec(Map<String, String> workflowSpecMap, Map<String, Map<String, String>> workflowNodeSpecMap, WorkflowProjectPackage workflowProjectPackage) {
        WorkflowConverter converter = new WorkflowConverter(workflowProjectPackage, null, new DataWorksNodeTypeUtils());
        for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
            WorkflowMainSpec workflowSingleSpec = converter.convertWorkflow(workflow, null);
            ((CycleWorkflowSingleSpec)workflowSingleSpec.getSpec().getWorkflows().get(0)).setNodes(new ArrayList());
            workflowSpecMap.put(workflow.getWorkflowId(), WorkflowMainSpec.getWorkflowMainSpecJson((WorkflowMainSpec)workflowSingleSpec).toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat}));
            workflowNodeSpecMap.put(workflow.getWorkflowId(), new HashMap());
            for (WorkflowNode workflowNode : workflow.getWorkflowNodes()) {
                NodeSingleSpec nodeSingleSpec = converter.convertSingleNode(workflowNode, null);
                workflowNodeSpecMap.get(workflow.getWorkflowId()).put(workflowNode.getNodeId(), NodeSingleSpec.getNodeSingleSpecJson((NodeSingleSpec)nodeSingleSpec).toJSONString(new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat}));
            }
        }
    }

    private StatisticsChangeMetric calculateNodeAcceptRate() {
        Integer n;
        Integer reserveCount = 0;
        Integer deleteCount = 0;
        Integer addCount = 0;
        for (String workflowNodeId : this.lhmFinalWorkflowNodeIdMap.keySet()) {
            if (this.migrationFinalWorkflowNodeIdMap.containsKey(workflowNodeId)) {
                n = reserveCount;
                reserveCount = reserveCount + 1;
                continue;
            }
            n = deleteCount;
            deleteCount = deleteCount + 1;
        }
        for (String workflowNodeId : this.migrationFinalWorkflowNodeIdMap.keySet()) {
            if (this.lhmFinalWorkflowNodeIdMap.containsKey(workflowNodeId) || !this.lhmFinalWorkflowIdMap.containsKey(this.migrationFinalWorkflowNodeIdMap.get(workflowNodeId).getWorkflowId())) continue;
            n = addCount;
            addCount = addCount + 1;
        }
        StatisticsChangeMetric statisticsChangeMetric = new StatisticsChangeMetric();
        statisticsChangeMetric.setRawTotalCount(reserveCount + deleteCount);
        statisticsChangeMetric.setDeleteCount(deleteCount);
        statisticsChangeMetric.setAddCount(addCount);
        statisticsChangeMetric.calculateRate();
        return statisticsChangeMetric;
    }

    private StatisticsChangeMetric calculateRelationAcceptRate() {
        Integer reserveCount = 0;
        Integer deleteCount = 0;
        Integer addCount = 0;
        for (String relation : this.lhmFinalRelationMap.keySet()) {
            Integer n;
            if (this.migrationFinalRelationMap.containsKey(relation)) {
                n = reserveCount;
                reserveCount = reserveCount + 1;
                continue;
            }
            n = deleteCount;
            deleteCount = deleteCount + 1;
        }
        for (String relation : this.migrationFinalRelationMap.keySet()) {
            RelationPackage relationPackage;
            if (this.lhmFinalRelationMap.containsKey(relation) || !(this.migrationFinalWorkflowNodeIdMap.containsKey((relationPackage = this.migrationFinalRelationMap.get(relation)).getFrom()) && this.lhmFinalWorkflowIdMap.containsKey(this.migrationFinalWorkflowNodeIdMap.get(relationPackage.getFrom()).getWorkflowId()) || this.migrationFinalWorkflowNodeIdMap.containsKey(relationPackage.getTo()) && this.lhmFinalWorkflowIdMap.containsKey(this.migrationFinalWorkflowNodeIdMap.get(relationPackage.getTo()).getWorkflowId()) || this.migrationFinalWorkflowIdMap.containsKey(relationPackage.getFrom()) && this.lhmFinalWorkflowIdMap.containsKey(relationPackage.getFrom())) && (!this.migrationFinalWorkflowIdMap.containsKey(relationPackage.getTo()) || !this.lhmFinalWorkflowIdMap.containsKey(relationPackage.getTo()))) continue;
            Integer n = addCount;
            addCount = addCount + 1;
        }
        StatisticsChangeMetric statisticsChangeMetric = new StatisticsChangeMetric();
        statisticsChangeMetric.setRawTotalCount(reserveCount + deleteCount);
        statisticsChangeMetric.setDeleteCount(deleteCount);
        statisticsChangeMetric.setAddCount(addCount);
        statisticsChangeMetric.calculateRate();
        return statisticsChangeMetric;
    }

    private Map<String, StatisticsChangeMetric> calculateScriptAcceptRate() {
        ScriptDiffElement scriptDiffElement;
        ScriptDiffTool scriptDiffTool = new ScriptDiffTool();
        HashMap<String, ScriptDiffElement> scriptDiffElementMap = new HashMap<String, ScriptDiffElement>();
        for (String workflowNodeId : this.lhmFinalWorkflowNodeIdMap.keySet()) {
            if (!scriptDiffElementMap.containsKey(this.lhmFinalWorkflowNodeIdMap.get(workflowNodeId).getNodeType())) {
                scriptDiffElementMap.put(this.lhmFinalWorkflowNodeIdMap.get(workflowNodeId).getNodeType(), ScriptDiffElement.builder().rawLineCount(0).addLineCount(0).deleteLintCount(0).build());
            }
            scriptDiffElement = (ScriptDiffElement)scriptDiffElementMap.get(this.lhmFinalWorkflowNodeIdMap.get(workflowNodeId).getNodeType());
            if (this.migrationFinalWorkflowNodeIdMap.containsKey(workflowNodeId)) {
                scriptDiffElement.add(scriptDiffTool.diffCount(this.lhmFinalWorkflowNodeIdMap.get(workflowNodeId).getScript(), this.migrationFinalWorkflowNodeIdMap.get(workflowNodeId).getScript()));
                continue;
            }
            scriptDiffElement.add(scriptDiffTool.diffCount(this.lhmFinalWorkflowNodeIdMap.get(workflowNodeId).getScript(), ""));
        }
        for (String workflowNodeId : this.migrationFinalWorkflowNodeIdMap.keySet()) {
            if (!scriptDiffElementMap.containsKey(this.migrationFinalWorkflowNodeIdMap.get(workflowNodeId).getNodeType())) {
                scriptDiffElementMap.put(this.migrationFinalWorkflowNodeIdMap.get(workflowNodeId).getNodeType(), ScriptDiffElement.builder().rawLineCount(0).addLineCount(0).deleteLintCount(0).build());
            }
            scriptDiffElement = (ScriptDiffElement)scriptDiffElementMap.get(this.migrationFinalWorkflowNodeIdMap.get(workflowNodeId).getNodeType());
            if (this.lhmFinalWorkflowNodeIdMap.containsKey(workflowNodeId) || !this.lhmFinalWorkflowIdMap.containsKey(this.migrationFinalWorkflowNodeIdMap.get(workflowNodeId).getWorkflowId())) continue;
            scriptDiffElement.add(scriptDiffTool.diffCount("", this.migrationFinalWorkflowNodeIdMap.get(workflowNodeId).getScript()));
        }
        HashMap<String, StatisticsChangeMetric> nodeScriptAcceptRateMap = new HashMap<String, StatisticsChangeMetric>();
        for (String nodeType : scriptDiffElementMap.keySet()) {
            ScriptDiffElement scriptDiffElement2 = (ScriptDiffElement)scriptDiffElementMap.get(nodeType);
            StatisticsChangeMetric statisticsChangeMetric = new StatisticsChangeMetric();
            statisticsChangeMetric.setRawTotalCount(scriptDiffElement2.getRawLineCount());
            statisticsChangeMetric.setDeleteCount(scriptDiffElement2.getDeleteLintCount());
            statisticsChangeMetric.setAddCount(scriptDiffElement2.getAddLineCount());
            statisticsChangeMetric.calculateRate();
            nodeScriptAcceptRateMap.put(nodeType, statisticsChangeMetric);
        }
        return nodeScriptAcceptRateMap;
    }

    private Map<String, StatisticsChangeMetric> calculatePropertyAcceptRate() {
        HashMap<String, StatisticsChangeMetric> propertyAcceptRateMap = new HashMap<String, StatisticsChangeMetric>();
        PackageDiffCompareTool packageDiffCompareTool = new PackageDiffCompareTool();
        List diffElementList = packageDiffCompareTool.compare(this.lhmFinalPackage, this.migrationFinalPackage, PackageDiffConstant.SourceOrTarget.TARGET);
        Arrays.stream(PackageDiffConstant.WorkflowPropertyType.values()).forEach(workflowPropertyType -> {
            StatisticsChangeMetric statisticsChangeMetric = new StatisticsChangeMetric();
            statisticsChangeMetric.setRawTotalCount(this.lhmFinalWorkflowIdMap.size());
            statisticsChangeMetric.setChangeCount(0);
            statisticsChangeMetric.setMissCount(0);
            propertyAcceptRateMap.put(PackageDiffConstant.ElementType.WORKFLOW.name() + "_" + workflowPropertyType.getDescription(), statisticsChangeMetric);
        });
        Arrays.stream(PackageDiffConstant.WorkflowNodePropertyType.values()).forEach(workflowNodePropertyType -> {
            StatisticsChangeMetric statisticsChangeMetric = new StatisticsChangeMetric();
            statisticsChangeMetric.setRawTotalCount(this.lhmFinalWorkflowNodeIdMap.size());
            statisticsChangeMetric.setChangeCount(0);
            statisticsChangeMetric.setMissCount(0);
            propertyAcceptRateMap.put(PackageDiffConstant.ElementType.NODE.name() + "_" + workflowNodePropertyType.getDescription(), statisticsChangeMetric);
        });
        for (DiffElement diffElement : diffElementList) {
            if (diffElement.getDiffType().getOperationType().equals((Object)PackageDiffConstant.OperationType.PROPERTY_UPDATE)) {
                ((StatisticsChangeMetric)propertyAcceptRateMap.get(diffElement.getDiffType().getElementType().name() + "_" + diffElement.getPropertyPath())).setChangeCount(((StatisticsChangeMetric)propertyAcceptRateMap.get(diffElement.getDiffType().getElementType().name() + "_" + diffElement.getPropertyPath())).getChangeCount() + 1);
            }
            if (diffElement.getDiffType().equals((Object)PackageDiffConstant.DiffType.TARGET_NODE_DELETE)) {
                Arrays.stream(PackageDiffConstant.WorkflowNodePropertyType.values()).forEach(workflowNodePropertyType -> ((StatisticsChangeMetric)propertyAcceptRateMap.get(PackageDiffConstant.ElementType.NODE.name() + "_" + workflowNodePropertyType.getDescription())).setMissCount(((StatisticsChangeMetric)propertyAcceptRateMap.get(PackageDiffConstant.ElementType.NODE.name() + "_" + workflowNodePropertyType.getDescription())).getMissCount() + 1));
            }
            if (!diffElement.getDiffType().equals((Object)PackageDiffConstant.DiffType.TARGET_WORKFLOW_DELETE)) continue;
            Arrays.stream(PackageDiffConstant.WorkflowPropertyType.values()).forEach(workflowPropertyType -> ((StatisticsChangeMetric)propertyAcceptRateMap.get(PackageDiffConstant.ElementType.WORKFLOW.name() + "_" + workflowPropertyType.getDescription())).setMissCount(((StatisticsChangeMetric)propertyAcceptRateMap.get(PackageDiffConstant.ElementType.WORKFLOW.name() + "_" + workflowPropertyType.getDescription())).getMissCount() + 1));
        }
        for (String property : propertyAcceptRateMap.keySet()) {
            ((StatisticsChangeMetric)propertyAcceptRateMap.get(property)).calculateRate();
        }
        return propertyAcceptRateMap;
    }
}

