/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.url.model;

import com.aliyun.securitysdk.url.model.SSRFMatcherMask;
import java.util.HashMap;
import java.util.Map;

public class DomainMask
implements SSRFMatcherMask {
    private static final String SEPARATOR = "/";
    private String domain;
    private MatcherType matcherType;

    public DomainMask(String domain, MatcherType matcherType) {
        this.domain = domain;
        this.matcherType = matcherType == null ? MatcherType.Trie : matcherType;
    }

    DomainMask(String format) {
        if (!format.contains(SEPARATOR)) {
            this.domain = format;
            this.matcherType = MatcherType.Trie;
        } else {
            int indexOfSeperator = format.indexOf(SEPARATOR);
            this.domain = format.substring(0, indexOfSeperator);
            this.matcherType = MatcherType.fromValue(format.substring(indexOfSeperator + 1));
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public MatcherType getMatcherType() {
        return this.matcherType;
    }

    public void setMatcherType(MatcherType matcherType) {
        this.matcherType = matcherType;
    }

    public static DomainMask parse(String format) {
        return new DomainMask(format);
    }

    public static String format(String domain, MatcherType matcherType) {
        if (domain == null) {
            return null;
        }
        return new DomainMask(domain, matcherType).format();
    }

    @Override
    public String format() {
        return this.domain + SEPARATOR + this.matcherType.value;
    }

    public static enum MatcherType {
        Precise("Precise"),
        Trie("Trie");

        private static final Map<String, MatcherType> stringToEnum;
        private final String value;

        private MatcherType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static MatcherType fromValue(String v) {
            String value = MatcherType.emptyToNull(v);
            if (value == null) {
                return null;
            }
            if (stringToEnum.containsKey(v)) {
                return stringToEnum.get(v);
            }
            throw new IllegalArgumentException(v);
        }

        private static String emptyToNull(String string) {
            return string == null || string.length() == 0 ? null : string;
        }

        static {
            stringToEnum = new HashMap<String, MatcherType>();
            for (MatcherType item : MatcherType.values()) {
                if (stringToEnum.containsKey(item.value())) {
                    throw new IllegalArgumentException("Duplicated enums, the values of enums should be unique : " + item.value());
                }
                stringToEnum.put(item.value(), item);
            }
        }
    }
}

