/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.airflowv1.reader.module;

import com.alibaba.cola.dto.Response;
import com.alibaba.cola.dto.SingleResponse;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirflowV1Reader
extends AbstractReader {
    private static final Logger log = LoggerFactory.getLogger(AirflowV1Reader.class);

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        Datasource scheduleDataSource = taskContext.getReaderDatasource();
        this.supplyDataSourceOperatorType(scheduleDataSource);
        Map properties = scheduleDataSource.getProperties();
        String sourFilePath = (String)properties.get("source-file-path");
        taskContext.setSourceFilePackage(sourFilePath);
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        String sourFilePath = this.taskContext.getSourceFilePackage();
        if (StringUtils.isBlank((CharSequence)sourFilePath)) {
            return Response.buildFailure((String)BwmServiceErrorCode.FILE_NOT_FOUND.getCode(), (String)"sourceFilePath is null");
        }
        BwmPackageFileOperator.readFile((String)sourFilePath);
        return SingleResponse.buildSuccess();
    }

    public WorkflowProjectPackage read() throws Exception {
        return BwmPackageFileOperator.readFile((String)this.taskContext.getSourceFilePackage());
    }
}

