/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.client.command;

import com.alibaba.fastjson2.JSON;
import com.aliyun.dataworks.client.command.AppMeta;
import com.aliyun.dataworks.client.command.AppType;
import com.aliyun.dataworks.client.command.CommandApp;
import com.aliyun.dataworks.client.command.CommandAppFactory;
import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAppEntrance {
    private static final Logger log = LoggerFactory.getLogger(CommandAppEntrance.class);

    public static void main(String[] args) throws IOException {
        String currentDir = System.getProperty("currentDir");
        AppType appType = AppType.valueOf(System.getProperty("appType"));
        Map<AppType, Map<String, AppMeta>> apps = CommandAppEntrance.loadApps(Joiner.on((String)File.separator).join((Object)currentDir, (Object)"conf", new Object[0]), appType);
        Options options = new Options();
        options.addRequiredOption("a", "app", true, "app name");
        HelpFormatter helpFormatter = new HelpFormatter();
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(options, args, true);
            String appName = commandLine.getOptionValue("a");
            if (!apps.get((Object)appType).containsKey(appName)) {
                throw new RuntimeException("unknown app: " + appName);
            }
            Object app = CommandAppFactory.create(appType, appName);
            ((CommandApp)app).setAppMeta(apps.get((Object)appType).get(appName));
            log.info("start running app {} with args: {}", (Object)appName, (Object)commandLine.getArgs());
            ((CommandApp)app).run(commandLine.getArgs());
            log.info("app command success");
        }
        catch (ParseException e) {
            log.error("app command parse error: {}", (Object)e.getMessage());
            String footer = Joiner.on((String)" ").join((Object)"\nAvailable apps: \n", (Object)JSON.toJSONString(CommandAppFactory.getApps()), new Object[0]);
            helpFormatter.printHelp("Options", "migrationx", options, footer);
        }
        catch (Exception e) {
            log.error("app command failed: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Map<AppType, Map<String, AppMeta>> loadApps(String conf, AppType ... appTypes) throws IOException {
        File config;
        File appsJson = config = new File(conf);
        if (config.isDirectory()) {
            appsJson = new File(config, "apps.json");
        }
        String json = FileUtils.readFileToString((File)appsJson, (Charset)StandardCharsets.UTF_8);
        Map apps = (Map)JSON.parseObject((String)json, (Type)new TypeToken<Map<AppType, Map<String, AppMeta>>>(){}.getType());
        MapUtils.emptyIfNull((Map)apps).forEach((appType, map) -> MapUtils.emptyIfNull((Map)map).forEach((appName, appMeta) -> {
            if (appTypes != null && Stream.of(appTypes).noneMatch(t -> Objects.equals(t, appType))) {
                log.info("skip load app type: {}, appType needs load: {}", (Object)appType, (Object)appTypes);
                return;
            }
            try {
                appMeta.setName((String)appName);
                appMeta.setType((AppType)((Object)appType));
                log.info("register command app type: {}, name: {}, class: {}", new Object[]{appType, appName, appMeta.getAppClass()});
                CommandAppFactory.register(appType, appName, appMeta.getAppClass());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        log.info("apps map: {}", (Object)JSON.toJSONString((Object)apps));
        return apps;
    }
}

