/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.client.command;

import com.aliyun.dataworks.client.command.AppMeta;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandApp {
    private static final Logger log = LoggerFactory.getLogger(CommandApp.class);
    protected AppMeta appMeta;

    public void run(String[] args) throws Exception {
        Options options = this.getOptions();
        CommandLine cli = this.getCommandLine(options, args);
        this.doCommandRun(options, cli, args);
    }

    protected void doCommandRun(Options options, CommandLine cli, String[] args) {
    }

    protected CommandLine getCommandLine(Options options, String[] args) throws Exception {
        HelpFormatter helpFormatter = new HelpFormatter();
        try {
            DefaultParser parser = new DefaultParser();
            return parser.parse(options, args, true);
        }
        catch (ParseException e) {
            log.error("parser command error: {}", (Object)e.getMessage());
            helpFormatter.printHelp("Options: ", options);
            System.exit(-1);
            throw new RuntimeException("Command line parse failed");
        }
    }

    protected Options getOptions() {
        return new Options();
    }

    protected Locale getLocale() {
        String lang = Optional.ofNullable(System.getenv("LANG")).orElse("zh_CN.UTF-8");
        String locale = StringUtils.split((String)lang, (String)".")[0];
        return Arrays.stream(Locale.getAvailableLocales()).filter(l -> StringUtils.equalsIgnoreCase((CharSequence)locale, (CharSequence)l.toString())).findFirst().orElse(Locale.US);
    }

    public void setAppMeta(AppMeta appMeta) {
        this.appMeta = appMeta;
    }
}

