/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xml.serialize;

import com.alibaba.securitysdk.org.apache.xerces.dom.DOMMessageFormatter;
import com.alibaba.securitysdk.org.apache.xml.serialize.HTMLSerializer;
import com.alibaba.securitysdk.org.apache.xml.serialize.OutputFormat;
import com.alibaba.securitysdk.org.apache.xml.serialize.Serializer;
import com.alibaba.securitysdk.org.apache.xml.serialize.SerializerFactory;
import com.alibaba.securitysdk.org.apache.xml.serialize.TextSerializer;
import com.alibaba.securitysdk.org.apache.xml.serialize.XHTMLSerializer;
import com.alibaba.securitysdk.org.apache.xml.serialize.XMLSerializer;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String method) {
        this._method = method;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{method});
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public Serializer makeSerializer(OutputFormat format) {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputFormat(format);
        return serializer;
    }

    @Override
    public Serializer makeSerializer(Writer writer, OutputFormat format) {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputCharStream(writer);
        return serializer;
    }

    @Override
    public Serializer makeSerializer(OutputStream output, OutputFormat format) throws UnsupportedEncodingException {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputByteStream(output);
        return serializer;
    }

    private Serializer getSerializer(OutputFormat format) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(format);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(format);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(format);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{this._method});
        throw new IllegalStateException(msg);
    }

    @Override
    protected String getSupportedMethod() {
        return this._method;
    }
}

