/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers;

import com.alibaba.securitysdk.org.apache.xerces.impl.xpath.XPathException;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.SchemaSymbols;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.identity.Field;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.identity.IdentityConstraint;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.identity.Selector;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSDHandler;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import com.alibaba.securitysdk.org.apache.xerces.util.DOMUtil;
import com.alibaba.securitysdk.org.w3c.dom.Element;
import com.alibaba.securitysdk.org.w3c.dom.Node;

class XSDAbstractIDConstraintTraverser
extends XSDAbstractTraverser {
    public XSDAbstractIDConstraintTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    void traverseIdentityConstraint(IdentityConstraint ic, Element icElem, XSDocumentInfo schemaDoc, Object[] icElemAttrs) {
        String sText;
        Element selChild;
        Element sElem = DOMUtil.getFirstChildElement((Node)icElem);
        if (sElem == null) {
            this.reportSchemaError("s4s-elt-must-match.2", new Object[]{"identity constraint", "(annotation?, selector, field+)"}, icElem);
            return;
        }
        if (DOMUtil.getLocalName((Node)sElem).equals(SchemaSymbols.ELT_ANNOTATION)) {
            ic.addAnnotation(this.traverseAnnotationDecl(sElem, icElemAttrs, false, schemaDoc));
            sElem = DOMUtil.getNextSiblingElement((Node)sElem);
            if (sElem == null) {
                this.reportSchemaError("s4s-elt-must-match.2", new Object[]{"identity constraint", "(annotation?, selector, field+)"}, icElem);
                return;
            }
        } else {
            String text = DOMUtil.getSyntheticAnnotation((Node)icElem);
            if (text != null) {
                ic.addAnnotation(this.traverseSyntheticAnnotation(icElem, text, icElemAttrs, false, schemaDoc));
            }
        }
        Object[] attrValues = this.fAttrChecker.checkAttributes(sElem, false, schemaDoc);
        if (!DOMUtil.getLocalName((Node)sElem).equals(SchemaSymbols.ELT_SELECTOR)) {
            this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"identity constraint", "(annotation?, selector, field+)", SchemaSymbols.ELT_SELECTOR}, sElem);
        }
        if ((selChild = DOMUtil.getFirstChildElement((Node)sElem)) != null) {
            if (DOMUtil.getLocalName((Node)selChild).equals(SchemaSymbols.ELT_ANNOTATION)) {
                ic.addAnnotation(this.traverseAnnotationDecl(selChild, attrValues, false, schemaDoc));
                selChild = DOMUtil.getNextSiblingElement((Node)selChild);
            } else {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_SELECTOR, "(annotation?)", DOMUtil.getLocalName((Node)selChild)}, selChild);
            }
            if (selChild != null) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_SELECTOR, "(annotation?)", DOMUtil.getLocalName((Node)selChild)}, selChild);
            }
        } else {
            String text = DOMUtil.getSyntheticAnnotation((Node)sElem);
            if (text != null) {
                ic.addAnnotation(this.traverseSyntheticAnnotation(icElem, text, attrValues, false, schemaDoc));
            }
        }
        if ((sText = (String)attrValues[XSAttributeChecker.ATTIDX_XPATH]) == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_SELECTOR, SchemaSymbols.ATT_XPATH}, sElem);
            return;
        }
        sText = sText.trim();
        Selector.XPath sXpath = null;
        try {
            sXpath = new Selector.XPath(sText, this.fSymbolTable, schemaDoc.fNamespaceSupport);
            Selector selector = new Selector(sXpath, ic);
            ic.setSelector(selector);
        }
        catch (XPathException e) {
            this.reportSchemaError(e.getKey(), new Object[]{sText}, sElem);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        Element fElem = DOMUtil.getNextSiblingElement((Node)sElem);
        if (fElem == null) {
            this.reportSchemaError("s4s-elt-must-match.2", new Object[]{"identity constraint", "(annotation?, selector, field+)"}, sElem);
        }
        while (fElem != null) {
            Element fieldChild;
            attrValues = this.fAttrChecker.checkAttributes(fElem, false, schemaDoc);
            if (!DOMUtil.getLocalName((Node)fElem).equals(SchemaSymbols.ELT_FIELD)) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"identity constraint", "(annotation?, selector, field+)", SchemaSymbols.ELT_FIELD}, fElem);
            }
            if ((fieldChild = DOMUtil.getFirstChildElement((Node)fElem)) != null && DOMUtil.getLocalName((Node)fieldChild).equals(SchemaSymbols.ELT_ANNOTATION)) {
                ic.addAnnotation(this.traverseAnnotationDecl(fieldChild, attrValues, false, schemaDoc));
                fieldChild = DOMUtil.getNextSiblingElement((Node)fieldChild);
            }
            if (fieldChild != null) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_FIELD, "(annotation?)", DOMUtil.getLocalName((Node)fieldChild)}, fieldChild);
            } else {
                String text = DOMUtil.getSyntheticAnnotation((Node)fElem);
                if (text != null) {
                    ic.addAnnotation(this.traverseSyntheticAnnotation(icElem, text, attrValues, false, schemaDoc));
                }
            }
            String fText = (String)attrValues[XSAttributeChecker.ATTIDX_XPATH];
            if (fText == null) {
                this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_FIELD, SchemaSymbols.ATT_XPATH}, fElem);
                return;
            }
            fText = fText.trim();
            try {
                Field.XPath fXpath = new Field.XPath(fText, this.fSymbolTable, schemaDoc.fNamespaceSupport);
                Field field = new Field(fXpath, ic);
                ic.addField(field);
            }
            catch (XPathException e) {
                this.reportSchemaError(e.getKey(), new Object[]{fText}, fElem);
                this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
                return;
            }
            fElem = DOMUtil.getNextSiblingElement((Node)fElem);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        }
    }
}

