/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.wedata.handle;

import com.alibaba.cola.dto.Response;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.wedata.handle.AbstractWedataHandler;
import com.aliyun.migration.workflow.migration.wedata.tools.LhmLLMClient;
import com.aliyun.migration.workflow.migration.wedata.tools.TencentBase64;
import com.aliyun.migration.workflow.migration.wedata.tools.WedataOpenapiClient;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WedataOpenApiHandler
extends AbstractWedataHandler {
    private static final Logger log = LoggerFactory.getLogger(WedataOpenApiHandler.class);
    private WedataOpenapiClient client;
    private String projectId;
    private String projectName;

    public WedataOpenApiHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        super(taskContext, scheduleDataSource);
        Map connectionMap = scheduleDataSource.getProperties();
        String region = "ap-beijing";
        if (connectionMap.containsKey("region")) {
            region = (String)connectionMap.get("region");
        } else {
            log.warn("[WEDATA-OPENAPI-HANDLER]: cannot get region from config json, use default region: ap-beijing");
        }
        String secretId = "";
        if (connectionMap.containsKey("secretId")) {
            secretId = (String)connectionMap.get("secretId");
        } else {
            log.error("[WEDATA-OPENAPI-HANDLER]: cannot get secretId from config json");
        }
        String secretKey = "";
        if (connectionMap.containsKey("secretKey")) {
            secretKey = (String)connectionMap.get("secretKey");
        } else {
            log.error("[WEDATA-OPENAPI-HANDLER]: cannot get secretKey from config json");
        }
        String projectId = "";
        if (connectionMap.containsKey("projectId")) {
            projectId = (String)connectionMap.get("projectId");
        } else {
            log.error("[WEDATA-OPENAPI-HANDLER]: cannot get projectId from config json");
        }
        this.client = new WedataOpenapiClient(secretId, secretKey, region);
        this.projectId = projectId;
    }

    public WedataOpenApiHandler(String secretId, String secretKey, String region) {
        super(null, null);
        this.client = new WedataOpenapiClient(secretId, secretKey, region);
    }

    @Override
    public void init() {
    }

    @Override
    public Response preCheck(Datasource scheduleDataSource) {
        return null;
    }

    @Override
    public WorkflowProjectPackage read() {
        if (!StringUtils.isBlank((CharSequence)this.projectId)) {
            return this.read(this.projectId);
        }
        log.error("[WEDATA-OPENAPI-HANDLER]: cannot get projectId or projectName from config json");
        return null;
    }

    public WorkflowProjectPackage read(String projectId) {
        WorkflowProjectPackage pkg = new WorkflowProjectPackage();
        pkg.setWorkflowProject(this.getWorkflowProject(projectId));
        Map<String, String> folderMap = this.folderPathMap();
        pkg.setWorkflowList(new ArrayList());
        pkg.getWorkflowList().addAll(this.getWorkflowList(projectId, folderMap));
        pkg.setDatasources(this.getDatasources(projectId));
        this.refreshBasicInfosInPkg(pkg, projectId, pkg.getWorkflowProject().getName());
        return pkg;
    }

    public Map<String, String> folderPathMap() {
        HashMap<String, String> folderMap = new HashMap<String, String>();
        JSONArray folderJson = this.client.FindAllFolder(this.projectId);
        this.getInnerFolder(folderMap, folderJson, "");
        return folderMap;
    }

    public void getInnerFolder(Map<String, String> folderMap, JSONArray folderJson, String parentPath) {
        if (!folderJson.isEmpty()) {
            for (int i = 0; i < folderJson.size(); ++i) {
                JSONObject folder = folderJson.getJSONObject(i);
                String folderPath = (String)(parentPath.isEmpty() ? "" : parentPath + "/") + folder.getString("Name");
                folderMap.put(folder.getString("Id"), folderPath);
                this.getInnerFolder(folderMap, folder.getJSONArray("Folders"), folderPath);
            }
        }
    }

    public WorkflowProject getWorkflowProject(String projectId) {
        WorkflowProject workflowProject = new WorkflowProject();
        JSONObject projectJson = this.client.DescribeProject(projectId);
        workflowProject.setProjectId(projectId);
        if (projectJson != null && projectJson.containsKey("ProjectName")) {
            workflowProject.setName(projectJson.getString("ProjectName"));
        }
        if (projectJson != null && projectJson.containsKey("Description")) {
            workflowProject.setDescription(projectJson.getString("Description"));
        }
        JSONArray paramsJson = this.client.DescribeProjectParamDsPage(projectId, "");
        workflowProject.setParamMap(new HashMap());
        if (paramsJson != null && !paramsJson.isEmpty()) {
            for (int i = 0; i < paramsJson.size(); ++i) {
                JSONObject param = paramsJson.getJSONObject(i);
                workflowProject.getParamMap().put(param.getString("ParamKey"), param.getString("ParamValue"));
            }
        }
        return workflowProject;
    }

    public List<WorkflowDatasource> getDatasources(String projectId) {
        ArrayList<WorkflowDatasource> datasources = new ArrayList<WorkflowDatasource>();
        JSONArray dataSourceListJson = this.client.DescribeDataSourceList(projectId);
        for (int i = 0; i < dataSourceListJson.size(); ++i) {
            WorkflowDatasource datasource = new WorkflowDatasource();
            datasource.setCustomProperties(new HashMap());
            JSONObject dataSourceJson = dataSourceListJson.getJSONObject(i);
            datasource.setDatasourceId(dataSourceJson.getString("ID"));
            datasource.setName(dataSourceJson.getString("Name"));
            log.info("[NEW-DATASOURCE]: {}, {}", (Object)datasource.getName(), (Object)datasource.getDatasourceId());
            if (dataSourceJson.containsKey("Type")) {
                datasource.setType(dataSourceJson.getString("Type"));
            } else {
                datasource.setType(Datasource.Type.Custom.name());
            }
            try {
                HashMap paramsMap = (HashMap)JSONObject.parseObject((String)dataSourceJson.getString("ParamsString"), HashMap.class);
                for (Map.Entry entry : paramsMap.entrySet()) {
                    datasource.getCustomProperties().put((String)entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                log.info("get datasource properties error, maybe datasource have no properties");
            }
            datasources.add(datasource);
        }
        return datasources;
    }

    public List<Workflow> getWorkflowList(String projectId, Map<String, String> folderMap) {
        ArrayList<Workflow> workflowList = new ArrayList<Workflow>();
        JSONArray workflowListJson = this.client.DescribeWorkflowListByProjectId(projectId);
        for (int i = 0; i < workflowListJson.size(); ++i) {
            Workflow workflow = new Workflow();
            JSONObject workflowJson = workflowListJson.getJSONObject(i);
            workflow.setWorkflowId(workflowJson.getString("WorkflowId"));
            workflow.setWorkflowName(workflowJson.getString("WorkflowName"));
            log.info("[NEW-WORKFLOW]({}/{}): {}, {}", new Object[]{i + 1, workflowListJson.size(), workflow.getWorkflowName(), workflow.getWorkflowId()});
            workflow.setDescription(workflowJson.getString("WorkflowDesc"));
            workflow.setProjectId(workflowJson.getString("ProjectId"));
            workflow.setProjectName(workflowJson.getString("ProjectName"));
            workflow.setCategoryId(workflowJson.getString("FolderId"));
            if (folderMap.containsKey(workflow.getCategoryId())) {
                workflow.setCategoryValue(folderMap.get(workflow.getCategoryId()));
            }
            workflow.setOwner(workflowJson.getString("Owner") + "@" + workflowJson.getString("OwnerId"));
            this.getWorkflowDetail(workflow);
            this.getWorkflowNodes(workflow);
            workflow.setParamMap(new HashMap());
            try {
                JSONArray paramArray;
                JSONObject paramJson = this.client.DescribeWorkflowParamDs(projectId, workflow.getWorkflowId());
                if (paramJson.containsKey("Data") && !paramJson.getJSONArray("Data").isEmpty() && (paramArray = paramJson.getJSONArray("Data")) != null && !paramArray.isEmpty()) {
                    for (int j = 0; j < paramArray.size(); ++j) {
                        JSONObject param = paramArray.getJSONObject(j);
                        workflow.getParamMap().put(param.getString("ParamKey"), param.getString("ParamValue"));
                    }
                }
            }
            catch (Exception e) {
                log.info("get param error, maybe workflow have no param");
            }
            workflow.setCustomProperties(new HashMap());
            try {
                JSONObject taskDetailDsJson = this.client.DescribeWorkflowCanvasInfoDs(projectId, workflow.getWorkflowId());
                if (taskDetailDsJson != null && taskDetailDsJson.containsKey("Data") && taskDetailDsJson.getJSONObject("Data").containsKey("SparkParams")) {
                    workflow.getCustomProperties().put("SparkParams", taskDetailDsJson.getJSONObject("Data").getString("SparkParams"));
                }
            }
            catch (Exception e) {
                log.info("get spark param error, maybe workflow have no spark param");
            }
            workflowList.add(workflow);
        }
        return workflowList;
    }

    public void getWorkflowDetail(Workflow workflow) {
        JSONObject workflowInfoJson = this.client.DescribeWorkflowInfoById(workflow.getProjectId(), workflow.getWorkflowId());
        workflow.setTriggers(List.of(this.collectTriggerInfo(workflowInfoJson)));
    }

    public void getWorkflowNodes(Workflow workflow) {
        int i;
        ArrayList<WorkflowNode> workflowNodes = new ArrayList<WorkflowNode>();
        ArrayList<RelationPackage> relationPackages = new ArrayList<RelationPackage>();
        workflow.setWorkflowNodes(workflowNodes);
        workflow.setNodeRelations(relationPackages);
        JSONObject canvasObject = this.client.DescribeWorkflowCanvasInfo(workflow.getProjectId(), workflow.getWorkflowId());
        if (canvasObject == null) {
            return;
        }
        if (canvasObject.containsKey("Tasks") && !canvasObject.getJSONArray("Tasks").isEmpty()) {
            for (i = 0; i < canvasObject.getJSONArray("Tasks").size(); ++i) {
                JSONObject taskDetailDsJson;
                JSONObject taskJson;
                WorkflowNode workflowNode;
                block39: {
                    workflowNode = new WorkflowNode();
                    taskJson = canvasObject.getJSONArray("Tasks").getJSONObject(i);
                    workflowNode.setNodeId(taskJson.getString("TaskId"));
                    workflowNode.setNodeName(taskJson.getString("TaskName"));
                    if (taskJson.containsKey("VirtualFlag") && taskJson.getBoolean("VirtualFlag").booleanValue()) {
                        log.info("[NEW-NODE]({}/{})(VIRTUAL): {}, {}", new Object[]{i + 1, canvasObject.getJSONArray("Tasks").size(), workflowNode.getNodeName(), workflowNode.getNodeId()});
                        continue;
                    }
                    log.info("[NEW-NODE]({}/{}): {}, {}", new Object[]{i + 1, canvasObject.getJSONArray("Tasks").size(), workflowNode.getNodeName(), workflowNode.getNodeId()});
                    workflowNode.setWorkflowId(taskJson.getString("WorkflowId"));
                    workflowNode.setWorkflowName(taskJson.getString("WorkflowName"));
                    workflowNode.setProjectId(taskJson.getString("ProjectId"));
                    workflowNode.setProjectName(taskJson.getString("ProjectName"));
                    workflowNode.setOwner(taskJson.getString("InCharge"));
                    workflowNode.setTrigger(this.collectTriggerInfo(taskJson));
                    workflowNode.setNodeType(taskJson.getJSONObject("TaskType").getString("TypeDesc"));
                    workflowNode.setDescription(taskJson.getString("Notes"));
                    workflowNode.setPriority(taskJson.getInteger("RunPriority"));
                    if (taskJson.getString("Status").equals("Y")) {
                        workflowNode.setState(WorkflowNode.Recurrence.NORMAL);
                    } else {
                        workflowNode.setState(WorkflowNode.Recurrence.SKIP);
                    }
                    if (workflowNode.getCustomProperties() == null) {
                        workflowNode.setCustomProperties(new HashMap());
                    }
                    workflowNode.getCustomProperties().put("RetryWait", taskJson.getInteger("RetryWait"));
                    workflowNode.getCustomProperties().put("RetryAble", taskJson.getInteger("RetryAble"));
                    workflowNode.getCustomProperties().put("TryLimit", taskJson.getInteger("TryLimit"));
                    workflowNode.getCustomProperties().put("InstanceIniStrategy", taskJson.getString("InstanceIniStrategy"));
                    workflowNode.getCustomProperties().put("SelfDepend", taskJson.getString("SelfDepend"));
                    workflowNode.getCustomProperties().put("DependencyRel", taskJson.getString("DependencyRel"));
                    workflowNode.getCustomProperties().put("DependencyWorkflow", taskJson.getString("DependencyWorkflow"));
                    workflowNode.setDbType(this.concatenateStrings(taskJson.containsKey("SourceServiceType") ? taskJson.getString("SourceServiceType").replaceAll("^;|;$", "").replaceAll(";", ",") : null, taskJson.containsKey("TargetServiceType") ? taskJson.getString("TargetServiceType").replaceAll("^;|;$", "").replaceAll(";", ",") : null));
                    workflowNode.getCustomProperties().put("datasource", this.concatenateStrings(taskJson.containsKey("SourceServiceId") ? taskJson.getString("SourceServiceId").replaceAll("^;|;$", "").replaceAll(";", ",") : null, taskJson.containsKey("TargetServiceId") ? taskJson.getString("TargetServiceId").replaceAll("^;|;$", "").replaceAll(";", ",") : null));
                    taskDetailDsJson = this.client.DescribeTaskDetailDs(workflow.getProjectId(), taskJson.getString("TaskId"));
                    try {
                        if (StringUtils.isBlank((CharSequence)workflowNode.getNodeType())) break block39;
                        switch (workflowNode.getNodeType()) {
                            case "For-each": 
                            case "ForeachStart": 
                            case "ForeachEnd": {
                                break;
                            }
                            case "\u5206\u652f\u8282\u70b9": {
                                JSONObject property;
                                try {
                                    JSONArray propertiesArray;
                                    if (taskDetailDsJson != null && taskDetailDsJson.containsKey("Data") && taskDetailDsJson.getJSONObject("Data").containsKey("TaskExt") && taskDetailDsJson.getJSONObject("Data").getJSONObject("TaskExt").containsKey("Properties") && (propertiesArray = taskDetailDsJson.getJSONObject("Data").getJSONObject("TaskExt").getJSONArray("Properties")) != null && !propertiesArray.isEmpty()) {
                                        for (int j = 0; j < propertiesArray.size(); ++j) {
                                            property = propertiesArray.getJSONObject(j);
                                            if (!property.containsKey("ParamKey") || !property.getString("ParamKey").equals("branchCondition")) continue;
                                            workflowNode.setScript(property.getString("ParamValue"));
                                        }
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    log.info("cannot get script for branch node, maybe task have no script");
                                    break;
                                }
                            }
                            case "\u5f52\u5e76\u8282\u70b9": {
                                JSONObject property;
                                try {
                                    JSONArray propertiesArray;
                                    if (taskDetailDsJson != null && taskDetailDsJson.containsKey("Data") && taskDetailDsJson.getJSONObject("Data").containsKey("TaskExt") && taskDetailDsJson.getJSONObject("Data").getJSONObject("TaskExt").containsKey("Properties") && (propertiesArray = taskDetailDsJson.getJSONObject("Data").getJSONObject("TaskExt").getJSONArray("Properties")) != null && !propertiesArray.isEmpty()) {
                                        for (int j = 0; j < propertiesArray.size(); ++j) {
                                            property = propertiesArray.getJSONObject(j);
                                            if (!property.containsKey("ParamKey") || !property.getString("ParamKey").equals("mergeCondition")) continue;
                                            workflowNode.setScript(property.getString("ParamValue"));
                                        }
                                    }
                                    break;
                                }
                                catch (Exception e) {
                                    log.info("cannot get script for branch node, maybe task have no script");
                                    break;
                                }
                            }
                            default: {
                                JSONObject scriptJson = this.client.DescribeTaskScript(workflow.getProjectId(), taskJson.getString("TaskId"));
                                String script = scriptJson.getString("ScriptContent");
                                workflowNode.setScript(TencentBase64.decode(script));
                            }
                        }
                    }
                    catch (Exception e) {
                        log.info("get script error, maybe task have no script");
                    }
                }
                workflowNode.setParamMap(new HashMap());
                try {
                    JSONArray paramArray;
                    JSONObject paramJson = this.client.DescribeTaskParamDs(workflow.getProjectId(), taskJson.getString("TaskId"));
                    if (paramJson.containsKey("Data") && (paramArray = paramJson.getJSONArray("Data")) != null && !paramArray.isEmpty()) {
                        for (int j = 0; j < paramArray.size(); ++j) {
                            JSONObject param = paramArray.getJSONObject(j);
                            workflowNode.getParamMap().put(param.getString("ParamKey"), param.getString("ParamDefine"));
                        }
                    }
                }
                catch (Exception e) {
                    log.info("get param error, maybe task have no param");
                }
                try {
                    JSONArray propertiesArray;
                    if (taskDetailDsJson != null && taskDetailDsJson.containsKey("Data") && taskDetailDsJson.getJSONObject("Data").containsKey("TaskExt") && taskDetailDsJson.getJSONObject("Data").getJSONObject("TaskExt").containsKey("Properties") && (propertiesArray = taskDetailDsJson.getJSONObject("Data").getJSONObject("TaskExt").getJSONArray("Properties")) != null && !propertiesArray.isEmpty()) {
                        for (int j = 0; j < propertiesArray.size(); ++j) {
                            JSONObject property = propertiesArray.getJSONObject(j);
                            if (!property.containsKey("ParamKey") || !property.getString("ParamKey").equals("properties")) continue;
                            workflowNode.getCustomProperties().put("SparkParams", property.getString("ParamValue"));
                        }
                    }
                }
                catch (Exception e) {
                    log.info("get spark param error, maybe task have no spark param");
                }
                workflowNodes.add(workflowNode);
            }
        }
        if (canvasObject.containsKey("Links") && !canvasObject.getJSONArray("Links").isEmpty()) {
            for (i = 0; i < canvasObject.getJSONArray("Links").size(); ++i) {
                RelationPackage relationPackage = new RelationPackage();
                JSONObject linkJson = canvasObject.getJSONArray("Links").getJSONObject(i);
                relationPackage.setFrom(linkJson.getString("TaskFrom"));
                relationPackage.setTo(linkJson.getString("TaskTo"));
                relationPackage.setReType(RelationPackage.ReType.NODE);
                relationPackages.add(relationPackage);
            }
        }
    }

    public WorkflowTrigger collectTriggerInfo(JSONObject info) {
        WorkflowTrigger workflowTrigger = new WorkflowTrigger();
        if (!info.containsKey("CycleType")) {
            log.info("get illegal info about trigger");
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (info.containsKey("StartTime")) {
            workflowTrigger.setStartTime(LocalDateTime.parse(info.getString("StartTime"), formatter));
        } else {
            log.warn("get start time error, maybe have no start time, use current time as default");
            workflowTrigger.setStartTime(LocalDateTime.now());
        }
        if (info.containsKey("EndTime")) {
            workflowTrigger.setEndTime(LocalDateTime.parse(info.getString("EndTime"), formatter));
        } else {
            log.warn("get end time error, maybe have no end time, use 2099 year as default");
            workflowTrigger.setEndTime(LocalDateTime.parse("2099-01-01 00:00:00", formatter));
        }
        workflowTrigger.setCron(this.getCron(info.getInteger("CycleStep"), info.getString("CycleType"), info.getInteger("DelayTime"), info.getString("TaskAction"), info.getString("StartTime"), info.getString("CrontabExpression"), info.getString("SchedulerDesc"), info.getString("ExecutionStartTime"), info.getString("ExecutionEndTime")));
        workflowTrigger.setDescription(info.getString("SchedulerDesc"));
        return workflowTrigger;
    }

    public String getCron(Integer cycleStep, String cycleType, Integer delayTime, String taskAction, String startTime, String crontabExpression, String schedulerDesc, String executionStartTime, String executionEndTime) {
        try {
            JSONObject cronJson = this.client.GenCronAndSchedulerDesc(this.projectId, cycleStep, cycleType, delayTime, taskAction, startTime, executionStartTime, executionEndTime);
            if (cronJson.containsKey("Data") && cronJson.getJSONObject("Data").containsKey("Cron")) {
                String cron = cronJson.getJSONObject("Data").getString("Cron");
                if (!cron.isEmpty()) {
                    return cron;
                }
                log.warn("\u5c1d\u8bd5\u4f7f\u7528WeData\u7684\u9690\u85cfAPI\u5408\u6210Cron\u8868\u8fbe\u5f0f\uff0c\u7136\u800cAPI\u8fd4\u56de\u4e86\u7a7a\u503c\uff0c\u53ef\u80fd\u672c\u8eab\u5c31\u6ca1\u6709\u8c03\u5ea6\u5c5e\u6027\uff0c\u5982foreach\u5185\u7684\u4efb\u52a1");
                return null;
            }
        }
        catch (Exception e) {
            log.warn("\u4f7f\u7528WeData\u7684\u9690\u85cfAPI\u5408\u6210Cron\u8868\u8fbe\u5f0f\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f7f\u7528\u89c4\u5219\u5408\u6210", (Object)e.getMessage());
        }
        if (cycleType.equals("CRONTAB_CYCLE")) {
            return crontabExpression;
        }
        if (cycleType.equals("DAY_CYCLE")) {
            return "0 " + delayTime % 60 + " " + delayTime / 60 + " * * ?";
        }
        if (cycleType.equals("HOUR_CYCLE")) {
            if (taskAction.length() == 0) {
                String startHour = executionStartTime.split(":")[0];
                String startMinute = "" + delayTime % 60;
                String endHour = executionEndTime.split(":")[0];
                String step = "" + cycleStep;
                return "0 " + startMinute + " " + startHour + "-" + endHour + "/" + step + " * * ?";
            }
            String startMinute = "" + delayTime % 60;
            String hours = taskAction;
            return "0 " + startMinute + " " + hours + " * * ?";
        }
        log.warn("\u6682\u65e0\u5408\u6210\u89c4\u5219\uff0c\u5c1d\u8bd5\u4f7f\u7528LLM\u5408\u6210:{}", (Object)schedulerDesc);
        String cronByLLM = null;
        for (int i = 0; i < 3; ++i) {
            cronByLLM = LhmLLMClient.getCronExpressionByDescription(schedulerDesc);
            if (cronByLLM != null) {
                log.info("get cron by LLM success:{}", (Object)cronByLLM);
                return cronByLLM;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.error("get cron by LLM error");
        return crontabExpression;
    }

    public Workflow getDISpecialWorkflow(String projectId) {
        Workflow workflow = new Workflow();
        workflow.setWorkflowName("WeDataDIFolder");
        workflow.setWorkflowId("-1");
        ArrayList<WorkflowNode> workflowNodes = new ArrayList<WorkflowNode>();
        workflow.setWorkflowNodes(workflowNodes);
        JSONArray wedataDiItem = this.client.DescribeIntegrationTasksDetails(projectId);
        if (wedataDiItem != null && !wedataDiItem.isEmpty()) {
            for (int i = 0; i < wedataDiItem.size(); ++i) {
                JSONObject diItem = wedataDiItem.getJSONObject(i);
                WorkflowNode workflowNode = new WorkflowNode();
                workflowNode.setNodeId(diItem.getString("TaskId"));
                workflowNode.setNodeName(diItem.getString("TaskName"));
                log.info("[NEW-DI]: {}, {}", (Object)diItem.getString("TaskName"), (Object)diItem.getString("TaskId"));
                if (diItem.containsKey("TaskType")) {
                    switch (diItem.getInteger("TaskType")) {
                        case 201: {
                            workflowNode.setNodeType("\u5b9e\u65f6\u540c\u6b65");
                            break;
                        }
                        case 202: {
                            workflowNode.setNodeType("\u79bb\u7ebf\u540c\u6b65");
                            break;
                        }
                        default: {
                            workflowNode.setNodeType("\u5b9e\u65f6\u540c\u6b65");
                        }
                    }
                }
                if (diItem.containsKey("Nodes") && !diItem.getJSONArray("Nodes").isEmpty()) {
                    String srcId = null;
                    String srcType = null;
                    String tgtId = null;
                    String tgtType = null;
                    for (int j = 0; j < diItem.getJSONArray("Nodes").size(); ++j) {
                        JSONObject node = diItem.getJSONArray("Nodes").getJSONObject(j);
                        if (node.containsKey("NodeType") && node.getString("NodeType").equals("INPUT")) {
                            srcId = node.getString("DatasourceId");
                            srcType = node.getString("DataSourceType");
                            continue;
                        }
                        if (!node.containsKey("NodeType") || !node.getString("NodeType").equals("OUTPUT")) continue;
                        tgtId = node.getString("DatasourceId");
                        tgtType = node.getString("DataSourceType");
                    }
                    workflowNode.setDbType(this.concatenateStrings(srcType, tgtType));
                    if (workflowNode.getCustomProperties() == null) {
                        workflowNode.setCustomProperties(new HashMap());
                    }
                    workflowNode.getCustomProperties().put("datasource", this.concatenateStrings(srcId, tgtId));
                }
                workflowNode.setScript(diItem.toJSONString(new JSONWriter.Feature[0]));
                workflowNodes.add(workflowNode);
            }
        }
        return workflow;
    }

    private String concatenateStrings(String ... strings) {
        StringBuilder sb = new StringBuilder();
        if (strings == null || strings.length == 0) {
            return null;
        }
        for (String s : strings) {
            if (StringUtils.isBlank((CharSequence)s)) continue;
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void refreshBasicInfosInPkg(WorkflowProjectPackage pkg, String projectId, String projectName) {
        if (projectId == null) {
            log.error("projectId is null");
            return;
        }
        if (projectName == null) {
            log.warn("projectName is null, use projectId as projectName");
            projectName = projectId;
        }
        if (pkg.getWorkflowProject() == null) {
            pkg.setWorkflowProject(new WorkflowProject());
        }
        pkg.getWorkflowProject().setProjectId(projectId);
        pkg.getWorkflowProject().setName(projectName);
        if (pkg.getWorkflowList() == null) {
            pkg.setWorkflowList(new ArrayList());
        } else {
            for (Workflow workflow : pkg.getWorkflowList()) {
                if (workflow.getWorkflowId() == null && workflow.getWorkflowName() == null) {
                    log.error("there is one workflow whose workflowId and workflowName are both null");
                } else if (workflow.getWorkflowId() == null) {
                    workflow.setWorkflowId(workflow.getWorkflowName());
                    log.warn("there is one workflow whose workflowId is null, use workflowName as workflowId: {}", (Object)workflow.getWorkflowName());
                } else if (workflow.getWorkflowName() == null) {
                    workflow.setWorkflowName(workflow.getWorkflowId());
                    log.warn("there is one workflow whose workflowName is null, use workflowId as workflowName: {}", (Object)workflow.getWorkflowId());
                }
                workflow.setProjectId(projectId);
                workflow.setProjectName(projectName);
                if (workflow.getWorkflowNodes() == null) {
                    workflow.setWorkflowNodes(new ArrayList());
                    continue;
                }
                for (WorkflowNode workflowNode : workflow.getWorkflowNodes()) {
                    workflowNode.setProjectId(projectId);
                    workflowNode.setProjectName(projectName);
                    workflowNode.setWorkflowId(workflow.getWorkflowId());
                    workflowNode.setWorkflowName(workflow.getWorkflowName());
                    if (workflowNode.getNodeId() == null && workflowNode.getNodeName() == null) {
                        log.error("there is one node whose Id and Name are both null");
                        continue;
                    }
                    if (workflowNode.getNodeId() == null) {
                        workflowNode.setNodeId(workflowNode.getNodeName());
                        log.warn("there is one node whose Id is null, use Name as Id: {}", (Object)workflow.getWorkflowName());
                        continue;
                    }
                    if (workflowNode.getNodeName() != null) continue;
                    workflowNode.setNodeName(workflowNode.getNodeId());
                    log.warn("there is one node whose Name is null, use Id as Name: {}", (Object)workflow.getWorkflowId());
                }
            }
        }
    }

    public List<WorkflowFileResource> getFileResource(String projectId) {
        return null;
    }
}

