/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.oozie.handle;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.oozie.converter.Oozie2WorkflowConvert;
import com.aliyun.migration.workflow.migration.oozie.domain.OoziePackage;
import com.aliyun.migration.workflow.migration.oozie.domain.OoziePackageFileService;
import com.aliyun.migration.workflow.migration.oozie.domain.OoziePackageLoader;
import com.aliyun.migration.workflow.migration.oozie.handle.AbstractOozieHandler;
import com.aliyun.migrationx.common.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OozieFileHandler
extends AbstractOozieHandler {
    private static final Logger log = LoggerFactory.getLogger(OozieFileHandler.class);
    protected OoziePackageFileService fileService;
    protected OoziePackage ooziePackage;
    protected WorkflowProjectPackage workflowProjectPackage;

    public OozieFileHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        super(scheduleDataSource, taskContext);
    }

    @Override
    public void init() {
        this.fileService = new OoziePackageFileService();
        this.ooziePackage = this.load();
    }

    protected OoziePackage load() {
        Map properties = this.scheduleDataSource.getProperties();
        String packagePath = properties.getOrDefault("source-file-path", "temp/Oozie/");
        File rootDir = new File(packagePath);
        try {
            File dataDir;
            if (rootDir.isFile()) {
                dataDir = ZipUtils.decompress((File)rootDir);
                dataDir = dataDir.listFiles()[0];
            } else {
                dataDir = rootDir;
            }
            OoziePackageLoader loader = new OoziePackageLoader();
            return OoziePackageLoader.load(dataDir);
        }
        catch (IOException e) {
            log.error("init.oozie.export.error", (Throwable)e);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.DOLPHIN_LOADER_FILE_FAILED);
        }
    }

    @Override
    public Response preCheck(Datasource scheduleDataSource) {
        return null;
    }

    @Override
    public WorkflowProjectPackage read() {
        Oozie2WorkflowConvert converter = new Oozie2WorkflowConvert();
        this.workflowProjectPackage = converter.convert(this.ooziePackage);
        return this.workflowProjectPackage;
    }
}

