/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.oozie.domain;

import com.aliyun.migration.workflow.migration.oozie.domain.OoziePackage;
import com.aliyun.migration.workflow.migration.oozie.domain.OoziePackageFileService;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieWorkflow;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OoziePackageLoader {
    private static final Logger log = LoggerFactory.getLogger(OoziePackageLoader.class);

    public static OoziePackage load(File packageRoot) throws IOException {
        OoziePackage ooziePackage = new OoziePackage();
        OoziePackageFileService fileService = new OoziePackageFileService();
        for (File workflowDir : packageRoot.listFiles()) {
            if (workflowDir.listFiles() == null) continue;
            log.info("load workflow dir: {}", (Object)workflowDir.getAbsolutePath());
            OozieWorkflow workflow = new OozieWorkflow();
            File xmlFile = null;
            ArrayList<File> propertiesFiles = new ArrayList<File>();
            ArrayList<File> coordinatorFiles = new ArrayList<File>();
            for (File file : workflowDir.listFiles()) {
                if (file.getName().endsWith(".xml")) {
                    if (file.getName().contains("workflow")) {
                        xmlFile = file;
                        continue;
                    }
                    if (!file.getName().contains("coordinator")) continue;
                    coordinatorFiles.add(file);
                    continue;
                }
                if (!file.getName().endsWith(".properties")) continue;
                propertiesFiles.add(file);
            }
            if (xmlFile == null) continue;
            workflow = fileService.readWorkflowPackageFile(xmlFile, propertiesFiles, coordinatorFiles);
            ooziePackage.addWorkflow(workflow);
        }
        return ooziePackage;
    }
}

