/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.oozie.converter;

import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieDataEvent;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieDataSet;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieFSOperation;
import com.aliyun.migration.workflow.migration.oozie.domain.OoziePackage;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieWorkflow;
import com.aliyun.migration.workflow.migration.oozie.domain.OozieWorkflowNode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oozie2WorkflowConvert {
    private static final Logger log = LoggerFactory.getLogger(Oozie2WorkflowConvert.class);

    public WorkflowProjectPackage convert(OoziePackage ooziePackage) {
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        ArrayList<Workflow> workflowList = new ArrayList<Workflow>();
        for (OozieWorkflow oozieWorkflow : ooziePackage.getWorkflows()) {
            DateTimeFormatter formatter;
            Workflow workflow = new Workflow();
            workflow.setWorkflowName(oozieWorkflow.getName());
            workflow.setWorkflowId(oozieWorkflow.getId());
            workflow.setDatasourceId(oozieWorkflow.getAppPath());
            HashMap<String, String> properties = new HashMap<String, String>();
            if (oozieWorkflow.getProperties() != null) {
                properties.putAll(oozieWorkflow.getProperties());
            }
            if (oozieWorkflow.getParameters() != null) {
                properties.putAll(oozieWorkflow.getParameters());
            }
            if (oozieWorkflow.getSla() != null) {
                properties.putAll(oozieWorkflow.getSla());
            }
            if (oozieWorkflow.getConcurrency() != null) {
                properties.put("concurrency", oozieWorkflow.getConcurrency());
            }
            if (oozieWorkflow.getTimeOut() != null) {
                properties.put("timeout", oozieWorkflow.getTimeOut());
            }
            if (oozieWorkflow.getExecutionMode() != null) {
                properties.put("executionMode", oozieWorkflow.getExecutionMode());
            }
            if (oozieWorkflow.getThrottle() != null) {
                properties.put("throttle", oozieWorkflow.getThrottle());
            }
            if (oozieWorkflow.getAppPath() != null) {
                properties.put("appPath", oozieWorkflow.getAppPath());
            }
            workflow.setCustomProperties(properties);
            Boolean haveTriggerFlag = false;
            WorkflowTrigger workflowTrigger = new WorkflowTrigger();
            if (oozieWorkflow.getFrequency() != null) {
                workflowTrigger.setCron(oozieWorkflow.getFrequency());
                haveTriggerFlag = true;
            }
            if (oozieWorkflow.getStartTime() != null) {
                try {
                    formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm'Z'");
                    workflowTrigger.setStartTime(LocalDateTime.parse(oozieWorkflow.getStartTime(), formatter));
                    haveTriggerFlag = true;
                }
                catch (Exception e) {
                    log.warn("parse startTime error, startTime: {}", (Object)oozieWorkflow.getStartTime());
                }
            }
            if (oozieWorkflow.getEndTime() != null) {
                try {
                    formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm'Z'");
                    workflowTrigger.setEndTime(LocalDateTime.parse(oozieWorkflow.getEndTime(), formatter));
                    haveTriggerFlag = true;
                }
                catch (Exception e) {
                    log.warn("parse endTime error, endTime: {}", (Object)oozieWorkflow.getEndTime());
                }
            }
            if (oozieWorkflow.getTimeZone() != null) {
                try {
                    workflowTrigger.setTimezone(ZoneId.of(oozieWorkflow.getTimeZone()));
                    haveTriggerFlag = true;
                }
                catch (Exception e) {
                    log.warn("parse timeZone error, timeZone: {}", (Object)oozieWorkflow.getTimeZone());
                }
            }
            if (haveTriggerFlag.booleanValue()) {
                workflow.setTriggers(List.of(workflowTrigger));
            }
            if (oozieWorkflow.getDataEvents() != null && oozieWorkflow.getDataEvents().size() > 0) {
                for (OozieDataEvent oozieDataEvent : oozieWorkflow.getDataEvents()) {
                    String dataset = oozieDataEvent.getDataset();
                    Boolean datasetFlag = false;
                    WorkflowDatasource datasource = new WorkflowDatasource();
                    datasource.setName(dataset);
                    datasource.setCustomProperties(new HashMap());
                    for (OozieDataSet oozieDataSet : oozieWorkflow.getDataSets().getDatasets()) {
                        if (dataset != oozieDataSet.getName()) continue;
                        datasource.getCustomProperties().put("frequency", oozieDataSet.getFrequency());
                        datasource.getCustomProperties().put("initialInstance", oozieDataSet.getInitialInstance());
                        datasource.getCustomProperties().put("timezone", oozieDataSet.getTimezone());
                        datasource.getCustomProperties().put("uriTemplate", oozieDataSet.getUriTemplate());
                        datasetFlag = true;
                        break;
                    }
                    if (!datasetFlag.booleanValue() && oozieWorkflow.getDataSets().getSharedDatasets() != null) {
                        Object shareDs = "";
                        for (String ds3 : oozieWorkflow.getDataSets().getSharedDatasets()) {
                            shareDs = (String)shareDs + ";" + ds3;
                        }
                        shareDs = ((String)shareDs).substring(1);
                        datasource.getCustomProperties().put("sharedDatasets", shareDs);
                    }
                    if (workflowProjectPackage.getDatasources() == null) {
                        workflowProjectPackage.setDatasources(new ArrayList());
                    }
                    workflowProjectPackage.getDatasources().add(datasource);
                }
            }
            ArrayList<WorkflowNode> workflowNodes = new ArrayList<WorkflowNode>();
            for (OozieWorkflowNode oozieWorkflowNode : oozieWorkflow.getNodes()) {
                WorkflowNode workflowNode = new WorkflowNode();
                workflowNode.setNodeName(oozieWorkflowNode.getName());
                workflowNode.setNodeId(oozieWorkflowNode.getId());
                workflowNode.setNodeType(oozieWorkflowNode.getType().getName());
                HashMap<String, String> propertiesMap = new HashMap<String, String>();
                propertiesMap.put("logMessage", oozieWorkflowNode.getLogMessage());
                propertiesMap.put("condition", oozieWorkflowNode.getConditionString());
                propertiesMap.put("resourceManager", oozieWorkflowNode.getResourceManager());
                propertiesMap.put("nameNode", oozieWorkflowNode.getNameNode());
                propertiesMap.put("jobXml", oozieWorkflowNode.getJobXml());
                if (oozieWorkflowNode.getConf() != null && oozieWorkflowNode.getConf().size() > 0) {
                    propertiesMap.putAll(oozieWorkflowNode.getConf());
                }
                propertiesMap.put("failTarget", oozieWorkflowNode.getFailTarget());
                propertiesMap.put("configClass", oozieWorkflowNode.getConfigClass());
                propertiesMap.put("appPath", oozieWorkflowNode.getAppPath());
                if (oozieWorkflowNode.getPropagratedConfiguration() != null) {
                    propertiesMap.put("propagratedConfiguration", oozieWorkflowNode.getPropagratedConfiguration().toString());
                } else {
                    propertiesMap.put("propagratedConfiguration", null);
                }
                propertiesMap.put("javaMainClass", oozieWorkflowNode.getJavaMainClass());
                propertiesMap.put("javaOpts", oozieWorkflowNode.getJavaOpts());
                if (oozieWorkflowNode.getCaptureOutput() != null) {
                    propertiesMap.put("captureOutput", oozieWorkflowNode.getCaptureOutput().toString());
                } else {
                    propertiesMap.put("captureOutput", null);
                }
                if (oozieWorkflowNode.getPrepare() != null) {
                    propertiesMap.put("prepareScript", oozieWorkflowNode.getPrepareString());
                } else {
                    propertiesMap.put("prepareScript", null);
                }
                if (oozieWorkflowNode.getArgumentList() != null) {
                    propertiesMap.put("argumentList", oozieWorkflowNode.getArgumentList().toString());
                } else {
                    propertiesMap.put("argumentList", null);
                }
                workflowNode.setCustomProperties(propertiesMap);
                workflowNode.setScript(oozieWorkflowNode.getScript());
                ArrayList<WorkflowFileResource> files = new ArrayList<WorkflowFileResource>();
                if (oozieWorkflowNode.getFilePathList() != null && oozieWorkflowNode.getFilePathList().size() > 0) {
                    for (String filePath : oozieWorkflowNode.getFilePathList()) {
                        WorkflowFileResource workflowFileResource = new WorkflowFileResource();
                        workflowFileResource.setPath(filePath);
                        workflowFileResource.setFileType("file");
                        files.add(workflowFileResource);
                    }
                }
                if (oozieWorkflowNode.getArchivePathList() != null && oozieWorkflowNode.getArchivePathList().size() > 0) {
                    for (Object archivePath : oozieWorkflowNode.getArchivePathList()) {
                        WorkflowFileResource workflowFileResource = new WorkflowFileResource();
                        workflowFileResource.setPath((String)archivePath);
                        workflowFileResource.setFileType("archive");
                        files.add(workflowFileResource);
                    }
                }
                workflowNode.setFiles(files);
                if (oozieWorkflowNode.getParamsList() != null && oozieWorkflowNode.getParamsList().size() > 0) {
                    Object archivePath;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    archivePath = oozieWorkflowNode.getParamsList().iterator();
                    while (archivePath.hasNext()) {
                        String string = (String)archivePath.next();
                        String[] paramArray = string.split("=");
                        hashMap.put(paramArray[0], paramArray[1]);
                    }
                    workflowNode.setParamMap(hashMap);
                }
                if (oozieWorkflowNode.getStreaming() != null) {
                    Datasource datasource = new Datasource();
                    datasource.setName("oozie_streaming");
                    HashMap<String, String> prop = new HashMap<String, String>();
                    prop.put("mapperProcess", oozieWorkflowNode.getStreaming().getMapperProcess());
                    prop.put("reducerProcess", oozieWorkflowNode.getStreaming().getReducerProcess());
                    prop.put("recordReaderClass", oozieWorkflowNode.getStreaming().getRecordReaderClass());
                    if (oozieWorkflowNode.getStreaming().getRecordReaderMappingList() != null) {
                        prop.put("recordReaderMappingList", oozieWorkflowNode.getStreaming().getRecordReaderMappingList().toString());
                    } else {
                        prop.put("recordReaderMappingList", null);
                    }
                    if (oozieWorkflowNode.getStreaming().getEnvValueList() != null) {
                        prop.put("envValueList", oozieWorkflowNode.getStreaming().getEnvValueList().toString());
                    } else {
                        prop.put("envValueList", null);
                    }
                    datasource.setProperties((Map)prop);
                }
                if (oozieWorkflowNode.getPipes() != null && oozieWorkflowNode.getPipes().size() > 0) {
                    ArrayList<Datasource> arrayList = new ArrayList<Datasource>();
                    for (Pair pair : oozieWorkflowNode.getPipes()) {
                        Datasource datasource = new Datasource();
                        datasource.setName("oozie_pipe_" + (String)pair.getKey());
                        datasource.setFilePath(List.of((String)pair.getValue()));
                        arrayList.add(datasource);
                    }
                }
                String string = "hadoop fs -";
                if (oozieWorkflowNode.getOperationList() != null && oozieWorkflowNode.getOperationList().size() > 0) {
                    StringBuilder scriptBuilder = new StringBuilder();
                    for (OozieFSOperation operation : oozieWorkflowNode.getOperationList()) {
                        switch (operation.getType()) {
                            case MOVE: {
                                scriptBuilder.append(string).append("mv").append(" ").append(operation.getSource()).append(" ").append(operation.getTarget()).append("\n");
                                break;
                            }
                            case DELETE: {
                                scriptBuilder.append(string).append("rm -r").append(" ");
                                if (operation.getSkipTrash() != null && operation.getSkipTrash().booleanValue()) {
                                    scriptBuilder.append("-skipTrash ");
                                }
                                scriptBuilder.append("'").append(operation.getPath()).append("'\n");
                                break;
                            }
                            case MKDIR: {
                                scriptBuilder.append(string).append("mkdir").append(" ").append(operation.getPath()).append("\n");
                                break;
                            }
                            case CHMOD: {
                                scriptBuilder.append(string).append("chmod").append(" ");
                                if (operation.getDirFiles() != null && operation.getDirFiles().booleanValue()) {
                                    scriptBuilder.append("-R").append(" ");
                                }
                                scriptBuilder.append(operation.getPermissions()).append(" ").append(operation.getPath()).append("\n");
                                break;
                            }
                            case TOUCHZ: {
                                scriptBuilder.append(string).append("touchz").append(" ").append(operation.getPath()).append("\n");
                                break;
                            }
                            case SETREP: {
                                scriptBuilder.append(string).append("setrep -w").append(" ").append(operation.getReplicationFactor()).append(" ").append(operation.getPath()).append("\n");
                                break;
                            }
                            case CHGRP: {
                                scriptBuilder.append(string).append("chgrp").append(" ");
                                if (operation.getDirFiles() != null && operation.getDirFiles().booleanValue()) {
                                    scriptBuilder.append("-R").append(" ");
                                }
                                scriptBuilder.append(operation.getGroup()).append(" ").append(operation.getPath()).append("\n");
                                break;
                            }
                        }
                    }
                    workflowNode.setScript(scriptBuilder.toString());
                }
                workflowNodes.add(workflowNode);
            }
            ArrayList<RelationPackage> arrayList = new ArrayList<RelationPackage>();
            for (OozieWorkflowNode oozieWorkflowNode : oozieWorkflow.getNodes()) {
                WorkflowNode thisNode = null;
                for (WorkflowNode workflowNode : workflowNodes) {
                    if (!workflowNode.getNodeName().equals(oozieWorkflowNode.getName())) continue;
                    thisNode = workflowNode;
                    break;
                }
                if (oozieWorkflowNode.getChildNodeList() == null) continue;
                for (String string : oozieWorkflowNode.getChildNodeList()) {
                    RelationPackage relationPackage = RelationPackage.builder().from(thisNode.getNodeId()).to(string).reType(RelationPackage.ReType.NODE).build();
                    arrayList.add(relationPackage);
                }
            }
            workflow.setNodeRelations(arrayList);
            workflow.setWorkflowNodes(workflowNodes);
            workflowList.add(workflow);
        }
        workflowProjectPackage.setWorkflowList(workflowList);
        return workflowProjectPackage;
    }
}

