/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.resource.impl;

import com.alibaba.securitysdk.logging.utils.CopyOnWriteLinkedHashMap;
import com.alibaba.securitysdk.resource.FileResourceLoader;
import com.alibaba.securitysdk.resource.exception.ResourceSwapException;
import com.alibaba.securitysdk.resource.impl.WatchableFileResource;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopyOnWriteMapWatchableFileResource<K, V>
extends WatchableFileResource<Map<K, V>> {
    private static final Logger LOGGER = Logger.getLogger(CopyOnWriteMapWatchableFileResource.class.getName());
    private volatile CopyOnWriteLinkedHashMap<K, V> copyOnWriteLinkedHashMap;
    private final boolean fastFail;

    public CopyOnWriteMapWatchableFileResource(FileResourceLoader<Map<K, V>> resourceLoader) {
        this(resourceLoader, true);
    }

    public CopyOnWriteMapWatchableFileResource(FileResourceLoader<Map<K, V>> resourceLoader, boolean fastFail) {
        super(resourceLoader);
        this.fastFail = fastFail;
    }

    @Override
    public void swap(Map<K, V> map) {
        this.copyOnWriteLinkedHashMap.replaceBy(map);
    }

    @Override
    public void initialize(Map<K, V> initMap) throws ResourceSwapException {
        block5: {
            this.copyOnWriteLinkedHashMap = initMap == null ? new CopyOnWriteLinkedHashMap() : new CopyOnWriteLinkedHashMap(initMap);
            try {
                super.initialize(initMap);
            }
            catch (ResourceSwapException exception) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, exception.getMessage(), exception);
                } else if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, exception.getMessage());
                }
                if (!this.fastFail) break block5;
                throw exception;
            }
        }
    }

    @Override
    public CopyOnWriteLinkedHashMap<K, V> getResource() {
        return this.copyOnWriteLinkedHashMap;
    }

    public V get(K key) {
        return (V)this.copyOnWriteLinkedHashMap.get(key);
    }
}

