/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.service;

import com.aliyun.migration.teleport.cloud.dataworks.DataWorksEndpoint;
import com.aliyun.migration.teleport.cloud.entity.BrokerProperties;
import com.aliyun.migration.teleport.cloud.entity.DataWorksResourceGroupDTO;
import com.aliyun.migration.teleport.cloud.entity.MnsProperties;
import com.aliyun.migration.teleport.cloud.entity.SecurityUserInfo;
import com.aliyun.migration.teleport.cloud.entity.SinkProperties;
import com.aliyun.migration.teleport.cloud.entity.StsProperties;
import com.aliyun.migration.teleport.cloud.enums.CloudAccessType;
import com.aliyun.migration.teleport.cloud.enums.DeployEnv;
import com.aliyun.migration.teleport.cloud.enums.EnvEnums;
import com.aliyun.migration.teleport.cloud.mns.MnsEndpoint;
import com.aliyun.migration.teleport.cloud.oss.OssEndpoint;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class PropertiesBuilder {
    private static final Logger log = LoggerFactory.getLogger(PropertiesBuilder.class);

    public static SinkProperties buildOssProperties(String region, DeployEnv env, @Nullable SecurityUserInfo securityUser) {
        OssEndpoint ossEndpoint = OssEndpoint.of(region, env);
        if (securityUser != null) {
            return SinkProperties.builder().loginType(CloudAccessType.STS).accessKeyId(securityUser.getAccessKeyId()).accessKeySecret(securityUser.getAccessKeySecret()).securityToken(securityUser.getSessionToken()).endpoint(ossEndpoint.getVpcEndpoint()).regionId(ossEndpoint.getRegion()).bucket(ossEndpoint.getBucket()).build().encrypt();
        }
        return SinkProperties.builder().loginType(CloudAccessType.AK).regionId(region).accessKeyId(EnvEnums.getValue(EnvEnums.LHM_OSS_AK)).accessKeySecret(EnvEnums.getValue(EnvEnums.LHM_OSS_SK)).endpoint(DeployEnv.LOCAL.equals((Object)env) ? ossEndpoint.getPublicEndpoint() : ossEndpoint.getVpcEndpoint()).bucket(ossEndpoint.getBucket()).build();
    }

    public static BrokerProperties buildDataWorksProperties(DataWorksResourceGroupDTO resourceGroup, @Nullable SecurityUserInfo securityUser) {
        if (resourceGroup == null) {
            throw new TeleportException(TeleportStatusCode.SERVERLESS_RESOURCE_GROUP_IS_NOT_EXIST);
        }
        String region = resourceGroup.getRegionId();
        DataWorksEndpoint endpoint = DataWorksEndpoint.of(region);
        if (securityUser == null) {
            return BrokerProperties.builder().loginType(CloudAccessType.AK).regionId(region).accessKeyId(EnvEnums.getValue(EnvEnums.LHM_DW_AK)).accessKeySecret(EnvEnums.getValue(EnvEnums.LHM_DW_SK)).projectId(Long.parseLong(resourceGroup.getProjectId())).owner(String.valueOf(resourceGroup.getOwner())).endpoint(endpoint.getPublicEndpoint()).build();
        }
        return BrokerProperties.builder().loginType(CloudAccessType.STS).accessKeyId(securityUser.getAccessKeyId()).accessKeySecret(securityUser.getAccessKeySecret()).securityToken(securityUser.getSessionToken()).regionId(region).projectId(Long.parseLong(resourceGroup.getProjectId())).owner(String.valueOf(resourceGroup.getOwner())).endpoint(endpoint.getPublicEndpoint()).build();
    }

    public static StsProperties buildStsProperties(String region) {
        return StsProperties.builder().aklessRamRoleArn(EnvEnums.getValue(EnvEnums.LHM_STS_AKLESS_ARN)).uid(EnvEnums.getValue(EnvEnums.LHM_STS_UID)).stsRole(EnvEnums.getValue(EnvEnums.LHM_STS_ROLE)).roleSessionName("LHMRoleSessionName").region(region).build();
    }

    public static StsProperties buildSlrProperties4DataWorks(String tenantId, String region) {
        return StsProperties.builder().uid(tenantId).accessKeyId(EnvEnums.getValue(EnvEnums.LHM_SLR_AK)).accessKeySecret(EnvEnums.getValue(EnvEnums.LHM_SLR_SK)).aklessRamRoleArn(EnvEnums.getValue(EnvEnums.LHM_SLR_AKLESS_ARN)).stsEndpoint(String.format("sts-vpc-inner.%s.aliyuncs.com", region)).stsRole("aliyunserviceroleforlhm").roleSessionName(String.format("%s@S@%s", region, tenantId)).region(region).build();
    }

    public static MnsProperties buildMnsProperties(String region, DeployEnv env, String parentId, String namespace) {
        MnsEndpoint endpoint = new MnsEndpoint(region, parentId, env, namespace);
        return PropertiesBuilder.buildMnsProperties(env, endpoint);
    }

    private static MnsProperties buildMnsProperties(DeployEnv env, MnsEndpoint endpoint) {
        MnsProperties properties = new MnsProperties();
        if (DeployEnv.LOCAL.equals((Object)env)) {
            properties.setAccessKeyId(EnvEnums.getValue(EnvEnums.LHM_MNS_AK));
            properties.setAccessKeySecret(EnvEnums.getValue(EnvEnums.LHM_MNS_SK));
            properties.setEndpoint(endpoint.getPublicEndpoint());
        } else {
            properties.setAklessRamRoleArn(EnvEnums.getValue(EnvEnums.LHM_MNS_AKLESS_ARN));
            properties.setEndpoint(endpoint.getPublicEndpoint());
        }
        properties.setQueueName(endpoint.getQueueName());
        return properties;
    }
}

